/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.plugin.setup;

import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.taskplanner.i18n.InventoryTaskPlannerMsg;
import com.inet.id.GUID;
import com.inet.setupwizard.api.AutoSetupStep;
import com.inet.setupwizard.api.EmptyStepConfig;
import com.inet.setupwizard.api.InfoMessageGetter;
import com.inet.setupwizard.api.SetupStep;
import com.inet.setupwizard.api.SetupStepPriority;
import com.inet.setupwizard.api.StepExecutionException;
import com.inet.setupwizard.api.StepExecutionProgressListener;
import com.inet.setupwizard.api.StepKey;
import com.inet.setupwizard.basicsteps.UserManagerWait;
import com.inet.shared.utils.Version;
import com.inet.taskplanner.server.api.TaskDefinition;
import com.inet.taskplanner.server.api.TaskPlanner;
import com.inet.taskplanner.server.api.series.SeriesDefinition;
import java.util.Map;
import javax.annotation.Nullable;

public class DeviceWarrantySeriesMigrationSetupStep
extends AutoSetupStep {
    public static final StepKey KEY = new StepKey("DeviceWarrantyMigrationStep");

    public StepKey stepKey() {
        return KEY;
    }

    public String getStepDisplayName() {
        return InventoryTaskPlannerMsg.MSG.getMsg("DeviceWarrantyMigrationStep", new Object[0]);
    }

    @Nullable
    public Version getMigrationVersion() {
        return new Version("25.4.68");
    }

    public boolean hasPendingTasks() {
        return true;
    }

    protected TaskPlanner getTaskPlanner() {
        return TaskPlanner.getInstance();
    }

    public void execute(EmptyStepConfig stepConfig, Map<String, String> metaData) throws StepExecutionException {
        UserManagerWait.waitForUserManagerVeto((StepExecutionProgressListener)this.getStepExecutionProgressListener(), (SetupStep)this);
        TaskPlanner taskPlanner = this.getTaskPlanner();
        for (GUID taskID : taskPlanner.getAllTaskIDs()) {
            TaskDefinition taskDef = taskPlanner.getTaskDefinition(taskID);
            if (taskDef == null) continue;
            boolean updateDef = false;
            SeriesDefinition series = taskDef.getSeries();
            if (series != null && "series.helpdesk.devicewarrantyendapproaching".equals(series.getExtensionName())) {
                SeriesDefinition migratedSeries = new SeriesDefinition("series.helpdesk.devicewarrantyendapproaching");
                boolean includeExpired = true;
                String beforeOrAfter = "before";
                if (!Boolean.valueOf(series.getProperty("alreadyExpired")).booleanValue()) {
                    includeExpired = false;
                    beforeOrAfter = "between";
                }
                migratedSeries.setProperty("whichField", AssetFields.FIELD_WARRANTY.getFieldKey());
                migratedSeries.setProperty("beforeOrAfter", beforeOrAfter);
                migratedSeries.setProperty("warrantytime", includeExpired ? series.getProperty("warrantytime") : "atexecution");
                migratedSeries.setProperty("warrantytime2", includeExpired ? "atexecution" : series.getProperty("warrantytime"));
                migratedSeries.setProperty("deviceTypeFilter", series.getProperty("deviceTypeFilter"));
                taskDef.setSeries(migratedSeries);
                updateDef = true;
            }
            if (!updateDef) continue;
            taskPlanner.updateTask(taskID, taskDef);
        }
    }

    public SetupStepPriority getPriority() {
        return new SetupStepPriority(5221);
    }

    public InfoMessageGetter getExecutionInfoMessage(EmptyStepConfig stepConfig) {
        return () -> InventoryTaskPlannerMsg.MSG.getMsg("DeviceWarrantyMigrationStep", new Object[0]);
    }
}

