/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.internal.tree;

import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.AssetFieldName;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.AssetNodeIdentifier;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.settings.StructureViewSettings;
import com.inet.helpdesk.plugins.inventory.server.internal.search.ValueAndDisplayValue;
import com.inet.helpdesk.plugins.inventory.server.internal.tree.InternalTreeNode;
import com.inet.helpdesk.plugins.inventory.server.internal.tree.TreeClientHandling;
import com.inet.id.GUID;
import com.inet.plugin.DynamicExtension;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.PrefilteredSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.index.IndexSearchEngine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nonnull;

class ListClientHandling {
    private static final DynamicExtension<AssetFieldDefinition> ASSET_FIELDS = new DynamicExtension(AssetFieldDefinition.class);
    private final StructureViewSettings settings;
    private final TreeClientHandling treeHandling;
    private final IndexSearchEngine<GUID> engine;
    private List<AssetFieldDefinition> columns;
    private Comparator<ValueAndDisplayValue<Object>>[] comparators;
    private HashMap<GUID, ValueAndDisplayValue<Object>[]> displayValues;
    private boolean deviceNodesVisible;
    private List<AssetFieldWithDefinition<?>> grouping;
    private int groupLevel;
    private int groupCount;
    private int hiddenGroupCount;
    private AssetFieldWithDefinition<Object>[] groupFields;
    private AssetNodeIdentifier structureRootParent;
    private AndSearchExpression filterSearchExpression;

    ListClientHandling(StructureViewSettings settings, TreeClientHandling treeHandling) {
        this.settings = settings;
        this.treeHandling = treeHandling;
        this.engine = AssetManager.getInstance().getSearchEngine();
    }

    AssetNodeIdentifier addSortedFlatList(InternalTreeNode rootNode, int nodeLimit) {
        this.grouping = this.treeHandling.getGrouping().getGroupBy();
        AssetNodeIdentifier rootId = rootNode.getId();
        AndSearchExpression search = this.createSearchExpression(rootId, this.grouping);
        if (search.isEmpty()) {
            search.add((SearchExpression)new SearchCondition(AssetFields.FIELD_NAME.getEntrySearchTag().getTag(), SearchCondition.SearchTermOperator.StartsWith, (Object)""));
        }
        SearchCommand command = new SearchCommand(new SearchExpression[]{search});
        Set<GUID> deviceIDs = this.engine.simpleSearch(command);
        if (rootId.isDevice()) {
            this.groupLevel = 0;
            this.groupCount = 0;
            this.deviceNodesVisible = true;
            deviceIDs = this.addRemoveChildrenLevels(rootId, deviceIDs, this.grouping);
        } else {
            this.groupLevel = rootId.getGrouping().size();
            this.groupCount = this.grouping.size() - this.groupLevel;
            if (this.groupCount < 0) {
                return null;
            }
            if (!this.settings.isListGroupings()) {
                this.hiddenGroupCount = this.groupCount;
                this.groupCount = 0;
            }
            if (this.groupCount < this.settings.getDepth()) {
                this.deviceNodesVisible = true;
            } else {
                this.deviceNodesVisible = false;
                this.groupCount = this.settings.getDepth();
            }
        }
        this.determineMinimalColumns(deviceIDs);
        Collection<GUID> sortedDeviceIDs = deviceIDs;
        if (deviceIDs.size() > 0) {
            int fullDeviceCount = deviceIDs.size();
            Comparator<GUID> comperator = this.createComparator(this.grouping, this.groupLevel, this.groupCount, deviceIDs, nodeLimit);
            if (deviceIDs.size() > 1) {
                ArrayList<GUID> deviceIdList = new ArrayList<GUID>(deviceIDs);
                deviceIdList.sort(comperator);
                sortedDeviceIDs = deviceIdList;
            }
            rootNode.setHasMoreNodes(deviceIDs.size() < fullDeviceCount);
        }
        if (this.addDeviceNodesTo(rootNode.getChildren(), sortedDeviceIDs, nodeLimit, rootId)) {
            rootNode.setHasMoreNodes(true);
        }
        rootNode.setHasChildren(rootNode.getChildren().size() > 0);
        if (rootId.isDevice()) {
            return this.structureRootParent;
        }
        return rootNode.makeParentNode();
    }

    @Nonnull
    List<AssetFieldDefinition> getColumns() {
        return this.columns;
    }

    private boolean addDeviceNodesTo(List<InternalTreeNode> target, Collection<GUID> deviceIds, int maxCount, AssetNodeIdentifier rootId) {
        int groupCount = this.groupCount;
        ValueAndDisplayValue<Object>[] lastDisplayValues = null;
        Comparator<ValueAndDisplayValue<Object>>[] comparators = this.comparators;
        AssetFieldWithDefinition<Object>[] groupFields = this.groupFields;
        AssetNodeIdentifier[] groupParents = new AssetNodeIdentifier[groupCount];
        boolean includeDeviceNodes = this.deviceNodesVisible;
        ArrayList<GUID> sortedNodeDeciceIDs = new ArrayList<GUID>();
        Iterator<GUID> it = deviceIds.iterator();
        while (target.size() + sortedNodeDeciceIDs.size() < maxCount && it.hasNext()) {
            GUID id = it.next();
            if (groupCount > 0) {
                ValueAndDisplayValue<Object>[] groupValues = this.displayValues.get(id);
                if (groupValues == null) continue;
                boolean changes = false;
                for (int g = 0; g < groupCount; ++g) {
                    ValueAndDisplayValue<Object> groupValue = groupValues[g];
                    if (lastDisplayValues != null && !changes && comparators[g].compare(lastDisplayValues[g], groupValue) == 0) continue;
                    this.addDeviceNodesTo_groupNodes(target, sortedNodeDeciceIDs, maxCount);
                    AssetFieldWithDefinition<Object> groupField = groupFields[g];
                    String fieldKey = groupField.getKey();
                    String value = groupField.asString(groupValue.getValue());
                    groupParents[g] = g == 0 ? new AssetNodeIdentifier(rootId, fieldKey, value) : new AssetNodeIdentifier(groupParents[g - 1], fieldKey, value);
                    AssetNodeIdentifier groupId = groupParents[g];
                    target.add(new InternalTreeNode(groupId));
                    changes = true;
                }
                lastDisplayValues = groupValues;
                if (!includeDeviceNodes) continue;
                sortedNodeDeciceIDs.add(id);
                continue;
            }
            if (!includeDeviceNodes) continue;
            sortedNodeDeciceIDs.add(id);
        }
        this.addDeviceNodesTo_groupNodes(target, sortedNodeDeciceIDs, maxCount);
        return it.hasNext();
    }

    private void addDeviceNodesTo_groupNodes(@Nonnull List<InternalTreeNode> target, @Nonnull ArrayList<GUID> sortedNodeDeciceIDs, int maxCount) {
        if (sortedNodeDeciceIDs.isEmpty()) {
            return;
        }
        int childLevel = this.settings.getDepth() - this.groupCount;
        Set<GUID> filteredDeciceIDs = this.hiddenGroupCount > 0 ? this.filterChildrenWithhHiddenGroups(this.grouping, this.groupLevel, this.hiddenGroupCount, new HashSet<GUID>(sortedNodeDeciceIDs)) : this.filterChildren(new HashSet<GUID>(sortedNodeDeciceIDs), childLevel);
        for (GUID deviceId : sortedNodeDeciceIDs) {
            if (!filteredDeciceIDs.contains(deviceId)) continue;
            InternalTreeNode node = new InternalTreeNode(new AssetNodeIdentifier(deviceId));
            node.setHasChildren(Boolean.FALSE);
            target.add(node);
            if (target.size() < maxCount) continue;
            break;
        }
        sortedNodeDeciceIDs.clear();
    }

    @Nonnull
    private AndSearchExpression createSearchExpression(AssetNodeIdentifier rootId, List<AssetFieldWithDefinition<?>> grouping) {
        AndSearchExpression search = new AndSearchExpression();
        this.filterSearchExpression = new AndSearchExpression();
        if (rootId.isDevice()) {
            AssetManager manager;
            AssetView device;
            GUID deviceID = rootId.getDeviceId();
            search.add((SearchExpression)new SearchCondition(AssetFields.FIELD_PARENT.getKey(), SearchCondition.SearchTermOperator.Equals, (Object)deviceID));
            if (!grouping.isEmpty() && (device = (manager = AssetManager.getInstance()).getAsset(deviceID)) != null) {
                GUID parentID = device.getParentID();
                AssetView parent = parentID != null ? manager.getAsset(parentID) : null;
                ArrayList<AssetNodeIdentifier.Grouping> parentNodeGroupings = new ArrayList<AssetNodeIdentifier.Grouping>();
                for (AssetFieldWithDefinition<?> groupField : grouping) {
                    Object value = device.getValue(groupField);
                    this.filterSearchExpression.add((SearchExpression)new SearchCondition(groupField.getEntrySearchKey(), SearchCondition.SearchTermOperator.Equals, value));
                    parentNodeGroupings.add(new AssetNodeIdentifier.Grouping(groupField.getKey(), groupField.asString(value)));
                    if (parent == null || Objects.equals(value, parent.getValue(groupField))) continue;
                    parent = null;
                    parentID = null;
                }
                this.structureRootParent = parentID != null ? new AssetNodeIdentifier(parentID) : new AssetNodeIdentifier(parentNodeGroupings);
            }
            this.filterSearchExpression.addAll((Collection)this.treeHandling.getSearchCommand().getSearchExpression());
        } else {
            for (AssetNodeIdentifier.Grouping group : rootId.getGrouping()) {
                AssetFieldWithDefinition fieldFor = (AssetFieldWithDefinition)AssetFields.getFieldFor(group.getFieldKey());
                search.add((SearchExpression)fieldFor.createCondition(group.getFieldValue()));
            }
            search.addAll((Collection)this.treeHandling.getSearchCommand().getSearchExpression());
        }
        return search;
    }

    @Nonnull
    private Set<GUID> filterOneLevel_selectedDevice(@Nonnull Set<GUID> deviceIDs) {
        AndSearchExpression search;
        if (this.filterSearchExpression.isEmpty() || deviceIDs.size() == 0) {
            return deviceIDs;
        }
        Set result = null;
        do {
            search = new AndSearchExpression();
            search.add((SearchExpression)new PrefilteredSearchExpression(deviceIDs));
            search.addAll((Collection)this.filterSearchExpression);
            Set matchingDeviceIDs = this.engine.simpleSearch(new SearchCommand(new SearchExpression[]{search}));
            if (result == null) {
                if (matchingDeviceIDs.size() == deviceIDs.size()) {
                    return deviceIDs;
                }
                result = matchingDeviceIDs;
            } else {
                result.addAll(matchingDeviceIDs);
                if (matchingDeviceIDs.size() == deviceIDs.size()) {
                    return result;
                }
            }
            deviceIDs.removeAll(matchingDeviceIDs);
            search = new AndSearchExpression();
            search.add((SearchExpression)new SearchCondition(AssetFields.FIELD_PARENT.getKey(), SearchCondition.SearchTermOperator.IN, deviceIDs));
        } while ((deviceIDs = this.engine.simpleSearch(new SearchCommand(new SearchExpression[]{search}))).size() != 0);
        return result;
    }

    @Nonnull
    private Set<GUID> addRemoveChildrenLevels(AssetNodeIdentifier rootId, @Nonnull Set<GUID> allMatchingIDs, @Nonnull List<AssetFieldWithDefinition<?>> grouping) {
        if (rootId.isDevice()) {
            Set<GUID> result = this.filterOneLevel_selectedDevice(allMatchingIDs);
            int childLevel = this.settings.getDepth();
            Set<GUID> parents = result;
            while (--childLevel > 0) {
                AndSearchExpression search = new AndSearchExpression();
                search.add((SearchExpression)new SearchCondition(AssetFields.FIELD_PARENT.getKey(), SearchCondition.SearchTermOperator.IN, parents));
                parents = this.engine.simpleSearch(new SearchCommand(new SearchExpression[]{search}));
                parents = this.filterOneLevel_selectedDevice(parents);
                result.addAll(parents);
            }
            return result;
        }
        return allMatchingIDs;
    }

    /*
     * WARNING - void declaration
     */
    @Nonnull
    private Set<GUID> filterChildren(@Nonnull Set<GUID> allMatchingIDs, int childLevel) {
        HashMap<GUID, Set<GUID>> allChildren = this.findChildren(allMatchingIDs);
        int initialCapacity = 0;
        for (Set<GUID> set : allChildren.values()) {
            initialCapacity += set.size();
        }
        Set<Object> allChildDevices = new HashSet(initialCapacity);
        for (Map.Entry<GUID, Set<GUID>> entry : allChildren.entrySet()) {
            allChildDevices.addAll((Collection)entry.getValue());
        }
        if (allChildDevices.isEmpty()) {
            return allMatchingIDs;
        }
        HashSet<GUID> hashSet = new HashSet<GUID>(allMatchingIDs.size());
        for (GUID id : allMatchingIDs) {
            if (allChildDevices.contains(id)) continue;
            hashSet.add(id);
        }
        HashSet<GUID> hashSet2 = hashSet;
        if (allMatchingIDs.getClass() != HashSet.class) {
            allMatchingIDs = new HashSet<GUID>(allMatchingIDs);
        }
        while (--childLevel > 0) {
            void var7_12;
            allMatchingIDs.removeAll((Collection<?>)var7_12);
            allChildDevices = this.findChildren(allChildren, initialCapacity, allMatchingIDs);
            if (allChildDevices.isEmpty()) {
                hashSet.addAll(allMatchingIDs);
                return hashSet;
            }
            HashSet<GUID> levelResult = new HashSet<GUID>();
            for (GUID id : allMatchingIDs) {
                if (allChildDevices.contains(id)) continue;
                levelResult.add(id);
            }
            hashSet.addAll(levelResult);
            HashSet<GUID> hashSet3 = levelResult;
        }
        return hashSet;
    }

    @Nonnull
    private HashMap<GUID, Set<GUID>> findChildren(@Nonnull Set<GUID> deviceIDs) {
        SearchCommand command = new SearchCommand(new SearchExpression[0]);
        AndSearchExpression search = command.getSearchExpression();
        search.add(null);
        int size = deviceIDs.size();
        HashMap<GUID, Set<GUID>> map = new HashMap<GUID, Set<GUID>>(size);
        HashSet<GUID> knownParents = new HashSet<GUID>(size);
        while (size > 0) {
            HashSet<GUID> newParents = new HashSet<GUID>(size);
            for (GUID id : deviceIDs) {
                if (knownParents.contains(id)) continue;
                knownParents.add(id);
                search.set(0, (Object)new SearchCondition(AssetFields.FIELD_PARENT.getKey(), SearchCondition.SearchTermOperator.Equals, (Object)id));
                Set set = this.engine.simpleSearch(command);
                if (set.size() <= 0) continue;
                map.put(id, set);
                newParents.addAll(set);
            }
            deviceIDs = newParents;
            size = deviceIDs.size();
        }
        return map;
    }

    @Nonnull
    private Set<GUID> findChildren(@Nonnull HashMap<GUID, Set<GUID>> map, int initialCapacity, @Nonnull Set<GUID> allParents) {
        HashSet<GUID> result = new HashSet<GUID>(initialCapacity);
        HashSet<GUID> knownParents = new HashSet<GUID>(initialCapacity);
        while (allParents.size() > 0) {
            HashSet<GUID> newParents = new HashSet<GUID>(initialCapacity);
            for (GUID id : allParents) {
                if (knownParents.contains(id)) continue;
                knownParents.add(id);
                Set<GUID> set = map.get(id);
                if (set == null) continue;
                result.addAll(set);
                newParents.addAll(set);
            }
            allParents = newParents;
        }
        return result;
    }

    private void determineMinimalColumns(Set<GUID> deviceIDs) {
        if (deviceIDs.isEmpty()) {
            this.columns = Arrays.asList(AssetFields.FIELD_NAME);
            return;
        }
        ArrayList<AssetFieldDefinition> fields = new ArrayList<AssetFieldDefinition>(ASSET_FIELDS.get());
        Iterator indexIt = this.engine.createValuesIterator(AssetFields.FIELD_TYPE.getEntrySearchTag(), null, id -> deviceIDs.contains(id));
        while (indexIt.hasNext()) {
            int fieldType = (Integer)indexIt.next();
            Iterator it = fields.iterator();
            while (it.hasNext()) {
                AssetFieldDefinition f = (AssetFieldDefinition)it.next();
                if (f.isVisibleInType(fieldType)) continue;
                it.remove();
            }
        }
        this.columns = fields;
    }

    @Nonnull
    private <T> Comparator<GUID> createComparator(List<AssetFieldWithDefinition<T>> grouping, int groupLevel, int groupCount, @Nonnull Set<GUID> deviceIDs, int nodeLimit) {
        int i;
        AssetFieldName sortField = this.settings.getList_sort_field();
        boolean forward = this.settings.isList_sort_ascending();
        boolean groupForward = true;
        if (sortField == null || !this.columns.contains(sortField)) {
            sortField = AssetFields.FIELD_NAME;
            forward = true;
        } else if (sortField == AssetFields.FIELD_NAME && !forward) {
            groupForward = false;
        }
        int valueCount = groupCount < this.settings.getDepth() ? groupCount + 1 : this.settings.getDepth();
        Comparator[] comparators = new Comparator[valueCount];
        AssetFieldWithDefinition[] groupFields = new AssetFieldWithDefinition[groupCount];
        HashMap<GUID, ValueAndDisplayValue<T>[]> displayValues = new HashMap<GUID, ValueAndDisplayValue<T>[]>();
        for (i = groupLevel; i < groupLevel + groupCount; ++i) {
            AssetFieldWithDefinition<T> groupSortField = grouping.get(i);
            int layer = i - groupLevel;
            comparators[layer] = this.createComparator_setDisplayValues(displayValues, groupSortField, layer, valueCount, deviceIDs, nodeLimit, groupForward);
            groupFields[layer] = groupSortField;
        }
        if (valueCount > groupCount) {
            comparators[groupCount] = this.createComparator_setDisplayValues(displayValues, sortField, groupCount, valueCount, deviceIDs, nodeLimit, forward);
        }
        this.comparators = comparators;
        this.displayValues = displayValues;
        this.groupFields = groupFields;
        if (!this.deviceNodesVisible && deviceIDs.size() > 2 * nodeLimit) {
            for (i = groupLevel; i < groupLevel + groupCount && deviceIDs.size() > 2 * nodeLimit && this.reduceDeviceIDs(deviceIDs, nodeLimit, displayValues, grouping.get(i), comparators[i - groupLevel]); ++i) {
            }
        }
        boolean forward_ = forward;
        return (deviceId1, deviceId2) -> {
            ValueAndDisplayValue[] s1 = (ValueAndDisplayValue[])displayValues.get(deviceId1);
            ValueAndDisplayValue[] s2 = (ValueAndDisplayValue[])displayValues.get(deviceId2);
            if (s1 == null) {
                return s2 == null ? 0 : -1;
            }
            if (s2 == null) {
                return 1;
            }
            for (int i = 0; i < valueCount; ++i) {
                Comparator comp = comparators[i];
                int c = comp.compare(s1[i], s2[i]);
                if (c == 0) continue;
                return c;
            }
            return forward_ ? deviceId1.compareTo(deviceId2) : deviceId2.compareTo(deviceId1);
        };
    }

    private <T> Comparator<ValueAndDisplayValue<T>> createComparator_setDisplayValues(HashMap<GUID, ValueAndDisplayValue<T>[]> displayValues, AssetFieldWithDefinition<T> sortField, int layer, int valueCount, @Nonnull Set<GUID> deviceIDs, int nodeLimit, boolean forward) {
        Comparator<ValueAndDisplayValue<T>> comparator = sortField.getComparator();
        if (!forward) {
            comparator = Collections.reverseOrder(comparator);
        }
        Iterator<Map.Entry<Object, Set<GUID>>> it = this.engine.createEntryIterator(sortField.getEntrySearchTag(), null, id -> deviceIDs.contains(id));
        if (layer == 0 && this.deviceNodesVisible && deviceIDs.size() > 2 * nodeLimit) {
            TreeMap<ValueAndDisplayValue<T>, Map.Entry<Object, Set<GUID>>> map = this.createSortedTreeMapFromIndex(sortField, comparator, it);
            Set<GUID> toLevelDeviceIDs = this.filterChildren(deviceIDs, 1);
            int topLevelCount = 0;
            it = map.values().iterator();
            HashSet<GUID> set = new HashSet<GUID>(nodeLimit);
            while (topLevelCount < nodeLimit && it.hasNext()) {
                for (GUID id2 : it.next().getValue()) {
                    set.add(id2);
                    if (!toLevelDeviceIDs.contains(id2)) continue;
                    ++topLevelCount;
                }
            }
            Iterator<GUID> deviceID = deviceIDs.iterator();
            while (deviceID.hasNext()) {
                GUID id2;
                id2 = deviceID.next();
                if (set.contains(id2)) continue;
                deviceID.remove();
            }
            it = map.values().iterator();
        }
        while (it.hasNext()) {
            Object key;
            Map.Entry e = (Map.Entry)it.next();
            Object indexedValue = e.getKey();
            ValueAndDisplayValue displayValue = new ValueAndDisplayValue(key, (key = sortField.getValueFromIndexedValue(indexedValue)) == null ? "" : sortField.getDisplayValue(key));
            for (GUID guid : (Set)e.getValue()) {
                ValueAndDisplayValue<T>[] value = displayValues.get(guid);
                if (value == null) {
                    value = new ValueAndDisplayValue[valueCount];
                    displayValues.put(guid, value);
                }
                value[layer] = displayValue;
            }
        }
        return comparator;
    }

    @Nonnull
    private <T> TreeMap<ValueAndDisplayValue<T>, Map.Entry<Object, Set<GUID>>> createSortedTreeMapFromIndex(AssetFieldWithDefinition<T> sortField, Comparator<ValueAndDisplayValue<T>> comparator, Iterator<Map.Entry<Object, Set<GUID>>> it) {
        TreeMap<ValueAndDisplayValue<T>, Map.Entry<Object, Set<GUID>>> map = new TreeMap<ValueAndDisplayValue<T>, Map.Entry<Object, Set<GUID>>>(comparator);
        while (it.hasNext()) {
            Object key;
            Map.Entry<Object, Set<GUID>> e = it.next();
            Object indexedValue = e.getKey();
            ValueAndDisplayValue displayValue = new ValueAndDisplayValue(key, (key = sortField.getValueFromIndexedValue(indexedValue)) == null ? "" : sortField.getDisplayValue(key));
            map.put(displayValue, e);
        }
        return map;
    }

    private <T> boolean reduceDeviceIDs(Set<GUID> deviceIDs, int nodeLimit, HashMap<GUID, ValueAndDisplayValue<T>[]> displayValues, AssetFieldWithDefinition<T> sortField, Comparator<ValueAndDisplayValue<T>> comparator) {
        HashSet<String> keySet = new HashSet<String>();
        HashSet<GUID> idSet = new HashSet<GUID>();
        StringBuilder keyBuilder = new StringBuilder();
        int entryCount = 0;
        Iterator<Map.Entry<Object, Set<GUID>>> it = this.engine.createEntryIterator(sortField.getEntrySearchTag(), null, id -> deviceIDs.contains(id));
        it = this.createSortedTreeMapFromIndex(sortField, comparator, it).values().iterator();
        while (idSet.size() < nodeLimit && it.hasNext()) {
            Map.Entry<Object, Set<GUID>> e = it.next();
            ++entryCount;
            for (GUID id2 : e.getValue()) {
                keyBuilder.setLength(0);
                ValueAndDisplayValue<T>[] values = displayValues.get(id2);
                if (values == null) continue;
                for (ValueAndDisplayValue<T> val : values) {
                    keyBuilder.append(val).append("\n|\n");
                }
                if (!keySet.add(keyBuilder.toString())) {
                    deviceIDs.remove(id2);
                    continue;
                }
                idSet.add(id2);
            }
        }
        Iterator<GUID> idIt = deviceIDs.iterator();
        while (idIt.hasNext()) {
            GUID id3 = idIt.next();
            if (idSet.contains(id3)) continue;
            idIt.remove();
        }
        return entryCount == 1;
    }

    @Nonnull
    private <T> Set<GUID> filterChildrenWithhHiddenGroups(List<AssetFieldWithDefinition<T>> grouping, int groupLevel, int hiddenGroupCount, @Nonnull Set<GUID> allMatchingIDs) {
        HashSet<GUID> result = new HashSet<GUID>(allMatchingIDs.size());
        int nextLevel = groupLevel + 1;
        AssetFieldWithDefinition<T> groupField = grouping.get(groupLevel);
        Comparator<ValueAndDisplayValue<T>> comparator = groupField.getComparator();
        Iterator<Map.Entry<Object, Set<GUID>>> it = this.engine.createEntryIterator(groupField.getEntrySearchTag(), null, id -> allMatchingIDs.contains(id));
        TreeMap<ValueAndDisplayValue<T>, Map.Entry<Object, Set<GUID>>> map = this.createSortedTreeMapFromIndex(groupField, comparator, it);
        it = map.values().iterator();
        while (it.hasNext()) {
            Set<GUID> ids = it.next().getValue();
            if (nextLevel < hiddenGroupCount) {
                result.addAll(this.filterChildrenWithhHiddenGroups(grouping, nextLevel, hiddenGroupCount, ids));
                continue;
            }
            result.addAll(this.filterChildren(ids, this.settings.getDepth()));
        }
        return result;
    }
}

