/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.internal;

import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.MutableAssetData;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField;
import com.inet.helpdesk.plugins.inventory.server.internal.AssetDataCache;
import com.inet.helpdesk.plugins.inventory.server.internal.AssetViewImpl;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.thread.ServerLock;
import com.inet.thread.ThreadUtils;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserEventAdapter;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;

public class InheritedOwnerFieldChangedListener
extends UserEventAdapter {
    private static final Map<AssetField, UserField> FIELDS = Map.of(AssetFields.FIELD_ROOM, HDUsersAndGroups.FIELD_ROOM, AssetFields.FIELD_COSTCENTER, HDUsersAndGroups.FIELD_COST_CENTRE, AssetFields.FIELD_LOCATION, HDUsersAndGroups.FIELD_LOCATION_ID);
    private AssetDataCache cache;

    public InheritedOwnerFieldChangedListener(AssetDataCache cache) {
        this.cache = cache;
    }

    public void userAccountUpdated(@Nonnull UserAccount userAccountBefore, @Nonnull UserAccount userAccountAfter) {
        ForkJoinPool.commonPool().execute(() -> {
            if (this.wasInheritedFieldChanged(userAccountBefore, userAccountAfter)) {
                InventoryServerPlugin.LOGGER.info((Object)("Update inheritable fields in assets of user " + String.valueOf(userAccountAfter.getID())));
                Set assetsOfUser = AssetManager.getInstance().getSearchEngine().simpleSearch(new SearchCommand(new SearchExpression[]{new SearchCondition(AssetFields.FIELD_OWNER.getKey(), SearchCondition.SearchTermOperator.Equals, (Object)userAccountAfter.getID())}));
                assetsOfUser.forEach(assetId -> this.checkInheritedField(assetsOfUser, (GUID)assetId, userAccountBefore, userAccountAfter));
                InventoryServerPlugin.LOGGER.debug((Object)("Update inheritable fields of user " + String.valueOf(userAccountAfter.getID()) + " completed"));
            }
        });
    }

    private void checkInheritedField(Set<GUID> assetsOfUser, GUID assetId, @Nonnull UserAccount userAccountBefore, @Nonnull UserAccount userAccountAfter) {
        this.clearCacheDeep(assetId);
        boolean sendUpdate = false;
        try (ThreadUtils.Semaphore s = ThreadUtils.getSemaphore((Object)("device" + String.valueOf(assetId)));
             ServerLock lock = ThreadUtils.getLock((Object)s);){
            AssetView asset = this.cache.get(assetId);
            if (asset == null) {
                return;
            }
            MutableAssetData oldData = new MutableAssetData();
            for (Map.Entry<AssetField, UserField> fieldEntry : FIELDS.entrySet()) {
                Object oldValue = userAccountBefore.getValue(fieldEntry.getValue());
                Object newValue = userAccountAfter.getValue(fieldEntry.getValue());
                if (Objects.equals(newValue, oldValue)) continue;
                if (asset.isInherited(fieldEntry.getKey()) == AssetView.ValueSource.Owner && Objects.equals(asset.getOwner(), userAccountBefore.getID())) {
                    sendUpdate = true;
                    if (this.isNull(oldValue)) {
                        oldData.put(fieldEntry.getKey(), this.guessOldValue(asset, fieldEntry.getKey(), asset.getValue(AssetFields.FIELD_OWNER)));
                        continue;
                    }
                    oldData.put(fieldEntry.getKey(), oldValue);
                    continue;
                }
                if (this.isNull(newValue) && Objects.equals(asset.getOwner(), userAccountBefore.getID())) {
                    if (!this.isNull(asset.getOwnValue(fieldEntry.getKey()))) continue;
                    sendUpdate = true;
                    oldData.put(fieldEntry.getKey(), oldValue);
                    continue;
                }
                if (asset.isInherited(fieldEntry.getKey()) != AssetView.ValueSource.Parent || Objects.equals(asset.getOwner(), userAccountBefore.getID())) continue;
                sendUpdate = true;
                oldData.put(fieldEntry.getKey(), oldValue);
            }
            if (sendUpdate) {
                AssetViewImpl oldView = AssetViewImpl.create((AssetViewImpl)asset, oldData);
                this.cache.sendChangedEvendAndNotifyIndex(oldView, asset);
            }
        }
        if (sendUpdate) {
            Set childAssets = AssetManager.getInstance().getSearchEngine().simpleSearch(new SearchCommand(new SearchExpression[]{new SearchCondition(AssetFields.FIELD_PARENT.getKey(), SearchCondition.SearchTermOperator.Equals, (Object)assetId)}));
            childAssets.removeAll(assetsOfUser);
            childAssets.forEach(childAssetId -> this.checkInheritedField(assetsOfUser, (GUID)childAssetId, userAccountBefore, userAccountAfter));
        }
    }

    private void clearCacheDeep(GUID assetId) {
        AssetView asset = this.cache.get(assetId);
        if (asset == null) {
            return;
        }
        if (asset.getParentID() != null) {
            this.clearCacheDeep(asset.getParentID());
        }
        try (ThreadUtils.Semaphore s = ThreadUtils.getSemaphore((Object)("device" + String.valueOf(assetId)));
             ServerLock lock = ThreadUtils.getLock((Object)s);){
            this.cache.clearCache(assetId);
        }
    }

    private boolean isNull(Object oldValue) {
        return oldValue == null || oldValue instanceof String && StringFunctions.isEmpty((String)((String)oldValue));
    }

    private boolean wasInheritedFieldChanged(UserAccount userAccountBefore, UserAccount userAccountAfter) {
        for (UserField field : FIELDS.values()) {
            if (Objects.equals(userAccountBefore.getValue(field), userAccountAfter.getValue(field))) continue;
            return true;
        }
        return false;
    }

    private Object guessOldValue(AssetView asset, AssetField field, GUID ownerId) {
        AssetView parent;
        if (asset.getParentID() != null && !this.isNull((parent = this.cache.get(asset.getParentID())).getValue(field))) {
            if (Objects.equals(ownerId, parent.getValue(AssetFields.FIELD_OWNER)) && parent.isInherited(field) == AssetView.ValueSource.Owner) {
                return this.guessOldValue(parent, field, ownerId);
            }
            if (parent.isInherited(field) == AssetView.ValueSource.Parent) {
                return this.guessOldValue(parent, field, ownerId);
            }
            return parent.getValue(field);
        }
        return null;
    }
}

