/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.internal;

import com.inet.annotations.JsonData;
import com.inet.error.ErrorCode;
import com.inet.error.PersistenceException;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.error.HelpDeskErrorCodes;
import com.inet.helpdesk.core.error.HelpDeskServerException;
import com.inet.helpdesk.core.utils.sql.ResultSetIterator;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetVO;
import com.inet.helpdesk.plugins.inventory.server.api.model.HistoryStep;
import com.inet.helpdesk.plugins.inventory.server.api.model.MutableAssetData;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

public class AssetDAO {
    private static final String KEY_BINARYDETAILS = "fielddata";
    private Integer PARENT_NONE = -1;

    private Connection getConnection() throws SQLException {
        return ((ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class)).getConnection();
    }

    public AssetVO create(int id, GUID guid, MutableAssetData data) {
        Integer parentId = this.loadParentIdInt(data);
        try (Connection c = this.getConnection();
             PreparedStatement pst = c.prepareStatement("SELECT * from tblGeraeteBestand WHERE 1=0", 1005, 1008);
             ResultSet rs = pst.executeQuery();){
            rs.moveToInsertRow();
            rs.updateInt("GerID", id);
            rs.updateString("GerUUID", guid.toString());
            this.updateFieldsInColumn(data, rs, parentId);
            rs.insertRow();
            this.updateTblTicketBinary(c, id, data);
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        return this.get(guid);
    }

    public AssetVO update(GUID id, int gerIdInt, MutableAssetData data) {
        Integer parentId = this.loadParentIdInt(data);
        try (Connection c = this.getConnection();
             PreparedStatement pst = c.prepareStatement("SELECT * from tblGeraeteBestand WHERE GerUUID=?", 1005, 1008);){
            pst.setString(1, id.toString());
            try (ResultSet rs = pst.executeQuery();){
                if (!rs.next()) {
                    throw new IllegalStateException("No row exists for id " + String.valueOf(id));
                }
                this.updateFieldsInColumn(data, rs, parentId);
                rs.updateRow();
                this.updateTblTicketBinary(c, gerIdInt, data);
            }
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        return this.get(id);
    }

    private Integer loadParentIdInt(MutableAssetData data) {
        Integer parentId = null;
        if (data.containsKey(AssetFields.FIELD_PARENT)) {
            if (data.get(AssetFields.FIELD_PARENT) != null) {
                AssetVO parent = this.get(data.get(AssetFields.FIELD_PARENT));
                if (parent != null) {
                    parentId = parent.getValue(AssetFields.FIELD_INT_ID);
                }
            } else {
                return this.PARENT_NONE;
            }
        }
        return parentId;
    }

    private void updateFieldsInColumn(MutableAssetData data, ResultSet rs, Integer parentId) throws SQLException {
        this.updateStringIfExists("GerBezeichnung", AssetFields.FIELD_NAME, data, rs);
        this.updateIntIfExists("GTyID", AssetFields.FIELD_TYPE, data, rs);
        this.updateStringIfExists("Computername", AssetFields.FIELD_COMPUTERNAME, data, rs);
        this.updateDoubleIfExists("Preis", AssetFields.FIELD_PRICE, data, rs);
        this.updateStringIfExists("Seriennummer", AssetFields.FIELD_SERIAL_NUMBER, data, rs);
        this.updateStringIfExists("Anlagennummer", AssetFields.FIELD_ASSET_NUMBER, data, rs);
        this.updateIntIfExists("GebID", AssetFields.FIELD_LOCATION, data, rs);
        this.updateStringIfExists("Zimmer", AssetFields.FIELD_ROOM, data, rs);
        this.updateIntIfExists("SlaID", AssetFields.FIELD_SLA, data, rs);
        this.updateStringIfExists("Beschreibung", AssetFields.FIELD_DESCRIPTION, data, rs);
        this.updateIntIfExists("VerkID", AssetFields.FIELD_VENDOR, data, rs);
        this.updateStringIfExists("Kostenstelle", AssetFields.FIELD_COSTCENTER, data, rs);
        this.updateStringIfExists("Rechnungsnummer", AssetFields.FIELD_INVOICE_NUMBER, data, rs);
        this.updateIntIfExists("LizID", AssetFields.FIELD_LICENSE, data, rs);
        this.updateDateIfExists("KaufDatum", AssetFields.FIELD_PURCHASE_DATE, data, rs);
        this.updateDateIfExists("Gewaehrleistung", AssetFields.FIELD_WARRANTY, data, rs);
        this.updateStringIfExists("GerFeld1", AssetFields.getFieldFor("custom1"), data, rs);
        this.updateStringIfExists("GerFeld2", AssetFields.getFieldFor("custom2"), data, rs);
        this.updateStringIfExists("GerFeld3", AssetFields.getFieldFor("custom3"), data, rs);
        this.updateStringIfExists("GerFeld4", AssetFields.getFieldFor("custom4"), data, rs);
        this.updateStringIfExists("GerFeld5", AssetFields.getFieldFor("custom5"), data, rs);
        this.updateStringIfExists("GerFeld6", AssetFields.getFieldFor("custom6"), data, rs);
        this.updateStringIfExists("GerFeld7", AssetFields.getFieldFor("custom7"), data, rs);
        this.updateStringIfExists("GerFeld8", AssetFields.getFieldFor("custom8"), data, rs);
        this.updateStringIfExists("GerFeld9", AssetFields.getFieldFor("custom9"), data, rs);
        this.updateIntIfExists("ImpFlag", AssetFields.FIELD_IMPORTED, data, rs);
        this.updateStringIfExists("RefID", AssetFields.FIELD_IMPORTED_FROM_COLUMN, data, rs);
        this.updateStringIfExists("ImpName", AssetFields.FIELD_IMPORT_NAME, data, rs);
        if (data.containsKey(AssetFields.FIELD_OWNER)) {
            GUID user = data.get(AssetFields.FIELD_OWNER);
            if (user != null) {
                int userID = HDUsersAndGroups.getUserID((GUID)user);
                if (userID != -1) {
                    rs.updateInt("UserID", userID);
                } else {
                    rs.updateNull("UserID");
                }
            } else {
                rs.updateNull("UserID");
            }
        }
        if (parentId != null) {
            if (parentId.equals(this.PARENT_NONE)) {
                rs.updateNull("parentID");
            } else {
                rs.updateInt("parentID", (int)parentId);
            }
        }
    }

    private void updateStringIfExists(String column, AssetField<String> field, MutableAssetData data, ResultSet rs) throws SQLException {
        if (data.containsKey(field)) {
            String value = data.get(field);
            rs.updateString(column, value);
        }
    }

    private void updateIntIfExists(String column, AssetField<Integer> field, MutableAssetData data, ResultSet rs) throws SQLException {
        if (data.containsKey(field)) {
            Integer value = data.get(field);
            if (value != null) {
                rs.updateInt(column, (int)value);
            } else {
                rs.updateNull(column);
            }
        }
    }

    private void updateBoolIfExists(String column, AssetField<Boolean> field, MutableAssetData data, ResultSet rs) throws SQLException {
        if (data.containsKey(field)) {
            Boolean value = data.get(field);
            if (value != null) {
                rs.updateBoolean(column, (boolean)value);
            } else {
                rs.updateNull(column);
            }
        }
    }

    private void updateDoubleIfExists(String column, AssetField<Double> field, MutableAssetData data, ResultSet rs) throws SQLException {
        if (data.containsKey(field)) {
            Double value = data.get(field);
            if (value != null) {
                rs.updateDouble(column, (double)value);
            } else {
                rs.updateNull(column);
            }
        }
    }

    private void updateDateIfExists(String column, AssetField<Long> field, MutableAssetData data, ResultSet rs) throws SQLException {
        if (data.containsKey(field)) {
            Long value = data.get(field);
            if (value != null) {
                rs.updateTimestamp(column, new Timestamp(value));
            } else {
                rs.updateNull(column);
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public AssetVO archive(GUID id) {
        try (Connection c = this.getConnection();){
            AssetVO assetVO;
            block14: {
                PreparedStatement pst = c.prepareStatement("UPDATE tblGeraeteBestand SET archived = 1 WHERE GerUUID = ?");
                try {
                    pst.setString(1, id.toString());
                    pst.executeUpdate();
                    assetVO = this.get(id);
                    if (pst == null) break block14;
                }
                catch (Throwable throwable) {
                    if (pst != null) {
                        try {
                            pst.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pst.close();
            }
            return assetVO;
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public AssetVO get(GUID id) {
        List<AssetVO> loadDevices = this.loadDevices(Collections.singletonList(id));
        if (loadDevices.isEmpty()) {
            return null;
        }
        return loadDevices.get(0);
    }

    public List<AssetVO> getAssets(List<GUID> toLoad) {
        if (toLoad.isEmpty()) {
            return Collections.emptyList();
        }
        return this.loadDevices(toLoad);
    }

    /*
     * Exception decompiling
     */
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="No User provided strings")
    private List<AssetVO> loadDevices(List<GUID> toLoad) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<GUID> loadChildIDs(Connection c, int deviceId) throws SQLException {
        ArrayList<GUID> ids = new ArrayList<GUID>();
        try (PreparedStatement pst = c.prepareStatement("SELECT GerUUID FROM tblGeraeteBestand WHERE ParentID = ?");){
            pst.setInt(1, deviceId);
            try (ResultSet rs = pst.executeQuery();){
                while (rs.next()) {
                    ids.add(GUID.valueOf((String)rs.getString("GerUUID")));
                }
            }
        }
        return ids;
    }

    private void loadFieldsFromColumns(MutableAssetData data, ResultSet rs) throws SQLException {
        String parentID = rs.getString("parentUUID");
        if (parentID != null) {
            data.put(AssetFields.FIELD_PARENT, GUID.valueOf((String)parentID));
        }
        this.setIfNotNull(rs.getInt("GerID"), AssetFields.FIELD_INT_ID, data, rs);
        this.setIfNotNull(rs.getString("GerBezeichnung"), AssetFields.FIELD_NAME, data, rs);
        this.setIfNotNull(rs.getInt("GTyID"), AssetFields.FIELD_TYPE, data, rs);
        this.setIfNotNull(rs.getString("Computername"), AssetFields.FIELD_COMPUTERNAME, data, rs);
        this.setIfNotNull(rs.getDouble("Preis"), AssetFields.FIELD_PRICE, data, rs);
        this.setIfNotNull(rs.getString("Seriennummer"), AssetFields.FIELD_SERIAL_NUMBER, data, rs);
        this.setIfNotNull(rs.getString("Anlagennummer"), AssetFields.FIELD_ASSET_NUMBER, data, rs);
        this.setIfNotNull(rs.getInt("GebID"), AssetFields.FIELD_LOCATION, data, rs);
        this.setIfNotNull(rs.getString("Zimmer"), AssetFields.FIELD_ROOM, data, rs);
        this.setIfNotNull(rs.getInt("SlaID"), AssetFields.FIELD_SLA, data, rs);
        this.setIfNotNull(rs.getString("Beschreibung"), AssetFields.FIELD_DESCRIPTION, data, rs);
        this.setIfNotNull(rs.getInt("VerkID"), AssetFields.FIELD_VENDOR, data, rs);
        this.setIfNotNull(rs.getString("Kostenstelle"), AssetFields.FIELD_COSTCENTER, data, rs);
        this.setIfNotNull(rs.getString("Rechnungsnummer"), AssetFields.FIELD_INVOICE_NUMBER, data, rs);
        this.setIfNotNull(rs.getInt("LizID"), AssetFields.FIELD_LICENSE, data, rs);
        this.setIfNotNull(rs.getString("GerFeld1"), AssetFields.getFieldFor("custom1"), data, rs);
        this.setIfNotNull(rs.getString("GerFeld2"), AssetFields.getFieldFor("custom2"), data, rs);
        this.setIfNotNull(rs.getString("GerFeld3"), AssetFields.getFieldFor("custom3"), data, rs);
        this.setIfNotNull(rs.getString("GerFeld4"), AssetFields.getFieldFor("custom4"), data, rs);
        this.setIfNotNull(rs.getString("GerFeld5"), AssetFields.getFieldFor("custom5"), data, rs);
        this.setIfNotNull(rs.getString("GerFeld6"), AssetFields.getFieldFor("custom6"), data, rs);
        this.setIfNotNull(rs.getString("GerFeld7"), AssetFields.getFieldFor("custom7"), data, rs);
        this.setIfNotNull(rs.getString("GerFeld8"), AssetFields.getFieldFor("custom8"), data, rs);
        this.setIfNotNull(rs.getString("GerFeld9"), AssetFields.getFieldFor("custom9"), data, rs);
        this.setIfNotNull(rs.getInt("ImpFlag"), AssetFields.FIELD_IMPORTED, data, rs);
        this.setIfNotNull(rs.getString("RefID"), AssetFields.FIELD_IMPORTED_FROM_COLUMN, data, rs);
        this.setIfNotNull(rs.getString("ImpName"), AssetFields.FIELD_IMPORT_NAME, data, rs);
        Timestamp timestamp = rs.getTimestamp("KaufDatum");
        if (timestamp != null) {
            data.put(AssetFields.FIELD_PURCHASE_DATE, timestamp.getTime());
        }
        if ((timestamp = rs.getTimestamp("Gewaehrleistung")) != null) {
            data.put(AssetFields.FIELD_WARRANTY, timestamp.getTime());
        }
        String userId = rs.getString("ownerUserUUID");
        data.put(AssetFields.FIELD_OWNER, GUID.valueOf((String)userId));
    }

    private void loadFieldsFromBinary(MutableAssetData data, ResultSet rs, GUID id) throws SQLException {
        DeviceBinaryUnit details;
        try {
            InputStream inputStream = rs.getBinaryStream("Data");
            if (inputStream == null) {
                return;
            }
            details = (DeviceBinaryUnit)new Json().fromJson(inputStream, DeviceBinaryUnit.class);
        }
        catch (JsonException | IOException ex) {
            String msg = "[DAO] Could not read details of device with ID: " + String.valueOf(id) + ". Default values will be used instead.";
            InventoryServerPlugin.LOGGER.warn((Object)new HelpDeskServerException(msg, ex, (ErrorCode)HelpDeskErrorCodes.TICKET_DATA_CORRUPTED_DETAILS));
            return;
        }
        Map<String, String> persistedAdditionalFields = details.getFields();
        for (AssetField field : DynamicExtensionManager.getInstance().get(AssetField.class)) {
            String fieldKey = field.getKey();
            if (!persistedAdditionalFields.containsKey(fieldKey)) continue;
            String jsonData = persistedAdditionalFields.get(fieldKey);
            try {
                Object value = new Json().fromJson(jsonData, field.getGenericType());
                data.putValidOrDefaultValue(field, value);
            }
            catch (JsonException ex) {
                String msg = String.format("[DAO] Could not deserialize value of field \"%s\" defined for device with ID \"%s\". Default value will be used instead.", fieldKey, id.toString());
                InventoryServerPlugin.LOGGER.warn((Object)msg);
                InventoryServerPlugin.LOGGER.warn((Object)ex);
            }
        }
    }

    private <T> void setIfNotNull(T value, AssetField<T> f, MutableAssetData data, ResultSet rs) throws SQLException {
        if (value != null && !rs.wasNull()) {
            data.put(f, value);
        }
    }

    public Iterator<GUID> getAssetIdIterator() {
        String minMaxSQL = "SELECT MIN(GerID), MAX(GerID) FROM tblGeraeteBestand";
        String sql = "SELECT GerUUID FROM tblGeraeteBestand WHERE GerID BETWEEN ? AND ? ORDER BY GerID";
        return ResultSetIterator.create((ConnectionFactory)((ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class)), (String)minMaxSQL, (String)sql, rs -> GUID.valueOf((String)rs.getString(1)));
    }

    /*
     * Exception decompiling
     */
    public int getMaxAssetId() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void delete(GUID id, int idInt) {
        try (Connection c = this.getConnection();
             PreparedStatement history = c.prepareStatement("DELETE FROM tblDeviceHistory WHERE GerID = ?");
             PreparedStatement pst = c.prepareStatement("DELETE FROM tblGeraeteBestand WHERE GerUUID = ?");){
            history.setInt(1, idInt);
            history.executeUpdate();
            pst.setString(1, id.toString());
            pst.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void addHistoryStep(HistoryStep step) {
        try (Connection c = this.getConnection();
             PreparedStatement pst = c.prepareStatement("INSERT INTO tblDeviceHistory VALUES (?,?,?,?)");){
            pst.setInt(1, step.getAssetID());
            pst.setLong(2, step.getDate());
            GUID user = step.getUser();
            pst.setString(3, user == null ? null : user.toString());
            pst.setString(4, step.getChange());
            pst.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public List<HistoryStep> getHistorySteps(int deviceId) {
        ArrayList<HistoryStep> result = new ArrayList<HistoryStep>();
        try (Connection c = this.getConnection();
             PreparedStatement pst = c.prepareStatement("SELECT * FROM tblDeviceHistory WHERE GerID = ? ORDER BY ChangeDate DESC");){
            pst.setInt(1, deviceId);
            try (ResultSet rs = pst.executeQuery();){
                while (rs.next()) {
                    GUID user = null;
                    String userStr = rs.getString("UserUUID");
                    if (userStr != null) {
                        user = GUID.valueOf((String)userStr);
                    }
                    result.add(new HistoryStep(deviceId, rs.getLong("ChangeDate"), user, rs.getString("Content")));
                }
            }
            pst.executeQuery();
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        return result;
    }

    private void updateTblTicketBinary(Connection connection, int deviceIDint, MutableAssetData deviceData) throws SQLException {
        DeviceBinaryUnit updatedDetails;
        List<AssetField<AssetField<Object>>> fieldsWithOwnColumn = AssetFields.getFieldsWithOwnColumn();
        if (fieldsWithOwnColumn.containsAll(deviceData.getIncludedFields())) {
            return;
        }
        DeviceBinaryUnit currentDetails = this.loadBinaryDetails(connection, deviceIDint);
        if (currentDetails.equals(updatedDetails = this.updateDevicePersistenceUnit(currentDetails, deviceData))) {
            return;
        }
        this.deleteDeviceDetails(connection, deviceIDint);
        this.insertDeviceDetails(connection, deviceIDint, updatedDetails);
    }

    private DeviceBinaryUnit updateDevicePersistenceUnit(DeviceBinaryUnit currentDetails, MutableAssetData deviceData) {
        HashMap<String, String> jsonizedValues = new HashMap<String, String>(currentDetails.getFields());
        List<AssetField<?>> fieldsWithOwnColumn = AssetFields.getFieldsWithOwnColumn();
        for (AssetField<Object> field : deviceData.getIncludedFields()) {
            if (fieldsWithOwnColumn.contains(field)) continue;
            Object value = deviceData.get(field);
            if (value == null) {
                jsonizedValues.remove(field.getKey());
                continue;
            }
            String jsonData = new Json().toJson(value);
            jsonizedValues.put(field.getKey(), jsonData);
        }
        return new DeviceBinaryUnit(jsonizedValues);
    }

    private void deleteDeviceDetails(Connection connection, int gerIDInt) throws SQLException {
        String sqlDelete = "DELETE FROM tblDeviceBinary WHERE GerID = ? AND DataKey = ?";
        try (PreparedStatement pstm = connection.prepareStatement(sqlDelete);){
            pstm.setInt(1, gerIDInt);
            pstm.setString(2, KEY_BINARYDETAILS);
            pstm.executeUpdate();
        }
    }

    private void insertDeviceDetails(Connection connection, int gerIDInt, DeviceBinaryUnit details) throws SQLException {
        String jsonData = new Json().toJson((Object)details);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(jsonData.getBytes(StandardCharsets.UTF_8));
        String sql = "INSERT INTO tblDeviceBinary (GerID, DataKey, Data) VALUES (?, ?, ?)";
        try (PreparedStatement pstm = connection.prepareStatement(sql);){
            pstm.setInt(1, gerIDInt);
            pstm.setString(2, KEY_BINARYDETAILS);
            pstm.setBinaryStream(3, inputStream);
            pstm.executeUpdate();
        }
    }

    /*
     * Loose catch block
     */
    @Nonnull
    private DeviceBinaryUnit loadBinaryDetails(Connection connection, int gerIDInt) throws SQLException {
        String sql = "SELECT Data FROM tblDeviceBinary WHERE GerID = ? AND DataKey = ?";
        try (PreparedStatement pstm = connection.prepareStatement(sql);){
            DeviceBinaryUnit deviceBinaryUnit;
            block19: {
                ResultSet rs;
                block17: {
                    DeviceBinaryUnit deviceBinaryUnit2;
                    block18: {
                        pstm.setInt(1, gerIDInt);
                        pstm.setString(2, KEY_BINARYDETAILS);
                        rs = pstm.executeQuery();
                        if (rs.next()) break block17;
                        deviceBinaryUnit2 = new DeviceBinaryUnit(Collections.emptyMap());
                        if (rs == null) break block18;
                        rs.close();
                    }
                    return deviceBinaryUnit2;
                }
                InputStream inputStream = rs.getBinaryStream(1);
                deviceBinaryUnit = (DeviceBinaryUnit)new Json().fromJson(inputStream, DeviceBinaryUnit.class);
                if (rs == null) break block19;
                {
                    catch (Throwable throwable) {
                        try {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (JsonException | IOException ex) {
                            InventoryServerPlugin.LOGGER.error((Object)("[TicketWriteDAO] Could not read details of device with ID: " + gerIDInt));
                            InventoryServerPlugin.LOGGER.error(ex);
                            DeviceBinaryUnit deviceBinaryUnit3 = new DeviceBinaryUnit(Collections.emptyMap());
                            return deviceBinaryUnit3;
                        }
                    }
                }
                rs.close();
            }
            return deviceBinaryUnit;
        }
    }

    public void deleteValueOfDeletedFields(GUID id, MutableAssetData data) {
        try (Connection c = this.getConnection();
             PreparedStatement pst = c.prepareStatement("SELECT GerID from tblGeraeteBestand WHERE GerUUID=?");){
            pst.setString(1, id.toString());
            try (ResultSet rs = pst.executeQuery();){
                if (!rs.next()) {
                    InventoryServerPlugin.LOGGER.warn((Object)("Ignore attempt to remove data from non-existing device: " + String.valueOf(id)));
                    return;
                }
                this.updateTblTicketBinary(c, rs.getInt("GerID"), data);
            }
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public AssetVO unarchive(GUID id) {
        try (Connection c = this.getConnection();){
            AssetVO assetVO;
            block14: {
                PreparedStatement pst = c.prepareStatement("UPDATE tblGeraeteBestand SET archived = 0 WHERE GerUUID = ?");
                try {
                    pst.setString(1, id.toString());
                    pst.executeUpdate();
                    assetVO = this.get(id);
                    if (pst == null) break block14;
                }
                catch (Throwable throwable) {
                    if (pst != null) {
                        try {
                            pst.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pst.close();
            }
            return assetVO;
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    @JsonData
    public static class DeviceBinaryUnit {
        private Map<String, String> fields = Collections.emptyMap();

        private DeviceBinaryUnit() {
        }

        public DeviceBinaryUnit(Map<String, String> fields) {
            this.fields = fields;
        }

        public Map<String, String> getFields() {
            return Collections.unmodifiableMap(this.fields);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.fields == null ? 0 : this.fields.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DeviceBinaryUnit other = (DeviceBinaryUnit)obj;
            return !(this.fields == null ? other.fields != null : !this.fields.equals(other.fields));
        }
    }
}

