/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.config.generics;

import com.inet.annotations.JsonData;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigRowAction;
import com.inet.config.structure.model.ItemListConfigProperty;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.helpdesk.config.TicketValueIconConfigProperty;
import com.inet.helpdesk.config.Translator;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.license.AssetLicense;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.license.AssetLicenseManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

@JsonData
public class LicenseListConfigProperty
extends ItemListConfigProperty {
    public static final String PROPERTY_KEY = "DeviceLicenses";

    public LicenseListConfigProperty(ConfigStructureSettings settings, Translator translator) {
        super(0, PROPERTY_KEY, "GENERIC_WITHICON", LicenseListConfigProperty.getObjectListValue(settings), null, new ConfigRowAction[]{LicenseListConfigProperty.getRowAction(translator, settings.getLocale().getLanguage())});
        this.setDuplicatePossible(true);
    }

    static Object getObjectListValue(ConfigStructureSettings settings) {
        ArrayList changedValueRaw = (ArrayList)settings.getChangedValue(PROPERTY_KEY, ArrayList.class);
        if (changedValueRaw != null) {
            changedValueRaw.sort(Comparator.comparing(o -> (String)o.get("name"), String.CASE_INSENSITIVE_ORDER));
            return changedValueRaw;
        }
        List list = AssetLicenseManager.getInstance().getAll(true);
        ArrayList<HashMap> result = new ArrayList<HashMap>();
        for (AssetLicense type : list) {
            HashMap<String, String> entry = LicenseListConfigProperty.convertToHashmap(type);
            result.add(entry);
        }
        result.sort(Comparator.comparing(o -> (String)o.get("name"), String.CASE_INSENSITIVE_ORDER));
        return result;
    }

    private static HashMap<String, String> convertToHashmap(AssetLicense action) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("id", "" + action.getId());
        result.put("name", action.getKurzBezeichnung());
        result.put("bezeichnung", action.getBezeichnung());
        result.put("bemerkung", action.getBemerkung());
        result.put("produkt", action.getProdukt());
        result.put("clientanzahl", LicenseListConfigProperty.strEmpty(action.getClientAnzahl()));
        result.put("serveranzahl", LicenseListConfigProperty.strEmpty(action.getServerAnzahl()));
        result.put("erwerbsdatum", LicenseListConfigProperty.strEmpty(action.getErwerbsDatum()));
        result.put("imageTypeId", String.valueOf(15));
        TicketValueIconConfigProperty.prepareConfigValueMapForIcons(result);
        return result;
    }

    private static String strEmpty(Object value) {
        return Objects.toString(value, "");
    }

    private static ConfigRowAction getRowAction(Translator translator, String language) {
        ConfigAction action = new ConfigAction("license.new", translator.translate(new String[]{"field.license.add"}));
        ConfigCategory category = new ConfigCategory(0, "license.new", translator.translate(new String[]{"field.license.name"}), "assets.licenses");
        ArrayList<ConfigPropertyGroup> propertyGroups = new ArrayList<ConfigPropertyGroup>();
        propertyGroups.add(new ConfigPropertyGroup(0, "license.new.group", ""));
        HashMap properties = new HashMap();
        ArrayList<Object> propertyList = new ArrayList<Object>();
        properties.put("license.new.group", propertyList);
        ArrayList conditions = new ArrayList();
        ConfigRowAction rowAction = new ConfigRowAction(action, null, category, propertyGroups, properties, conditions);
        propertyList.add(LicenseListConfigProperty.propWith("SimpleText", translator.translate(new String[]{"field.license.row.name"}), "name", ""));
        propertyList.add(LicenseListConfigProperty.propWith("SimpleText", translator.translate(new String[]{"field.license.row.label"}), "bezeichnung", ""));
        propertyList.add(LicenseListConfigProperty.propWith("SimpleText", translator.translate(new String[]{"field.license.row.product"}), "produkt", ""));
        propertyList.add(LicenseListConfigProperty.propWith("FixNumber", translator.translate(new String[]{"field.license.row.clientamount"}), "clientanzahl", ""));
        propertyList.add(LicenseListConfigProperty.propWith("FixNumber", translator.translate(new String[]{"field.license.row.serveramount"}), "serveranzahl", ""));
        propertyList.add(LicenseListConfigProperty.propWith("SimpleDate", translator.translate(new String[]{"field.license.row.purchasedate"}), "erwerbsdatum", ""));
        propertyList.add(new TicketValueIconConfigProperty(0, translator.translate(new String[]{"field.type.row.icon"}), 15));
        propertyList.add(LicenseListConfigProperty.propWith("MultiLineText", translator.translate(new String[]{"field.license.row.note"}), "bemerkung", ""));
        propertyList.add(LicenseListConfigProperty.propWith("Hidden", "", "id", "-1"));
        return rowAction;
    }

    private static ConfigProperty propWith(String type, String label, String keyName, String value) {
        return new ConfigProperty(0, keyName, type, label, (Object)value, null, null);
    }
}

