/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.api.model.field;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.field.FieldUtils;
import com.inet.field.SelectOption;
import com.inet.field.SelectOptionResult;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetVO;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.MutableAssetData;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithFieldGroup;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithIcon;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField_Select_Int;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.license.AssetLicense;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.license.AssetLicenseManager;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.FieldValidationException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class AssetFieldLicense
extends AssetField_Select_Int
implements AssetFieldWithFieldGroup,
AssetFieldWithIcon<Integer> {
    public AssetFieldLicense(String key, int sortPrio) {
        super(key, null, sortPrio);
    }

    public List<SelectOption> getSelectOptions(boolean includeDeleted) {
        List all = AssetLicenseManager.getInstance().getAll(!includeDeleted);
        ArrayList arrayList = all.stream().map(dt -> this.selectOption((AssetLicense)((Object)dt))).collect(Collectors.toCollection(ArrayList::new));
        arrayList.add(0, new SelectOption(null, ""));
        return arrayList;
    }

    @Override
    public SelectOptionResult getOptions(AssetVO device, String searchTerm, int currentSize, int chunkSize) {
        HashMap options = new HashMap();
        this.getSelectOptions().forEach(op -> options.put(op.getValue(), op.getLabel()));
        return FieldUtils.getOptions((String)searchTerm, (int)currentSize, (int)chunkSize, options, (value, displayName) -> new SelectOption(StringFunctions.stringValueOf((Object)value), displayName, String.valueOf(value)));
    }

    private SelectOption selectOption(AssetLicense deviceLicenseVO) {
        return new SelectOption(String.valueOf(deviceLicenseVO.getId()), deviceLicenseVO.getDisplayValue(), String.valueOf(deviceLicenseVO.getId()));
    }

    @Override
    public SelectOption getValue(AssetView device) {
        AssetLicense assetLicense;
        Integer value = device != null ? device.getValue(this) : (Integer)this.getDefaultValue();
        if (value != null && (assetLicense = (AssetLicense)AssetLicenseManager.getInstance().get(value)) != null) {
            return this.selectOption(assetLicense);
        }
        return null;
    }

    @Override
    public void validateRealValue(Integer id) throws FieldValidationException {
        if (id != null && AssetLicenseManager.getInstance().get(id) == null) {
            throw new FieldValidationException(AssetManager.MSG.getMsg("manager.error.objectDoesNotExist", new Object[]{id}));
        }
    }

    @Override
    public String getDisplayValue(Integer value) {
        AssetLicense license = (AssetLicense)AssetLicenseManager.getInstance().get(value);
        if (license != null) {
            return license.getDisplayValue();
        }
        return null;
    }

    @Override
    public URL getIcon(String value, int size) {
        try {
            int type = Integer.parseInt(value);
            return AssetLicenseManager.getInstance().getIcon(type, size);
        }
        catch (NumberFormatException numberFormatException) {
            return super.getIcon(value, size);
        }
    }

    @Override
    @Nullable
    public LocalizedKey getFieldGroup() {
        return new LocalizedKey(this.getFieldKey(), this.getLabel());
    }

    @Override
    public List<AssetFieldWithFieldGroup.AdditionalDetailField> getAdditionalFields(String serializedValue) {
        AssetLicense assetLicense;
        MutableAssetData data = new MutableAssetData();
        this.getEditInformation().updateAssetData(data, serializedValue);
        Integer value = data.get(this);
        AssetLicense assetLicense2 = assetLicense = value == null ? null : (AssetLicense)AssetLicenseManager.getInstance().get(value);
        if (assetLicense == null) {
            return null;
        }
        ArrayList<AssetFieldWithFieldGroup.AdditionalDetailField> fields = new ArrayList<AssetFieldWithFieldGroup.AdditionalDetailField>();
        fields.add(new AssetFieldWithFieldGroup.AdditionalDetailField("bezeichnung", 1, false, InventoryServerPlugin.CONFIG_MSG.getMsg("field.license.row.label", new Object[0]), assetLicense.getBezeichnung()));
        fields.add(new AssetFieldWithFieldGroup.AdditionalDetailField("produkt", 2, false, InventoryServerPlugin.CONFIG_MSG.getMsg("field.license.row.product", new Object[0]), assetLicense.getProdukt()));
        fields.add(new AssetFieldWithFieldGroup.AdditionalDetailField("clientanzahl", 3, false, InventoryServerPlugin.CONFIG_MSG.getMsg("field.license.row.clientamount", new Object[0]), assetLicense.getClientAnzahl() == null ? "" : assetLicense.getClientAnzahl().toString()));
        fields.add(new AssetFieldWithFieldGroup.AdditionalDetailField("serveranzahl", 4, false, InventoryServerPlugin.CONFIG_MSG.getMsg("field.license.row.serveramount", new Object[0]), assetLicense.getServerAnzahl() == null ? "" : assetLicense.getServerAnzahl().toString()));
        fields.add(new AssetFieldWithFieldGroup.AdditionalDetailField("erwerbsdatum", 5, false, InventoryServerPlugin.CONFIG_MSG.getMsg("field.license.row.purchasedate", new Object[0]), assetLicense.getErwerbsDatum() == null ? "" : AssetFieldWithFieldGroup.AdditionalDetailField.formatAsDate(assetLicense.getErwerbsDatum())));
        fields.add(new AssetFieldWithFieldGroup.AdditionalDetailField("bemerkung", 6, true, InventoryServerPlugin.CONFIG_MSG.getMsg("field.license.row.note", new Object[0]), assetLicense.getBemerkung()));
        return fields;
    }
}

