/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.client.event;

import com.inet.helpdesk.plugins.inventory.client.data.AssetID;
import com.inet.helpdesk.plugins.inventory.client.data.AssetTreeNode;
import com.inet.helpdesk.plugins.inventory.client.data.InitTreeState;
import com.inet.helpdesk.plugins.inventory.client.data.InventoryTreeUpdateData;
import com.inet.helpdesk.plugins.inventory.client.event.AbstractInventoryEvent;
import com.inet.helpdesk.plugins.inventory.client.handler.LoadTreeGroupingSettings;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.AssetNodeIdentifier;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.TreeGrouping;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.TreeNodeInfo;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.settings.ClientTreeSettings;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.servlet.ClientTimezone;
import com.inet.http.websocket.WebSocketConnectionListener;
import com.inet.http.websocket.WebSocketEventData;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.http.websocket.WebsocketConnection;
import com.inet.id.GUID;
import com.inet.lib.util.EncodingFunctions;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class InitInventoryTree
extends AbstractInventoryEvent<InitTreeState> {
    public InitInventoryTree() {
        WebSocketEventHandler.getInstance().addConnectionListener(new WebSocketConnectionListener(){

            public void connectionOpened(String clientId) {
            }

            public void connectionClosed(String clientId) {
                AssetManager.getInstance().view().unregisterTreeClient(clientId);
            }
        });
    }

    @Override
    public void handleEvent(WebSocketEventHandler eventHandler, WebsocketConnection websocketConnection, InitTreeState payload) throws IOException {
        if (payload.getTreeFilter() == null) {
            AssetManager.getInstance().view().unregisterTreeClient(websocketConnection.getPollingID());
            return;
        }
        TreeGrouping grouping = LoadTreeGroupingSettings.getTreeGrouping(GUID.valueOf((String)payload.getGroupingKey()));
        Map<AssetNodeIdentifier, Integer> openNodes = payload.getOpenNodes().entrySet().stream().collect(Collectors.toMap(entry -> AssetNodeIdentifier.valueOf((String)entry.getKey()), entry -> (Integer)entry.getValue()));
        ClientTreeSettings treeClient = new ClientTreeSettings(payload.getSearchPhrase(), grouping, ClientTreeSettings.TreeVisibility.valueOf(payload.getTreeVisibility()), ClientTreeSettings.TreeFilter.valueOf(payload.getTreeFilter()));
        AssetManager.getInstance().view().registerTreeClient(websocketConnection.getPollingID(), treeClient, openNodes, (clientId, changes) -> {
            Supplier<WebSocketEventData> eventFactory = () -> {
                AssetID parentId = new AssetID(changes.parentNode.isDevice(), changes.parentNode.toString());
                List<AssetID> insertAssets = Collections.emptyList();
                if (changes.insertAssets != null && !changes.insertAssets.isEmpty()) {
                    insertAssets = changes.insertAssets.stream().map(id -> new AssetID(id.isDevice(), id.toString())).collect(Collectors.toList());
                }
                Set<AssetTreeNode> changedAssets = Collections.emptySet();
                if (changes.changedAssets != null && !changes.changedAssets.isEmpty()) {
                    Locale threadLocale = ClientLocale.getThreadLocale();
                    TimeZone timeZone = ClientTimezone.getTimeZone();
                    GUID currentUserAccountID = UserManager.getInstance().getCurrentUserAccountID();
                    changedAssets = changes.changedAssets.parallelStream().map(deviceId -> {
                        Locale oldLocale = ClientLocale.getThreadLocale();
                        TimeZone oldTimezone = ClientTimezone.getTimeZone();
                        ClientLocale.setThreadLocale((Locale)threadLocale);
                        ClientTimezone.setTimeZone((TimeZone)timeZone);
                        try {
                            AssetTreeNode assetTreeNode;
                            block13: {
                                TreeNodeInfo nodeInfo;
                                UserAccountScope userScope;
                                block11: {
                                    AssetTreeNode assetTreeNode2;
                                    block12: {
                                        userScope = UserAccountScope.create((GUID)currentUserAccountID);
                                        try {
                                            nodeInfo = AssetManager.getInstance().view().getNodeInfo(clientId, (AssetNodeIdentifier)deviceId, true);
                                            if (nodeInfo != null) break block11;
                                            assetTreeNode2 = null;
                                            if (userScope == null) break block12;
                                        }
                                        catch (Throwable throwable) {
                                            if (userScope != null) {
                                                try {
                                                    userScope.close();
                                                }
                                                catch (Throwable throwable2) {
                                                    throwable.addSuppressed(throwable2);
                                                }
                                            }
                                            throw throwable;
                                        }
                                        userScope.close();
                                    }
                                    return assetTreeNode2;
                                }
                                AssetID id = new AssetID(deviceId.isDevice(), deviceId.toString());
                                String displayName = nodeInfo.getDisplayName();
                                String iconKey = nodeInfo.getIcon() == null ? null : "field=" + EncodingFunctions.encodeUrlParameter((String)nodeInfo.getIcon().getFieldKey()) + "&value=" + EncodingFunctions.encodeUrlParameter((String)nodeInfo.getIcon().getValue());
                                boolean hasChildren = nodeInfo.isHasChildNodes();
                                boolean deleted = nodeInfo.isArchived();
                                boolean dummySearchNode = nodeInfo.isDummySearchNode();
                                assetTreeNode = new AssetTreeNode(id, displayName, iconKey, hasChildren, deleted, dummySearchNode);
                                if (userScope == null) break block13;
                                userScope.close();
                            }
                            return assetTreeNode;
                        }
                        finally {
                            ClientLocale.setThreadLocale((Locale)oldLocale);
                            ClientTimezone.setTimeZone((TimeZone)oldTimezone);
                        }
                    }).filter(a -> a != null).collect(Collectors.toSet());
                }
                return new WebSocketEventData("inventory.tree.update", (Object)new InventoryTreeUpdateData(parentId, changes.removeOffset, changes.lengthRemoved, changes.insertOffset, insertAssets, changedAssets, changes.initialData, changes.hasMore));
            };
            WebSocketEventHandler.getInstance().sendEvent(clientId, eventFactory);
        });
    }

    public String getEventName() {
        return "inventory.tree.init";
    }
}

