/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.client;

import com.inet.helpdesk.config.AppDataLocation;
import com.inet.helpdesk.plugins.attachments.server.AttachmentService;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentFileRow;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentRow;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.helpdesk.plugins.attachments.shared.model.AttachmentKey;
import com.inet.helpdesk.plugins.inventory.client.data.InventoryAttachment;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.helpdesk.shared.rpc.LargeContent;
import com.inet.http.upload.AttachmentDescription;
import com.inet.http.utils.MimeTypes;
import com.inet.id.GUID;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.ServerPluginManager;
import com.inet.shared.http.upload.AttachmentType;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class InventoryAttachments {
    public static void saveAttachment(AssetView asset, List<InventoryAttachment> attachments) {
        AttachmentService attachmentService = (AttachmentService)ServerPluginManager.getInstance().getSingleInstance(AttachmentService.class);
        for (InventoryAttachment inventoryAttachment : attachments) {
            try {
                String realFilePath;
                PersistenceEntry file;
                Map fullAttachmentDataFor = attachmentService.getFullAttachmentDataFor(AttachmentOwnerType.DeviceAttachment, List.of(inventoryAttachment.getAssetId()));
                Map.Entry entry = fullAttachmentDataFor.entrySet().stream().filter(e -> ((AttachmentRow)e.getKey()).getFileName().equals(inventoryAttachment.getFileName())).findFirst().orElse(null);
                if (entry == null) continue;
                final AttachmentRow row = (AttachmentRow)entry.getKey();
                AttachmentFileRow fileRow = (AttachmentFileRow)entry.getValue();
                if (fileRow == null || row == null || (file = AppDataLocation.getAttachmentFile((String)(realFilePath = fileRow.getFilePath()))) == null) continue;
                LargeContent lc = new LargeContent(new LargeContent.InputStreamProvider(){

                    public InputStream getStream() {
                        try {
                            InputStream inputStream = file.getInputStream();
                            return inputStream;
                        }
                        catch (Exception e) {
                            InventoryServerPlugin.LOGGER.error((Throwable)e);
                            return null;
                        }
                    }

                    public long getSize() {
                        return row.getFileLength();
                    }
                });
                lc.setContentType(AttachmentType.Attachment);
                lc.setLastModified(row.getLastModified());
                lc.setName(row.getFileName());
                attachmentService.updateAttachment(AttachmentOwnerType.DeviceAttachment, asset.getIntID(), -1, lc);
            }
            catch (Throwable e2) {
                InventoryServerPlugin.LOGGER.error(e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAttachment(AssetView asset, List<AttachmentDescription> attachments, HttpServletRequest request) {
        AttachmentService attachmentService = (AttachmentService)ServerPluginManager.getInstance().getSingleInstance(AttachmentService.class);
        int attachmentNumber = 0;
        final ArrayList openStream = new ArrayList();
        try {
            for (AttachmentDescription ad : attachments) {
                try {
                    Part f;
                    if ((f = request.getPart("attachment" + attachmentNumber++)) == null) continue;
                    LargeContent lc = new LargeContent(new LargeContent.InputStreamProvider(){

                        public InputStream getStream() {
                            try {
                                InputStream inputStream = f.getInputStream();
                                openStream.add(inputStream);
                                return inputStream;
                            }
                            catch (Exception e) {
                                InventoryServerPlugin.LOGGER.error((Throwable)e);
                                return null;
                            }
                        }

                        public long getSize() {
                            return f.getSize();
                        }
                    });
                    lc.setContentType(ad.getAttachmentType());
                    lc.setLastModified(ad.getLastModified());
                    lc.setName(ad.getName());
                    attachmentService.updateAttachment(AttachmentOwnerType.DeviceAttachment, asset.getIntID(), -1, lc);
                }
                catch (ServletException | IOException e) {
                    InventoryServerPlugin.LOGGER.error(e);
                }
            }
        }
        finally {
            for (InputStream stream : openStream) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    InventoryServerPlugin.LOGGER.error((Throwable)e);
                }
            }
        }
    }

    @Nonnull
    public static List<InventoryAttachment> getAttachments(GUID id) {
        return InventoryAttachments.getAttachments(id, row -> new InventoryAttachment(row.getOwnerId(), row.getFileName(), MimeTypes.getMimeType((String)row.getFileName()), row.getFileLength(), row.getLastModified()));
    }

    @Nonnull
    public static <T> List<T> getAttachments(GUID id, Function<AttachmentRow, T> mapper) {
        AssetView asset = AssetManager.getInstance().getAsset(id);
        if (asset == null) {
            return Collections.emptyList();
        }
        AttachmentService attachmentService = (AttachmentService)ServerPluginManager.getInstance().getSingleInstance(AttachmentService.class);
        try {
            Map fullAttachmentDataFor = attachmentService.getFullAttachmentDataFor(AttachmentOwnerType.DeviceAttachment, List.of(Integer.valueOf(asset.getIntID())));
            return fullAttachmentDataFor.keySet().stream().map(e -> mapper.apply((AttachmentRow)e)).collect(Collectors.toList());
        }
        catch (Throwable e2) {
            InventoryServerPlugin.LOGGER.error(e2);
            return Collections.emptyList();
        }
    }

    public static void deleteAttachment(int ownerId, String filename) {
        AttachmentService attachmentService = (AttachmentService)ServerPluginManager.getInstance().getSingleInstance(AttachmentService.class);
        try {
            attachmentService.deleteAttachment(AttachmentOwnerType.DeviceAttachment, ownerId, -1, filename);
        }
        catch (Throwable e) {
            InventoryServerPlugin.LOGGER.error(e);
        }
    }

    public static boolean isAttachmentAvailable(InventoryAttachment att) {
        AttachmentService attachmentService = (AttachmentService)ServerPluginManager.getInstance().getSingleInstance(AttachmentService.class);
        AttachmentKey key = new AttachmentKey(AttachmentOwnerType.DeviceAttachment, att.getAssetId(), Integer.valueOf(-1), Integer.valueOf(-1), att.getFileName());
        try {
            AttachmentFileRow attachmentFile;
            AttachmentRow attachment = attachmentService.getAttachment(key);
            if (attachment != null && (attachmentFile = attachmentService.getAttachmentFile(attachment.getChecksum(), attachment.getFileLength())) != null) {
                PersistenceEntry entry = AppDataLocation.getAttachmentFile((String)attachmentFile.getFilePath());
                return entry.exists();
            }
        }
        catch (Throwable e) {
            InventoryServerPlugin.LOGGER.error(e);
        }
        return false;
    }
}

