/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.webapi.data;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.plugins.inventory.server.api.model.HistoryStep;
import com.inet.id.GUID;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;

@JsonData
@Schema(description="List of history entries for an inventory asset")
public class InventoryAssetHistoryResponse
extends ArrayList<HistoryEntry> {
    public static InventoryAssetHistoryResponse from(List<HistoryStep> entries) {
        InventoryAssetHistoryResponse response = new InventoryAssetHistoryResponse();
        for (HistoryStep historyStep : entries) {
            response.add(new HistoryEntry(historyStep));
        }
        return response;
    }

    @JsonData
    @Schema(description="A single history entry representing a change to an asset")
    protected static class HistoryEntry {
        @Schema(description="The GUID of the user who made the change", required=true)
        private GUID userId;
        @Schema(description="Description of the change that was made", required=true)
        private String change;
        @Schema(description="Timestamp when the change was made", required=true)
        private long timestamp;

        protected HistoryEntry(HistoryStep historyStep) {
            this.userId = historyStep.getUser();
            this.change = historyStep.getChange();
            this.timestamp = historyStep.getDate();
        }
    }
}

