/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.webapi.asset;

import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.HistoryStep;
import com.inet.helpdesk.plugins.inventory.server.webapi.InventoryWebAPIExtension;
import com.inet.helpdesk.plugins.inventory.server.webapi.data.InventoryAssetHistoryResponse;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;

@Tag(name="Inventory", description="Operations for managing inventory assets")
public class InventoryAssetHistoryHandler
extends RequestHandler.WithParentPathToken<Void, InventoryAssetHistoryResponse, GUID> {
    public InventoryAssetHistoryHandler() {
        super(new String[]{"history"});
    }

    public String getHelpPageKey() {
        return "webapi.inventory.asset.history";
    }

    @Operation(summary="Get asset history", description="Retrieves the complete history of changes made to a specific inventory asset", responses={@ApiResponse(responseCode="200", description="Asset history retrieved successfully", content={@Content(schema=@Schema(implementation=InventoryAssetHistoryResponse.class))}), @ApiResponse(responseCode="400", description="Invalid asset ID or asset not found"), @ApiResponse(responseCode="401", description="User not authorized to view asset history")})
    public InventoryAssetHistoryResponse handle(HttpServletRequest request, HttpServletResponse response, @Nullable Void inputObject, @Parameter(description="GUID of the asset to retrieve history for") @Nullable GUID assetId, boolean previewModeEnabled) throws IOException {
        if (assetId == null) {
            throw new ClientMessageException(InventoryWebAPIExtension.MSG.getMsg("asset.id.notGiven", new Object[0]));
        }
        AssetView asset = AssetManager.getInstance().getAsset(assetId);
        if (asset == null) {
            throw new ClientMessageException(InventoryWebAPIExtension.MSG.getMsg("asset.id.notFound", new Object[0]));
        }
        List<HistoryStep> assetHistory = AssetManager.getInstance().getAssetHistory(asset.getId());
        return InventoryAssetHistoryResponse.from(assetHistory);
    }
}

