/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.taskplanner.series.devicewarranty;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldDefinition;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.index.IndexSearchEngine;
import com.inet.taskplanner.server.api.TaskExecution;
import com.inet.taskplanner.server.api.TaskPlanner;
import com.inet.taskplanner.server.api.series.Series;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class DeviceWarrantyEndApproachingSeries
implements Series {
    public static final String LAST_EXECUTION = "lastexecutiontime";
    public static final String ASSETDATE_TIME_1_WEEK = "1week";
    public static final String ASSETDATE_TIME_2_WEEK = "2week";
    public static final String ASSETDATE_TIME_3_WEEK = "3week";
    public static final String ASSETDATE_TIME_4_WEEK = "4week";
    public static final String ASSETDATE_TIME_5_WEEK = "5week";
    public static final String ASSETDATE_TIME_6_WEEK = "6week";
    public static final String ASSETDATE_TIME_7_WEEK = "7week";
    public static final String ASSETDATE_TIME_8_WEEK = "8week";
    public static final String ASSETDATE_TIME_1_WEEK_AGO = "1weekago";
    public static final String ASSETDATE_TIME_NOW = "atexecution";
    public static final String ASSETDATE_TIME_2_WEEK_AGO = "2weekago";
    public static final String ASSETDATE_TIME_3_WEEK_AGO = "3weekago";
    public static final String ASSETDATE_TIME_4_WEEK_AGO = "4weekago";
    public static final String ASSETDATE_TIME_5_WEEK_AGO = "5weekago";
    public static final String ASSETDATE_TIME_6_WEEK_AGO = "6weekago";
    public static final String ASSETDATE_TIME_7_WEEK_AGO = "7weekago";
    public static final String ASSETDATE_TIME_8_WEEK_AGO = "8weekago";
    public static final String ASSETDATE_TIME_ANY_PAST = "anypast";
    public static final String ASSETDATE_TIME_ANY_FUTURE = "anypast";
    @Nonnull
    private String beforeOrAfter;
    private String whichField;
    private final GUID guid;
    private final GUID seriesGuid;
    private final Integer deviceType;
    private int numberOfWeeks;
    private int numberOfWeeks2;
    private List<Map<String, String>> devices = new ArrayList<Map<String, String>>();

    public DeviceWarrantyEndApproachingSeries(GUID taskId, GUID seriesId, String warrantytime, String deviceType) {
        this(taskId, seriesId, AssetFields.FIELD_WARRANTY.getFieldKey(), "before", warrantytime, warrantytime, deviceType);
    }

    public DeviceWarrantyEndApproachingSeries(GUID taskId, GUID seriesId, String whichField, String beforeOrAfter, String warrantytime, String warrantytime2, String deviceType) {
        if (whichField == null || whichField.isBlank()) {
            whichField = AssetFields.FIELD_WARRANTY.getFieldKey();
        }
        this.beforeOrAfter = beforeOrAfter == null ? "before" : beforeOrAfter;
        this.whichField = whichField;
        this.guid = taskId;
        this.seriesGuid = seriesId;
        this.deviceType = deviceType == null || deviceType.equals("") ? null : Integer.valueOf(deviceType);
        this.numberOfWeeks = DeviceWarrantyEndApproachingSeries.extractNumberOfWeeksFrom(warrantytime);
        this.numberOfWeeks2 = DeviceWarrantyEndApproachingSeries.extractNumberOfWeeksFrom(warrantytime2);
    }

    private static int extractNumberOfWeeksFrom(String warrantytime) {
        if (warrantytime == null) {
            return 0;
        }
        int numberOfWeeks = 0;
        switch (warrantytime) {
            case "1weekago": {
                numberOfWeeks = -1;
                break;
            }
            case "2weekago": {
                numberOfWeeks = -2;
                break;
            }
            case "3weekago": {
                numberOfWeeks = -3;
                break;
            }
            case "4weekago": {
                numberOfWeeks = -4;
                break;
            }
            case "5weekago": {
                numberOfWeeks = -5;
                break;
            }
            case "6weekago": {
                numberOfWeeks = -6;
                break;
            }
            case "7weekago": {
                numberOfWeeks = -7;
                break;
            }
            case "8weekago": {
                numberOfWeeks = -8;
                break;
            }
            case "atexecution": {
                numberOfWeeks = 0;
                break;
            }
            case "1week": {
                numberOfWeeks = 1;
                break;
            }
            case "2week": {
                numberOfWeeks = 2;
                break;
            }
            case "3week": {
                numberOfWeeks = 3;
                break;
            }
            case "4week": {
                numberOfWeeks = 4;
                break;
            }
            case "5week": {
                numberOfWeeks = 5;
                break;
            }
            case "6week": {
                numberOfWeeks = 6;
                break;
            }
            case "7week": {
                numberOfWeeks = 7;
                break;
            }
            case "8week": {
                numberOfWeeks = 8;
                break;
            }
        }
        return numberOfWeeks;
    }

    public void cleanUp(boolean wasPreview) throws Exception {
        this.devices = new ArrayList<Map<String, String>>();
        if (!wasPreview) {
            PersistenceEntry persistenceReal;
            HashMap<String, String> realEntries;
            PersistenceEntry persistenceTmp = Persistence.getInstance().resolve("taskplanner").resolve("deviceseries").resolve("task" + this.guid.toString()).resolve("deviceseriestmp" + this.seriesGuid.toString());
            HashMap<String, String> tmpEntries = DeviceWarrantyEndApproachingSeries.getEntries(persistenceTmp);
            if (tmpEntries == null) {
                tmpEntries = new HashMap();
            }
            if ((realEntries = DeviceWarrantyEndApproachingSeries.getEntries(persistenceReal = Persistence.getInstance().resolve("taskplanner").resolve("deviceseries").resolve("task" + this.guid.toString()).resolve("deviceseries" + this.seriesGuid.toString()))) == null) {
                realEntries = new HashMap();
            }
            persistenceTmp.deleteValue();
            realEntries.putAll(tmpEntries);
            persistenceReal.setString(new Json().toJson(realEntries));
        }
    }

    private void storeIncludedAssetInSeries(String assetId, String assetDate) {
        PersistenceEntry persistenceTmp = Persistence.getInstance().resolve("taskplanner").resolve("deviceseries").resolve("task" + this.guid.toString()).resolve("deviceseriestmp" + this.seriesGuid.toString());
        HashMap<String, String> entries = DeviceWarrantyEndApproachingSeries.getEntries(persistenceTmp);
        if (entries == null) {
            entries = new HashMap();
        }
        entries.put(assetId, assetDate);
        persistenceTmp.setString(new Json().toJson(entries));
    }

    private String alreadyHadAssetInSeries(String seriesId, String assetId) {
        PersistenceEntry persistence = Persistence.getInstance().resolve("taskplanner").resolve("deviceseries").resolve("task" + this.guid.toString()).resolve("deviceseries" + seriesId);
        HashMap<String, String> entries = DeviceWarrantyEndApproachingSeries.getEntries(persistence);
        if (entries == null) {
            return null;
        }
        return entries.get(assetId);
    }

    private static HashMap<String, String> getEntries(PersistenceEntry persistence) {
        if (!persistence.exists()) {
            return null;
        }
        String json = persistence.getString();
        if (json == null) {
            return null;
        }
        HashMap entries = (HashMap)new Json().fromJson(json, HashMap.class);
        return entries;
    }

    protected TaskPlanner getTaskPlanner() {
        return TaskPlanner.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Map<String, String>> iterator() {
        DeviceWarrantyEndApproachingSeries deviceWarrantyEndApproachingSeries = this;
        synchronized (deviceWarrantyEndApproachingSeries) {
            TaskExecution taskExecution = this.getTaskPlanner().getTaskExecution(this.guid);
            if (taskExecution != null) {
                PersistenceEntry taskEntry = Persistence.getInstance().resolve("taskplanner").resolve("deviceseries").resolve("task" + this.guid.toString());
                long lastActualModified = taskExecution.getLastModified();
                PersistenceEntry lmEntry = taskEntry.resolve("lastmodifiedKnownToSeries");
                PersistenceEntry seriesFolder = taskEntry.resolve("deviceseries" + this.seriesGuid.toString());
                if (lmEntry.exists()) {
                    String lastKnownModified = lmEntry.getString();
                    if (lastKnownModified == null || !lastKnownModified.equals("" + lastActualModified)) {
                        if (seriesFolder.exists()) {
                            seriesFolder.deleteTree();
                        }
                        lmEntry.setString("" + lastActualModified);
                    }
                } else {
                    if (seriesFolder.exists()) {
                        seriesFolder.deleteTree();
                    }
                    lmEntry.setString("" + lastActualModified);
                }
            }
        }
        ArrayList devices = new ArrayList();
        try {
            boolean isBetween = "between".equals(this.beforeOrAfter);
            long phase = 604800000L * (long)this.numberOfWeeks;
            long phase2 = 604800000L * (long)(isBetween ? this.numberOfWeeks2 : this.numberOfWeeks);
            long currentTime = System.currentTimeMillis();
            long fromDateMillis = currentTime + Math.min(phase, phase2);
            long toDateMillis = currentTime + Math.max(phase, phase2);
            switch (this.beforeOrAfter) {
                case "before": {
                    fromDateMillis = 0L;
                    break;
                }
                case "after": {
                    fromDateMillis = Long.MAX_VALUE;
                }
            }
            IndexSearchEngine searchEngine = this.getAssetManager().getSearchEngine();
            AndSearchExpression expr = new AndSearchExpression();
            expr.add((SearchExpression)new SearchCondition(this.whichField, SearchCondition.SearchTermOperator.BETWEEN, (Object)new Long[]{fromDateMillis, toDateMillis}));
            if (this.deviceType != null) {
                expr.add((SearchExpression)new SearchCondition(AssetFields.FIELD_TYPE.getFieldKey(), SearchCondition.SearchTermOperator.Equals, (Object)this.deviceType));
            }
            SearchCommand c = new SearchCommand(new SearchExpression[]{expr});
            Set guids = searchEngine.simpleSearch(c);
            List fieldDefinitions = DynamicExtensionManager.getInstance().get(AssetFieldDefinition.class);
            for (GUID guid : guids) {
                AssetView assetView = this.getAssetManager().getAsset(guid);
                if (assetView == null) continue;
                String dateWeKnow = this.alreadyHadAssetInSeries(this.seriesGuid.toString(), guid.toString());
                AssetField field = AssetFields.getFieldFor(this.whichField);
                if (field == null) continue;
                Long fieldDate = (Long)assetView.getValue(field);
                if (dateWeKnow != null && dateWeKnow.equals("" + fieldDate)) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("Device-ID", "" + assetView.getIntID());
                map.put("Device-Name", assetView.getName());
                fieldDefinitions.stream().forEach(d -> {
                    String fieldKey = d.getFieldKey();
                    String value = d.getDisplayValue(assetView);
                    String displayValue = value != null ? value : "";
                    map.put("asset." + fieldKey, displayValue);
                });
                devices.add(map);
                this.storeIncludedAssetInSeries(guid.toString(), "" + fieldDate);
            }
        }
        catch (Exception e) {
            HDLogger.error((Object)e);
        }
        return devices.iterator();
    }

    protected AssetManager getAssetManager() {
        return AssetManager.getInstance();
    }
}

