/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.internal.tree;

import com.inet.helpdesk.plugins.inventory.server.api.model.tree.AssetFieldValue;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.AssetNodeIdentifier;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.TreeNode;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.TreeNodeInfo;
import com.inet.helpdesk.plugins.inventory.server.internal.AssetClientHandlingImpl;
import com.inet.helpdesk.plugins.inventory.server.internal.tree.NodeWithParent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class InternalTreeNode {
    private AssetNodeIdentifier id;
    private List<InternalTreeNode> children;
    private boolean hasMoreNodes;
    private int numOfMoreNodes;
    private boolean searchDummy;
    private InternalTreeNode tempSubTree;
    private Boolean hasChildren;

    public InternalTreeNode(AssetNodeIdentifier id) {
        this.id = id;
        if (!id.isDevice()) {
            this.hasChildren = Boolean.TRUE;
        }
    }

    public Boolean getHasChildren() {
        return this.hasChildren;
    }

    public void setHasChildren(Boolean hasChildren) {
        this.hasChildren = hasChildren;
    }

    @Nonnull
    public AssetNodeIdentifier getId() {
        return this.id;
    }

    public List<InternalTreeNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<InternalTreeNode> children) {
        this.children = children;
    }

    public boolean isOpened() {
        return this.children != null;
    }

    public boolean contains(AssetNodeIdentifier id) {
        if (this.children != null) {
            return this.children.stream().anyMatch(c -> c.getId().equals(id));
        }
        return false;
    }

    public InternalTreeNode findDirectChild(AssetNodeIdentifier id) {
        if (this.children != null) {
            return this.children.stream().filter(c -> c.getId().equals(id)).findFirst().orElse(null);
        }
        return null;
    }

    public InternalTreeNode find(AssetNodeIdentifier id) {
        if (Objects.equals(id, this.id)) {
            return this;
        }
        if (this.children != null) {
            return this.children.stream().map(c -> c.find(id)).filter(Objects::nonNull).findFirst().orElse(null);
        }
        return null;
    }

    @Nullable
    public NodeWithParent findWithParent(AssetNodeIdentifier id, AssetNodeIdentifier parent) {
        if (Objects.equals(id, this.id)) {
            return new NodeWithParent(this, parent);
        }
        if (this.children != null) {
            return this.children.stream().map(c -> c.findWithParent(id, this.id)).filter(Objects::nonNull).findFirst().orElse(null);
        }
        return null;
    }

    public void openNode() {
        this.children = new ArrayList<InternalTreeNode>();
    }

    public void closeNode() {
        this.children = null;
    }

    public String toString() {
        return "InternalTreeNode [id=" + String.valueOf(this.id) + ", children=" + String.valueOf(this.children) + ", hasMoreNodes=" + this.hasMoreNodes + ", searchDummy=" + this.searchDummy + ", hasChildren=" + this.hasChildren + "]";
    }

    public void setHasMoreNodes(boolean hasMoreNodes) {
        this.hasMoreNodes = hasMoreNodes;
    }

    public boolean hasMoreNodes() {
        return this.hasMoreNodes;
    }

    public boolean isSearchDummy() {
        return this.searchDummy;
    }

    public void setSearchDummy(boolean searchDummy) {
        this.searchDummy = searchDummy;
    }

    public InternalTreeNode copyDeep() {
        InternalTreeNode copy = new InternalTreeNode(this.id);
        copy.hasMoreNodes = this.hasMoreNodes;
        copy.searchDummy = this.searchDummy;
        copy.hasChildren = this.hasChildren;
        if (this.children != null) {
            copy.children = new ArrayList<InternalTreeNode>(this.children.size());
            this.children.forEach(c -> copy.children.add(c.copyDeep()));
        }
        if (this.tempSubTree != null) {
            copy.tempSubTree = this.tempSubTree.copyDeep();
        }
        return copy;
    }

    public int getNumOfMoreNodes() {
        return this.numOfMoreNodes;
    }

    public void setNumOfMoreNodes(int numOfMoreNodes) {
        this.numOfMoreNodes = numOfMoreNodes;
    }

    public InternalTreeNode getTempSubTree() {
        return this.tempSubTree;
    }

    public void setTempSubTree(InternalTreeNode tempSubTree) {
        this.tempSubTree = tempSubTree;
    }

    public List<InternalTreeNode> getPathTo(AssetNodeIdentifier id) {
        if (Objects.equals(id, this.id)) {
            ArrayList<InternalTreeNode> arrayList = new ArrayList<InternalTreeNode>();
            arrayList.add(this);
            return arrayList;
        }
        if (this.children != null) {
            List list = this.children.stream().map(c -> c.getPathTo(id)).filter(Objects::nonNull).findFirst().orElse(null);
            if (list != null) {
                list.add(0, this);
            }
            return list;
        }
        return null;
    }

    public TreeNode toExternalNode(AssetClientHandlingImpl assetClientHandlingImpl, AssetNodeIdentifier parent) {
        final ArrayList children = new ArrayList();
        if (this.children != null) {
            this.children.forEach(c -> children.add(c.toExternalNode(assetClientHandlingImpl, this.id)));
        }
        final TreeNodeInfo nodeInfo = assetClientHandlingImpl.getNodeInfo(this.id, new NodeWithParent(this, parent));
        return new TreeNode(){

            @Override
            public boolean isSearchDummy() {
                return nodeInfo.isDummySearchNode();
            }

            @Override
            public boolean isArchived() {
                return nodeInfo.isArchived();
            }

            @Override
            public boolean hasMoreNodes() {
                return InternalTreeNode.this.hasMoreNodes;
            }

            @Override
            public AssetNodeIdentifier getId() {
                return nodeInfo.getId();
            }

            @Override
            public AssetFieldValue getIcon() {
                return nodeInfo.getIcon();
            }

            @Override
            public String getDisplayName() {
                return nodeInfo.getDisplayName();
            }

            @Override
            public List<TreeNode> getChildren() {
                return children;
            }
        };
    }

    public AssetNodeIdentifier makeParentNode() {
        if (this.id.isDevice()) {
            throw new IllegalStateException();
        }
        if (this.id.isRoot()) {
            return null;
        }
        List<AssetNodeIdentifier.Grouping> parent = this.id.getGrouping().subList(0, this.id.getGrouping().size() - 1);
        if (parent.isEmpty()) {
            return AssetNodeIdentifier.ROOT;
        }
        return new AssetNodeIdentifier(parent);
    }
}

