/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.internal;

import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetVO;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.MutableAssetData;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithConfigurableDefault;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithDefinition;
import com.inet.helpdesk.plugins.inventory.server.internal.AssetVOImpl;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AssetViewImpl
implements AssetView {
    private AssetVO device;
    private AssetView parent;
    private MutableAssetData inheritedParentData = new MutableAssetData();
    private MutableAssetData inheritedOwnerData = new MutableAssetData();

    private AssetViewImpl(AssetVO device) {
        this.device = device;
        GUID owner = device.getValue(AssetFields.FIELD_OWNER);
        if (owner == null) {
            this.createParentView();
            if (this.parent != null) {
                this.inheritedParentData.put(AssetFields.FIELD_OWNER, this.parent.getValue(AssetFields.FIELD_OWNER));
            }
        }
        HashMap<AssetFieldWithConfigurableDefault, Object> inheritFields = new HashMap<AssetFieldWithConfigurableDefault, Object>();
        inheritFields.put(AssetFields.FIELD_ROOM, HDUsersAndGroups.FIELD_ROOM);
        inheritFields.put(AssetFields.FIELD_COSTCENTER, HDUsersAndGroups.FIELD_COST_CENTRE);
        inheritFields.put(AssetFields.FIELD_LOCATION, HDUsersAndGroups.FIELD_LOCATION_ID);
        for (Map.Entry en : inheritFields.entrySet()) {
            UserAccount account;
            Object room = device.getValue((AssetField)((Object)en.getKey()));
            if (this.hasValue(room)) continue;
            GUID value = this.getValue(AssetFields.FIELD_OWNER);
            if (value != null && (account = UserManager.getInstance().getUserAccount(value)) != null && this.hasValue(account.getValue((UserField)en.getValue()))) {
                this.inheritedOwnerData.put((AssetField)((Object)en.getKey()), account.getValue((UserField)en.getValue()));
            }
            if (this.inheritedOwnerData.containsKey((AssetField)((Object)en.getKey()))) continue;
            this.createParentView();
            if (this.parent == null) continue;
            this.inheritedParentData.put((AssetField)((Object)en.getKey()), this.parent.getValue((AssetField)((Object)en.getKey())));
        }
        this.parent = null;
    }

    private boolean hasValue(Object value) {
        return value != null && (!(value instanceof String) || !((String)value).isEmpty());
    }

    @Override
    public <VALUE> VALUE getValue(AssetField<VALUE> field) {
        if (field instanceof AssetFieldWithDefinition && !((AssetFieldWithDefinition)field).isVisibleInType(this.device.getType())) {
            return null;
        }
        if (this.inheritedOwnerData.containsKey(field)) {
            return this.inheritedOwnerData.get(field);
        }
        if (this.inheritedParentData.containsKey(field)) {
            return this.inheritedParentData.get(field);
        }
        return this.device.getValue(field);
    }

    private void createParentView() {
        if (this.parent == null && this.device.getParentID() != null) {
            try (UserAccountScope s = UserAccountScope.createPrivileged();){
                this.parent = AssetManager.getInstance().getAsset(this.device.getParentID());
            }
        }
    }

    @Override
    @Nonnull
    public GUID getId() {
        return this.device.getId();
    }

    @Override
    public boolean isArchived() {
        return this.device.isArchived();
    }

    @Override
    public List<GUID> getChildAssetIDs() {
        return this.device.getChildAssetIDs();
    }

    @Override
    public AssetView.ValueSource isInherited(AssetField<?> field) {
        return this.inheritedOwnerData.containsKey(field) ? AssetView.ValueSource.Owner : (this.inheritedParentData.containsKey(field) ? AssetView.ValueSource.Parent : AssetView.ValueSource.Asset);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.device == null ? 0 : this.device.hashCode());
        result = 31 * result + (this.inheritedParentData == null ? 0 : this.inheritedParentData.hashCode());
        result = 31 * result + (this.inheritedOwnerData == null ? 0 : this.inheritedOwnerData.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AssetViewImpl other = (AssetViewImpl)obj;
        if (!other.getId().equals((Object)this.getId())) {
            return false;
        }
        if (other.isArchived() != this.isArchived()) {
            return false;
        }
        if (!other.getChildAssetIDs().equals(this.getChildAssetIDs())) {
            return false;
        }
        for (AssetField f : DynamicExtensionManager.getInstance().get(AssetField.class)) {
            if (Objects.equals(this.getValue(f), other.getValue(f))) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public <VALUE> VALUE getOwnValue(AssetField<VALUE> field) {
        return this.device.getValue(field);
    }

    @Nullable
    static AssetView create(AssetVO assetVO) {
        if (assetVO == null) {
            return null;
        }
        return new AssetViewImpl(assetVO);
    }

    static AssetViewImpl create(AssetViewImpl asset, MutableAssetData oldData) {
        AssetViewImpl snapshot = new AssetViewImpl(asset.device){};
        snapshot.inheritedOwnerData.putAll(oldData);
        return snapshot;
    }

    public AssetVOImpl getAssetVO() {
        return (AssetVOImpl)this.device;
    }
}

