/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.config.generics;

import com.inet.annotations.JsonData;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigRowAction;
import com.inet.config.structure.model.ItemListConfigProperty;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.helpdesk.config.TicketValueIconConfigProperty;
import com.inet.helpdesk.config.Translator;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.vendor.AssetVendor;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.vendor.AssetVendorManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

@JsonData
public class VendorListConfigProperty
extends ItemListConfigProperty {
    public static final String PROPERTY_KEY = "DeviceVendors";

    public VendorListConfigProperty(ConfigStructureSettings settings, Translator translator) {
        super(0, PROPERTY_KEY, "GENERIC_WITHICON", VendorListConfigProperty.getObjectListValue(settings), null, new ConfigRowAction[]{VendorListConfigProperty.getRowAction(translator, settings.getLocale().getLanguage())});
        this.setDuplicatePossible(true);
    }

    static Object getObjectListValue(ConfigStructureSettings settings) {
        ArrayList changedValueRaw = (ArrayList)settings.getChangedValue(PROPERTY_KEY, ArrayList.class);
        if (changedValueRaw != null) {
            changedValueRaw.sort(Comparator.comparing(o -> (String)o.get("name"), String.CASE_INSENSITIVE_ORDER));
            return changedValueRaw;
        }
        List list = AssetVendorManager.getInstance().getAll(true);
        ArrayList<HashMap> result = new ArrayList<HashMap>();
        for (AssetVendor type : list) {
            HashMap<String, String> entry = VendorListConfigProperty.convertToHashmap(type);
            result.add(entry);
        }
        result.sort(Comparator.comparing(o -> (String)o.get("name"), String.CASE_INSENSITIVE_ORDER));
        return result;
    }

    private static HashMap<String, String> convertToHashmap(AssetVendor action) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("id", "" + action.getId());
        result.put("name", action.getName());
        result.put("email", action.getEMail());
        result.put("phone", action.getTelefon());
        result.put("fax", action.getFax());
        result.put("address", action.getAdresse());
        result.put("rma", action.getRMA());
        result.put("imageTypeId", String.valueOf(16));
        TicketValueIconConfigProperty.prepareConfigValueMapForIcons(result);
        return result;
    }

    private static ConfigRowAction getRowAction(Translator translator, String language) {
        ConfigAction action = new ConfigAction("vendor.new", translator.translate(new String[]{"field.vendor.add"}));
        ConfigCategory category = new ConfigCategory(0, "vendor.new", translator.translate(new String[]{"field.vendor.name"}), "assets.vendors");
        ArrayList<ConfigPropertyGroup> propertyGroups = new ArrayList<ConfigPropertyGroup>();
        propertyGroups.add(new ConfigPropertyGroup(0, "vendor.new.group", ""));
        HashMap properties = new HashMap();
        ArrayList<Object> propertyList = new ArrayList<Object>();
        properties.put("vendor.new.group", propertyList);
        ArrayList conditions = new ArrayList();
        ConfigRowAction rowAction = new ConfigRowAction(action, null, category, propertyGroups, properties, conditions);
        propertyList.add(VendorListConfigProperty.propWith("SimpleText", translator.translate(new String[]{"field.vendor.row.name"}), "name", ""));
        propertyList.add(VendorListConfigProperty.propWith("SimpleText", translator.translate(new String[]{"field.vendor.row.email"}), "email", ""));
        propertyList.add(VendorListConfigProperty.propWith("SimpleText", translator.translate(new String[]{"field.vendor.row.phone"}), "phone", ""));
        propertyList.add(VendorListConfigProperty.propWith("SimpleText", translator.translate(new String[]{"field.vendor.row.fax"}), "fax", ""));
        propertyList.add(VendorListConfigProperty.propWith("MultiLineText", translator.translate(new String[]{"field.vendor.row.address"}), "address", ""));
        propertyList.add(new TicketValueIconConfigProperty(0, translator.translate(new String[]{"field.type.row.icon"}), 16));
        propertyList.add(VendorListConfigProperty.propWith("MultiLineText", translator.translate(new String[]{"field.vendor.row.rma"}), "rma", ""));
        propertyList.add(VendorListConfigProperty.propWith("Hidden", "", "id", "-1"));
        return rowAction;
    }

    private static ConfigProperty propWith(String type, String label, String keyName, String value) {
        return new ConfigProperty(0, keyName, type, label, (Object)value, null, null);
    }
}

