/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.config.generics;

import com.inet.annotations.JsonData;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigRowAction;
import com.inet.config.structure.model.ItemListConfigProperty;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.model.SelectConfigProperty;
import com.inet.config.structure.model.TableConfigProperty;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.fieldsettings.api.AbstractFieldSettingsManager;
import com.inet.fieldsettings.api.model.GenericFieldSetting;
import com.inet.helpdesk.config.TicketValueIconConfigProperty;
import com.inet.helpdesk.config.Translator;
import com.inet.helpdesk.plugins.inventory.server.api.AssetFieldSettingsManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.type.AssetTypeManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.type.AssetTypeVO;
import com.inet.helpdesk.plugins.inventory.server.config.InventoryGenericFieldsStructureProvider;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@JsonData
public class TypeListConfigProperty
extends ItemListConfigProperty {
    public static final String PROPERTY_KEY = "DeviceTypes";
    public static final String ENABLED_FIELDS_PROPERTY = "enabledFields";
    public static final String ENABLED_FIELDS_ALL = "fields.enabled.All";
    public static final List<String> ENABLED_FIELDS_ALWAYS_ALLOWED = Arrays.asList(AssetFields.FIELD_NAME.getKey(), AssetFields.FIELD_TYPE.getKey(), AssetFields.FIELD_PARENT.getKey());

    public TypeListConfigProperty(ConfigStructureSettings settings, Translator translator) {
        super(0, PROPERTY_KEY, "GENERIC_WITHICON", TypeListConfigProperty.getObjectListValue(settings), null, new ConfigRowAction[]{TypeListConfigProperty.getRowAction(translator, settings.getLocale().getLanguage())});
        this.setDuplicatePossible(true);
    }

    static Object getObjectListValue(ConfigStructureSettings settings) {
        ArrayList changedValueRaw = (ArrayList)settings.getChangedValue(PROPERTY_KEY, ArrayList.class);
        if (changedValueRaw != null) {
            changedValueRaw.sort(Comparator.comparing(o -> (String)o.get("name"), String.CASE_INSENSITIVE_ORDER));
            return changedValueRaw;
        }
        List list = AssetTypeManager.getInstance().getAll(true);
        ArrayList<HashMap> result = new ArrayList<HashMap>();
        for (AssetTypeVO type : list) {
            HashMap<String, String> entry = TypeListConfigProperty.convertToHashmap(type);
            result.add(entry);
        }
        result.sort(Comparator.comparing(o -> (String)o.get("name"), String.CASE_INSENSITIVE_ORDER));
        return result;
    }

    public static HashMap<String, String> convertToHashmap(AssetTypeVO action) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("id", "" + action.getId());
        result.put("name", action.getDisplayValue());
        result.put("image", action.getSymbol());
        result.put(ENABLED_FIELDS_PROPERTY, TypeListConfigProperty.getFieldsTheTypeEnables(action));
        result.put("imageTypeId", String.valueOf(14));
        result.put("iconlib", "weblib/assettypeicons.zip");
        TicketValueIconConfigProperty.prepareConfigValueMapForIcons(result);
        return result;
    }

    public static String toJson(List<String> list) {
        return new Json().toJson(list.stream().map(s -> Collections.singletonList(s)).collect(Collectors.toList()));
    }

    private static String getFieldsTheTypeEnables(AssetTypeVO type) {
        ArrayList<String> enabledFields = new ArrayList<String>();
        AssetFieldSettingsManager manager = AssetFieldSettingsManager.getInstance();
        List all = manager.getSettings();
        for (GenericFieldSetting setting : all) {
            AssetFieldDefinition definition;
            if (ENABLED_FIELDS_ALWAYS_ALLOWED.contains(setting.getKey()) || (definition = (AssetFieldDefinition)manager.getDefinitionForSetting(setting.getKey())) == null || !definition.isVisibleInType(type.getId())) continue;
            enabledFields.add(setting.getKey());
        }
        if (enabledFields.size() == all.size() - ENABLED_FIELDS_ALWAYS_ALLOWED.size()) {
            enabledFields.clear();
            enabledFields.add(ENABLED_FIELDS_ALL);
        }
        return TypeListConfigProperty.toJson(enabledFields);
    }

    public static void saveEnabledFieldsFor(String enabledFieldsJson, int deviceTypeId) {
        List enabledFields = (List)new Json().fromJson(enabledFieldsJson, (Type)new JsonParameterizedType(List.class, new Type[]{new JsonParameterizedType(List.class, new Type[]{String.class})}));
        List enabledFieldsX = enabledFields.stream().map(e -> (String)e.get(0)).collect(Collectors.toList());
        AssetFieldSettingsManager manager = AssetFieldSettingsManager.getInstance();
        List all = manager.getSettings();
        manager.doBatchModification(() -> {
            for (GenericFieldSetting setting : all) {
                boolean fieldAllowsType;
                if (ENABLED_FIELDS_ALWAYS_ALLOWED.contains(setting.getKey())) continue;
                String key = setting.getKey();
                Map map = setting.toMap((AbstractFieldSettingsManager)manager);
                List allowedTypes_List = (List)new Json().fromJson((String)map.get("prop_visible_if"), (Type)new JsonParameterizedType(List.class, new Type[]{new JsonParameterizedType(List.class, new Type[]{String.class})}));
                ArrayList<String> allowedTypesX = new ArrayList<String>(allowedTypes_List.stream().map(e -> (String)e.get(0)).collect(Collectors.toList()));
                boolean bl = fieldAllowsType = allowedTypesX.contains(String.valueOf(deviceTypeId)) || allowedTypesX.contains(String.valueOf(-2));
                if (enabledFieldsX.contains(key) || enabledFieldsX.contains(ENABLED_FIELDS_ALL)) {
                    if (fieldAllowsType) continue;
                    allowedTypesX.add(String.valueOf(deviceTypeId));
                    map.put("prop_visible_if", TypeListConfigProperty.toJson(allowedTypesX));
                    manager.updateSetting(key, map);
                    continue;
                }
                if (!fieldAllowsType) continue;
                if (allowedTypesX.contains(String.valueOf(-2))) {
                    allowedTypesX.clear();
                    AssetTypeManager.getInstance().getAll(true).forEach(t -> {
                        if (t.getId() != deviceTypeId) {
                            allowedTypesX.add(String.valueOf(t.getId()));
                        }
                    });
                }
                allowedTypesX.remove(String.valueOf(deviceTypeId));
                map.put("prop_visible_if", TypeListConfigProperty.toJson(allowedTypesX));
                manager.updateSetting(key, map);
            }
        });
    }

    private static ConfigRowAction getRowAction(Translator translator, String language) {
        ConfigAction action = new ConfigAction("type.new", translator.translate(new String[]{"field.type.add"}));
        ConfigCategory category = new ConfigCategory(0, "type.new", translator.translate(new String[]{"field.type.name"}), "assets.types");
        ArrayList<ConfigPropertyGroup> propertyGroups = new ArrayList<ConfigPropertyGroup>();
        propertyGroups.add(new ConfigPropertyGroup(0, "type.new.group", ""));
        HashMap properties = new HashMap();
        ArrayList<Object> propertyList = new ArrayList<Object>();
        properties.put("type.new.group", propertyList);
        ArrayList conditions = new ArrayList();
        ConfigRowAction rowAction = new ConfigRowAction(action, null, category, propertyGroups, properties, conditions);
        propertyList.add(TypeListConfigProperty.propWith("SimpleText", translator.translate(new String[]{"field.type.row.name"}), "name", ""));
        propertyList.add(new TicketValueIconConfigProperty(0, translator.translate(new String[]{"field.type.row.icon"}), 14));
        propertyList.add(new ConfigProperty(0, "iconlib", "Link", translator.translate(new String[]{"field.type.row.iconlib"}), (Object)"weblib/assettypeicons.zip", null, translator.translate(new String[]{"field.type.row.iconlib.linktext"})));
        List options = AssetFieldSettingsManager.getInstance().getSettings().stream().filter(sett -> !ENABLED_FIELDS_ALWAYS_ALLOWED.contains(sett.getKey())).map(sett -> (AssetFieldDefinition)AssetFieldSettingsManager.getInstance().getDefinitionForSetting(sett.getKey())).map(field -> new LocalizedKey(String.valueOf(field.getFieldKey()), field.getLabel())).collect(Collectors.toList());
        options.add(0, new LocalizedKey(ENABLED_FIELDS_ALL, InventoryGenericFieldsStructureProvider.MSG.getMsg("field.type.row.enabledFields.all", new Object[0])));
        ConfigAction[] addFieldAction = new ConfigAction[]{new ConfigAction(InventoryGenericFieldsStructureProvider.MSG.getMsg("field.type.row.enabledFields.add", new Object[0]))};
        String key = ENABLED_FIELDS_PROPERTY;
        List rows = Collections.emptyList();
        ConfigProperty[] columns = new ConfigProperty[]{new SelectConfigProperty(0, "Field", "SimpleText", InventoryGenericFieldsStructureProvider.MSG.getMsg("field.type.row.enabledFields.tableHead", new Object[0]), null, null, options)};
        String label = InventoryGenericFieldsStructureProvider.MSG.getMsg("field.type.row.enabledFields", new Object[0]);
        int[] columnSizes = new int[]{100};
        TableConfigProperty showFieldifTypeIsProperty = new TableConfigProperty(0, key, "SimpleText", label, "", rows, columns, columnSizes, addFieldAction, null);
        showFieldifTypeIsProperty.setEmptyLabel(InventoryGenericFieldsStructureProvider.MSG.getMsg("field.type.row.enabledFields.emptyHint", new Object[0]));
        propertyList.add(showFieldifTypeIsProperty);
        propertyList.add(TypeListConfigProperty.propWith("Hidden", "", "id", "-1"));
        return rowAction;
    }

    private static ConfigProperty propWith(String type, String label, String keyName, String value) {
        return new ConfigProperty(0, keyName, type, label, (Object)value, null, null);
    }
}

