/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.api.maintenance;

import com.inet.annotations.JsonData;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField_Currency;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.PreviewEntry;
import java.util.ArrayList;
import java.util.List;

@JsonData
public class AssetPreviewEntry
extends PreviewEntry<String> {
    public PreviewEntry<String> from(String value) throws ServerDataException {
        throw new UnsupportedOperationException();
    }

    public static AssetPreviewEntry generateEntryFromAsset(AssetView asset) {
        AssetPreviewEntry e = new AssetPreviewEntry();
        List<AssetField_Currency> deviceFields = List.of(AssetFields.FIELD_TYPE, AssetFields.FIELD_LOCATION, AssetFields.FIELD_ROOM, AssetFields.FIELD_SERIAL_NUMBER, AssetFields.FIELD_ASSET_NUMBER, AssetFields.FIELD_COSTCENTER, AssetFields.FIELD_PURCHASE_DATE, AssetFields.FIELD_PRICE);
        e.setTitle(asset.getName());
        e.setIcon("images/devicetype/" + asset.getType() + "?size=64");
        ArrayList<LocalizedKey> details = new ArrayList<LocalizedKey>();
        for (AssetField assetField : deviceFields) {
            AssetFieldDefinition def = AssetFields.getFieldDefinitionFor(assetField.getKey());
            String displayValue = def.getDisplayValue(asset);
            if (displayValue == null) continue;
            details.add(new LocalizedKey(def.getLabel(), displayValue));
        }
        e.setDetails(details);
        return e;
    }
}

