/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.taskplanner.trigger;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.plugins.inventory.server.api.AssetListener;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.id.GUID;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.TextSearchCommandBuilder;
import com.inet.search.index.IndexSearchEngine;
import com.inet.taskplanner.server.api.TaskExecution;
import com.inet.taskplanner.server.api.TaskPlanner;
import com.inet.taskplanner.server.api.trigger.Trigger;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.Nullable;

public class LowHighInventoryTrigger
implements Trigger,
AssetListener {
    private final GUID taskId;
    private final GUID triggerId;
    private final Map<String, String> properties;
    private boolean isSoonGoingToTriggerIfNeeded;
    private GUID taskOwner;
    private Trigger.TriggerAction triggerAction;
    protected static int DELAY = 2000;

    public LowHighInventoryTrigger(GUID taskId, GUID triggerId, Map<String, String> properties) {
        this.taskId = taskId;
        this.triggerId = triggerId;
        this.properties = properties;
    }

    @Override
    public void assetChanged(@Nullable AssetView oldState, @Nullable AssetView newState) {
        if (this.isSoonGoingToTriggerIfNeeded || this.triggerAction == null) {
            return;
        }
        final Trigger.TriggerAction a = this.triggerAction;
        if (a != null) {
            this.isSoonGoingToTriggerIfNeeded = true;
            final Timer t = new Timer("runTrigger");
            t.schedule(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try (UserAccountScope scope = UserAccountScope.create((GUID)LowHighInventoryTrigger.this.taskOwner);){
                        if (LowHighInventoryTrigger.this.isTooManyOrTooFewAssets()) {
                            if (!LowHighInventoryTrigger.this.wasTriggeredLastTime()) {
                                LowHighInventoryTrigger.this.setTriggeredLastTime(true);
                                a.run();
                            }
                        } else if (LowHighInventoryTrigger.this.wasTriggeredLastTime()) {
                            LowHighInventoryTrigger.this.setTriggeredLastTime(false);
                        }
                        t.cancel();
                    }
                    catch (Throwable t2) {
                        HDLogger.error((Object)t2);
                    }
                    finally {
                        LowHighInventoryTrigger.this.isSoonGoingToTriggerIfNeeded = false;
                    }
                }
            }, DELAY);
        }
    }

    private boolean isTooManyOrTooFewAssets() {
        Integer howMany = Integer.valueOf(this.properties.get("howMany"));
        String moreOrLess = this.properties.get("greaterOrSmaller");
        String query = this.properties.get("query");
        if (moreOrLess != null && query != null && moreOrLess.equals("smaller")) {
            int howManyActually = this.runQuery(query);
            HDLogger.debug((Object)("found " + howManyActually + " assets"));
            return howManyActually < howMany;
        }
        if (query != null) {
            int howManyActually = this.runQuery(query);
            HDLogger.debug((Object)("found " + howManyActually + " assets"));
            return howManyActually > howMany;
        }
        return false;
    }

    public void activate(Trigger.TriggerAction action) {
        this.activate(null, action);
    }

    public void activate(GUID taskID, Trigger.TriggerAction action) {
        this.taskOwner = this.getOwnerId(taskID);
        this.triggerAction = action;
        DynamicExtensionManager.getInstance().register(AssetListener.class, (Object)this);
    }

    protected GUID getOwnerId(GUID taskGUID) {
        return TaskPlanner.getInstance().getTaskExecution(taskGUID).getOwnerId();
    }

    public int runQuery(String queryPrefix) {
        String query = this.properties.get("query");
        IndexSearchEngine searchEngine = this.getAssetManager().getSearchEngine();
        SearchCommand command = new TextSearchCommandBuilder(searchEngine, queryPrefix + " " + query).build();
        return searchEngine.simpleSearch(command).size();
    }

    protected AssetManager getAssetManager() {
        return AssetManager.getInstance();
    }

    public void deactivate() {
        this.triggerAction = null;
        this.setTriggeredLastTime(false);
        DynamicExtensionManager.getInstance().unregister(AssetListener.class, (Object)this);
    }

    private String triggeredKey() {
        return String.valueOf(this.taskId) + "/" + String.valueOf(this.triggerId) + "/alreadyTriggered";
    }

    private boolean wasTriggeredLastTime() {
        TaskExecution taskExecution = TaskPlanner.getInstance().getTaskExecution(this.taskId);
        if (taskExecution != null) {
            Map stateProperties = taskExecution.getStateProperties();
            return "true".equals(stateProperties.get(this.triggeredKey()));
        }
        return false;
    }

    private void setTriggeredLastTime(boolean wasTriggered) {
        TaskExecution taskExecution = TaskPlanner.getInstance().getTaskExecution(this.taskId);
        if (taskExecution != null) {
            Map stateProperties = taskExecution.getStateProperties();
            stateProperties.put(this.triggeredKey(), "" + wasTriggered);
        }
    }
}

