/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.taskplanner.series.asset;

import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.taskplanner.InventoryPlaceholders;
import com.inet.helpdesk.plugins.inventory.server.taskplanner.i18n.InventoryTaskPlannerMsg;
import com.inet.helpdesk.plugins.inventory.server.taskplanner.series.asset.AssetSeries;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.TextField;
import com.inet.taskplanner.server.api.series.SeriesDefinition;
import com.inet.taskplanner.server.api.series.SeriesFactory;
import com.inet.taskplanner.server.api.series.SeriesInfo;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AssetSeriesFactory
extends SeriesFactory<AssetSeries> {
    public static final String EXTENSION_NAME = "series.helpdesk.assets";
    public static final String PROPERTY_QUERY = "query";
    public static final String PROPERTY_LOCALE = "locale";

    public AssetSeriesFactory() {
        super(EXTENSION_NAME);
    }

    public SeriesInfo getInformation(@Nullable GUID guid) {
        ArrayList<TextField> fields = new ArrayList<TextField>();
        TextField queryField = new TextField(PROPERTY_QUERY, InventoryTaskPlannerMsg.MSG.getMsg("AssetSeries.filter", new Object[0]));
        fields.add(queryField);
        URL iconURL = ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/inventory/server/images/inventory_32.svg");
        return new SeriesInfo(this.getExtensionName(), InventoryTaskPlannerMsg.MSG.getMsg("AssetSeries.name", new Object[0]), InventoryTaskPlannerMsg.MSG.getMsg("AssetSeries.description", new Object[0]), iconURL, "taskplanner.series.assets", fields);
    }

    public void validate(@Nonnull SeriesDefinition definition, GUID guid) throws ValidationException {
    }

    public Map<String, String> updateValues(@Nonnull SeriesDefinition definition, GUID taskID) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put(PROPERTY_LOCALE, AssetSeriesFactory.getLocale(null));
        return values;
    }

    public SummaryInfo getSummary(@Nonnull SeriesDefinition definition) {
        ArrayList<SummaryEntry> summary = new ArrayList<SummaryEntry>();
        String query = definition.getProperty(PROPERTY_QUERY);
        String locale = AssetSeriesFactory.getLocale(definition);
        Collection<GUID> ids = new AssetSeries(null, GUID.generateNew(), query, locale).runSearch(this.getAssetManager());
        int size = ids.size();
        if (query == null || query.isBlank()) {
            summary.add(new SummaryEntry("", InventoryTaskPlannerMsg.MSG.getMsg("AssetSeries.summary.all", new Object[0])));
        } else {
            summary.add(new SummaryEntry("", InventoryTaskPlannerMsg.MSG.getMsg("AssetSeries.summary.filtered", new Object[]{query})));
        }
        summary.add(new SummaryEntry(InventoryTaskPlannerMsg.MSG.getMsg("trigger.inventory.currentResults", new Object[]{size}), ""));
        return new SummaryInfo(summary);
    }

    protected AssetSeries createInstanceFrom(@Nonnull SeriesDefinition definition, @Nullable GUID taskID) {
        String property = definition.getProperty(PROPERTY_QUERY);
        String l = AssetSeriesFactory.getLocale(definition);
        return new AssetSeries(taskID, definition.getUid(), property, l);
    }

    @Nonnull
    private static String getLocale(@Nullable SeriesDefinition definition) {
        String l = null;
        if (definition != null) {
            l = definition.getProperty(PROPERTY_LOCALE);
        }
        if (l == null) {
            UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
            l = currentUserAccount == null ? Locale.getDefault().toLanguageTag() : (String)currentUserAccount.getValue((UserField)HDUsersAndGroups.FIELD_LANGUAGE);
        }
        return l;
    }

    @Nonnull
    public Set<String> getKeys(@Nonnull SeriesDefinition definition) {
        return new HashSet<String>(InventoryPlaceholders.getInventoryPlaceholderKeys());
    }

    public boolean isAvailable() {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        return currentUserAccount != null && HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount);
    }

    protected AssetManager getAssetManager() {
        return AssetManager.getInstance();
    }
}

