/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.reporting.dataview;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.error.ErrorCode;
import com.inet.field.fieldtypes.HasSelectOptions;
import com.inet.helpdesk.core.reporting.server.dataview.TemplateDataViewDefaultsHD;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.type.AssetTypeManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.type.AssetTypeVO;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.settings.ClientTreeSettings;
import com.inet.helpdesk.plugins.inventory.server.api.search.SearchAssets;
import com.inet.helpdesk.plugins.inventory.server.reporting.datasource.AssetAdhocDataSource;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.permissions.AccessDeniedException;
import com.inet.report.DatabaseTables;
import com.inet.report.Datasource;
import com.inet.report.Engine;
import com.inet.report.RDC;
import com.inet.report.ReportException;
import com.inet.report.TableSource;
import com.inet.report.adhoc.server.api.datasource.DataSourceUtils;
import com.inet.report.adhoc.server.api.datasource.DataViewConditions;
import com.inet.report.adhoc.server.api.dataview.DataFilter;
import com.inet.report.adhoc.server.api.dataview.DataView;
import com.inet.report.adhoc.server.api.dataview.SimpleDataView;
import com.inet.report.adhoc.server.api.dataview.TemplateDataViewDefaults;
import com.inet.report.adhoc.server.api.renderer.RendererPropertyKey;
import com.inet.report.adhoc.server.api.renderer.table.TableColumnData;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.config.datasource.DataSourceConfigurationManager;
import com.inet.report.database.ColumnInfo;
import com.inet.report.database.DataFactory;
import com.inet.search.SuggestedValue;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataView_Assets
extends TemplateDataViewDefaultsHD {
    @Nonnull
    public String getExtensionName() {
        return "dataview_assets";
    }

    @Nonnull
    public String getDisplayName() {
        return AssetManager.MSG.getMsg("dataview.assets", new Object[0]);
    }

    @Nullable
    public String getDescription() {
        return AssetManager.MSG.getMsg("dataview.assets.description", new Object[0]);
    }

    @Nullable
    public <T> T get(@Nonnull RendererPropertyKey<T> key) {
        AssetTypeManager atm;
        List all;
        if (key == TABLE_COLUMNS) {
            return (T)new TableColumnData[]{new TableColumnData("AssetsAdhoc." + AssetFields.FIELD_NAME.getKey()), new TableColumnData("AssetsAdhoc." + AssetFields.FIELD_LOCATION.getKey()), new TableColumnData("AssetsAdhoc." + AssetFields.FIELD_LICENSE.getKey()), new TableColumnData("AssetsAdhoc." + AssetFields.FIELD_OWNER.getKey()), new TableColumnData("AssetsAdhoc." + AssetFields.FIELD_PARENT.getKey())};
        }
        if (key == TABLE_GROUPS) {
            // empty if block
        }
        if (key == FILTER_DEFINITION && !(all = (atm = AssetTypeManager.getInstance()).getAll(true)).isEmpty()) {
            AssetTypeVO assetTypeVO = (AssetTypeVO)((Object)all.get(0));
            return (T)new DataFilter(List.of(List.of(new DataFilter.DataFilterEntry("AssetsAdhoc." + AssetFields.FIELD_TYPE.getKey(), DataFilter.Operation.equals, new LocalizedKey(String.valueOf(assetTypeVO.getId()), assetTypeVO.getDisplayValue()), null))));
        }
        return null;
    }

    @Nonnull
    public @Nonnull List<// Could not load outer class - annotation placement on inner may be incorrect
     @Nonnull TemplateDataViewDefaults.Column> getAvailableColumns() {
        DataSourceConfiguration userSourceCfg = DataSourceConfigurationManager.getDataSource((String)"Assets - Adhoc");
        if (userSourceCfg == null) {
            throw new IllegalStateException("Datasource Assets - Adhoc is missing");
        }
        try {
            Engine engine = RDC.createEmptyEngine((String)"java");
            return this.getFields(engine);
        }
        catch (ReportException ex) {
            throw (RuntimeException)ErrorCode.throwAny((Throwable)ex);
        }
    }

    @Nonnull
    private @Nonnull List<// Could not load outer class - annotation placement on inner may be incorrect
     @Nonnull TemplateDataViewDefaults.Column> getFields(@Nonnull Engine engine) throws ReportException {
        DataSourceConfiguration userSourceCfg = DataSourceConfigurationManager.getDataSource((String)"Assets - Adhoc");
        if (userSourceCfg == null) {
            throw new IllegalStateException("Datasource Assets - Adhoc is missing");
        }
        DatabaseTables dbTables = engine.getDatabaseTables();
        Datasource userSource = dbTables.getDatasource(0);
        userSource.setDataSourceConfiguration(userSourceCfg);
        ArrayList<// Could not load outer class - annotation placement on inner may be incorrect
         @Nonnull TemplateDataViewDefaults.Column> dataFields = new ArrayList<TemplateDataViewDefaults.Column>();
        DataFactory dataFactory = userSource.getDataFactory();
        TableSource ts = userSource.createTableSource("AssetsAdhoc");
        List columns = dataFactory.getColumns(ts);
        String alias = ts.getAlias() + ".";
        for (ColumnInfo col : columns) {
            String name = col.getName();
            int dataType = col.getDataType();
            ts.addColumn(name, dataType);
            if (col.getColumnType() != 3) continue;
            DataSourceUtils.ColumnInfoWithLabel column = (DataSourceUtils.ColumnInfoWithLabel)col;
            dataFields.add(new TemplateDataViewDefaults.Column(alias + name, column.getLabel(), dataType));
        }
        return dataFields;
    }

    @Nonnull
    public DataView createDataView(@Nonnull Engine engine, @Nullable DataFilter filter) {
        try {
            List<// Could not load outer class - annotation placement on inner may be incorrect
             @Nonnull TemplateDataViewDefaults.Column> dataFields = this.getFields(engine);
            DataViewConditions dataViewConditions = new DataViewConditions(filter == null ? new DataFilter(List.of()) : filter, List.of());
            String json = new Json().toJson((Object)dataViewConditions);
            AssetAdhocDataSource.buildSearchExpressionForAssetTable(dataViewConditions, "AssetsAdhoc");
            this.setSelectionFormula(engine, filter);
            DatabaseTables dbTables = engine.getDatabaseTables();
            Datasource userSource = dbTables.getDatasource(0);
            DataSourceUtils.setInputParameter((TableSource)userSource.getTableSource("AssetsAdhoc"), (String)"AssetSearchPhraseprompt", (String)json);
            return new SimpleDataView(dataFields, engine);
        }
        catch (ReportException ex) {
            throw (RuntimeException)ErrorCode.throwAny((Throwable)ex);
        }
    }

    @Nullable
    public List<LocalizedKey> getFilterSuggestions(@Nonnull Engine engine, @Nonnull String filterColumn, @Nonnull String filterText) {
        if (filterColumn.startsWith("AssetsAdhoc")) {
            String key = filterColumn.substring("AssetsAdhoc".length() + 1);
            AssetFieldDefinition def = AssetFields.getFieldDefinitionFor(key);
            if (def != null) {
                if (!(def instanceof HasSelectOptions)) {
                    String term = def.getLabel() + ":" + filterText;
                    if (def.getFieldKey().equals(AssetFields.FIELD_OWNER.getKey())) {
                        String displayName = UserManager.getInstance().getSearchEngine().getTag("useraccountdisplayname").getDisplayName();
                        term = displayName + "-(" + def.getLabel() + "):" + filterText;
                    } else if (!AssetFields.getFieldFor(key).getSearchTag().isSuggestedTag()) {
                        Iterator valuesIterator = AssetManager.getInstance().getSearchEngine().createValuesIterator(AssetFields.getFieldFor(key).getSearchTag(), true);
                        ArrayList<LocalizedKey> result = new ArrayList<LocalizedKey>();
                        while (result.size() < 50 && valuesIterator.hasNext()) {
                            String val;
                            String next = (String)valuesIterator.next();
                            String string = val = next == null ? "" : next.toString();
                            if (!key.equals(AssetFields.FIELD_PARENT.getKey())) continue;
                            try {
                                String display;
                                String string2 = display = next == null ? "" : AssetManager.getInstance().getAsset(GUID.valueOf((String)val)).getName();
                                if (!display.toLowerCase().startsWith(filterText)) continue;
                                result.add(new LocalizedKey(val, display));
                            }
                            catch (AccessDeniedException accessDeniedException) {}
                        }
                        return result;
                    }
                    List<SuggestedValue> suggestions = SearchAssets.loadSuggestions(term, ClientTreeSettings.TreeFilter.all);
                    return suggestions.stream().map(sv -> new LocalizedKey(sv.getDisplayName(), sv.getDisplayName())).toList();
                }
                if (filterText.isEmpty()) {
                    filterText = null;
                }
                return ((HasSelectOptions)def).getSelectOptions(false).stream().map(o -> new LocalizedKey(o.getValue(), o.getLabel())).collect(Collectors.toList());
            }
            return null;
        }
        return null;
    }
}

