/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.internal.tree;

import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.AssetNodeIdentifier;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.TreeNodeInfo;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.settings.StructureViewSettings;
import com.inet.helpdesk.plugins.inventory.server.api.tree.AssetStructureListener;
import com.inet.helpdesk.plugins.inventory.server.api.tree.AssetTreeUpdateEvent;
import com.inet.helpdesk.plugins.inventory.server.internal.AssetClientHandlingImpl;
import com.inet.helpdesk.plugins.inventory.server.internal.tree.BaseClientHandling;
import com.inet.helpdesk.plugins.inventory.server.internal.tree.InternalTreeNode;
import com.inet.helpdesk.plugins.inventory.server.internal.tree.ListClientHandling;
import com.inet.helpdesk.plugins.inventory.server.internal.tree.NodeWithParent;
import com.inet.helpdesk.plugins.inventory.server.internal.tree.StructureInfo;
import com.inet.helpdesk.plugins.inventory.server.internal.tree.TreeClientHandling;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.servlet.ClientTimezone;
import com.inet.id.GUID;
import com.inet.search.command.SearchID;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StructureClientHandling
extends BaseClientHandling {
    public static List<Integer> STRUCTURE_NUM_OF_SUB_ELEMENTS = Arrays.asList(10, 5, 3, 2);
    public static int STRUCTURE_MORE_NODES_THRESHOLD = 2;
    public static final ThreadLocal<AtomicBoolean> STRUCTURE_STOPPED = new ThreadLocal();
    private AtomicBoolean structureStopped = new AtomicBoolean(false);
    private AssetNodeIdentifier structureRoot;
    @Nullable
    private AssetNodeIdentifier structureRootParent;
    private StructureViewSettings settings;
    private String clientId;
    private TreeClientHandling treeHandling;
    private AssetClientHandlingImpl clientHandling;
    private InternalTreeNode currentStructure = null;
    private InternalTreeNode newStructure = null;
    private List<AssetFieldDefinition> columns;
    private AssetStructureListener listener;
    private GUID userAccountId;
    private TimeZone clientZone;
    private Locale locale;

    public StructureClientHandling(AssetNodeIdentifier structureRoot, StructureViewSettings settings, String clientId, Integer initialOpenedNodes, TreeClientHandling treeHandling, AssetStructureListener listener, AssetClientHandlingImpl clientHandling) {
        this.structureRoot = structureRoot;
        this.settings = settings;
        this.clientId = clientId;
        this.treeHandling = treeHandling;
        this.clientHandling = clientHandling;
        this.userAccountId = UserManager.getInstance().getCurrentUserAccountID();
        this.listener = listener;
        this.locale = ClientLocale.getThreadLocale();
        this.clientZone = ClientTimezone.getTimeZone();
        InventoryServerPlugin.LOGGER.debug((Object)("[Structure] registered with settings " + settings.toString()));
        this.eventDispatcher.dispatchEvent(() -> {
            HashMap<AssetNodeIdentifier, Integer> initialMap = new HashMap<AssetNodeIdentifier, Integer>();
            if (initialOpenedNodes != null) {
                initialMap.put(structureRoot, initialOpenedNodes);
            }
            this.checkForChangesAndSendEvents(Collections.emptySet(), initialMap, false);
        });
        treeHandling.expandTreeToNode(structureRoot);
    }

    @Override
    protected void checkForVisibleChangesImpl(@Nonnull Set<GUID> id) {
        this.checkForChangesAndSendEvents(id, Collections.emptyMap(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForChangesAndSendEvents(@Nonnull Set<GUID> id, Map<AssetNodeIdentifier, Integer> inititalNodesMap, boolean structuralChange) {
        Locale origLoc = ClientLocale.getThreadLocale();
        TimeZone origTZ = ClientTimezone.getTimeZone();
        try (UserAccountScope sc = UserAccountScope.create((GUID)this.userAccountId);){
            ClientLocale.setThreadLocale((Locale)this.locale);
            ClientTimezone.setTimeZone((TimeZone)this.clientZone);
            STRUCTURE_STOPPED.set(this.structureStopped);
            InternalTreeNode rootNode = new InternalTreeNode(this.structureRoot);
            rootNode.openNode();
            Integer integer = inititalNodesMap.get(this.structureRoot);
            if (this.settings.isFlatList()) {
                int nodeLimit = integer != null ? integer : TreeClientHandling.CHUNKSIZE;
                nodeLimit = Math.max(nodeLimit % TreeClientHandling.CHUNKSIZE == 0 ? nodeLimit : (nodeLimit / TreeClientHandling.CHUNKSIZE + 1) * TreeClientHandling.CHUNKSIZE, TreeClientHandling.CHUNKSIZE);
                ListClientHandling listHandling = new ListClientHandling(this.settings, this.treeHandling);
                this.structureRootParent = listHandling.addSortedFlatList(rootNode, nodeLimit);
                this.columns = listHandling.getColumns();
            } else {
                int nodeLimit = integer != null && integer > 0 ? 20000 : TreeClientHandling.CHUNKSIZE * 10;
                StructureInfo structureInfo = new StructureInfo(this.settings.getDepth(), StructureInfo.TYPE.Structure, nodeLimit, this.treeHandling.getSettings(), this.currentStructure);
                this.structureRootParent = this.treeHandling.main_addChildrenInExistingNode(rootNode, structureInfo, structuralChange, inititalNodesMap);
            }
            this.newStructure = rootNode;
            InventoryServerPlugin.LOGGER.debug((Object)("new Structure= " + String.valueOf(this.newStructure)));
            if (this.stopped) {
                return;
            }
            this.treeHandling.main_sendChangesIfDifferent(this.currentStructure, rootNode, id, inititalNodesMap, rootNode, event -> {
                if (!this.stopped) {
                    InventoryServerPlugin.LOGGER.debug((Object)("[Structure] Send event: " + event.toString()));
                    this.listener.sendChanges(this.clientId, this.structureRoot, (AssetTreeUpdateEvent)event, this.settings.isFlatList() ? this.columns : null);
                }
            });
            this.currentStructure = rootNode;
        }
        catch (Throwable error) {
            InventoryServerPlugin.LOGGER.error(error);
            this.listener.sendError(this.clientId, error);
        }
        finally {
            ClientLocale.setThreadLocale((Locale)origLoc);
            ClientTimezone.setTimeZone((TimeZone)origTZ);
            STRUCTURE_STOPPED.remove();
        }
    }

    @Override
    protected SearchID createSearchID() {
        return new SearchID((Object)("deviceStructure_" + this.clientId));
    }

    @Override
    public void stop() {
        super.stop();
        this.structureStopped.set(true);
    }

    public void settingsChanged() {
        this.checkForVisibleChanges(null);
    }

    public void settingsChanged(StructureViewSettings newSettings) {
        if (newSettings.equals(this.settings)) {
            return;
        }
        this.eventDispatcher.dispatchEvent(() -> {
            this.settings = newSettings;
            this.checkForVisibleChangesImpl(Collections.emptySet());
        });
    }

    public void loadMoreNodes() {
        InternalTreeNode node = this.currentStructure;
        if (node != null) {
            int oldSize = node.getChildren().size();
            int newSize = oldSize + TreeClientHandling.CHUNKSIZE;
            if (newSize % TreeClientHandling.CHUNKSIZE != 0) {
                newSize = (newSize / TreeClientHandling.CHUNKSIZE + 1) * TreeClientHandling.CHUNKSIZE;
            }
            Map<AssetNodeIdentifier, Integer> map = Collections.singletonMap(node.getId(), newSize);
            this.eventDispatcher.dispatchEvent(() -> this.checkForChangesAndSendEvents(Collections.emptySet(), map, false));
        }
    }

    public TreeNodeInfo getNodeInfo(AssetNodeIdentifier key) {
        if (this.newStructure == null) {
            return null;
        }
        NodeWithParent node = this.newStructure.findWithParent(key, this.structureRootParent);
        if (node != null) {
            return this.clientHandling.getNodeInfo(key, node);
        }
        return null;
    }

    public void assetChanged(GUID id) {
        this.checkForVisibleChanges(id);
    }

    @Nonnull
    public AssetNodeIdentifier getStructureRoot() {
        return this.structureRoot;
    }
}

