/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.internal.tree;

import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithDefinition;
import com.inet.helpdesk.plugins.inventory.server.internal.search.ValueAndDisplayValue;
import com.inet.id.GUID;
import com.inet.search.SearchTag;
import com.inet.search.index.IndexSearchEngine;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Predicate;

public class DisplayNameIterator<T>
implements Iterator<String> {
    private final Iterator<ValueAndDisplayValue<T>> displayNames;
    private final AssetFieldWithDefinition<T> field;

    public DisplayNameIterator(IndexSearchEngine<GUID> engine, SearchTag tag, AssetFieldWithDefinition<T> field, Predicate<GUID> filter) {
        this.field = field;
        Iterator it = engine.createEntryIterator(tag, null, filter);
        Comparator<ValueAndDisplayValue<T>> comparator = field.getComparator();
        TreeSet<ValueAndDisplayValue<T>> set = new TreeSet<ValueAndDisplayValue<T>>(comparator);
        while (it.hasNext()) {
            Object key;
            Map.Entry e = (Map.Entry)it.next();
            Object indexedValue = e.getKey();
            ValueAndDisplayValue displayValue = new ValueAndDisplayValue(key, (key = field.getValueFromIndexedValue(indexedValue)) == null ? "" : field.getDisplayValue(key));
            set.add(displayValue);
        }
        this.displayNames = set.iterator();
    }

    @Override
    public String next() {
        T next2 = this.displayNames.next().getValue();
        String next = this.field.asString(next2);
        return next;
    }

    @Override
    public boolean hasNext() {
        return this.displayNames.hasNext();
    }
}

