/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.internal;

import com.inet.helpdesk.plugins.inventory.server.api.AssetListener;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.AssetFieldValue;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.AssetNodeIdentifier;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.TreeNode;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.TreeNodeInfo;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.settings.ClientTreeSettings;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.settings.StructureViewSettings;
import com.inet.helpdesk.plugins.inventory.server.api.tree.AssetClientHandler;
import com.inet.helpdesk.plugins.inventory.server.api.tree.AssetClientListener;
import com.inet.helpdesk.plugins.inventory.server.api.tree.AssetStructureListener;
import com.inet.helpdesk.plugins.inventory.server.api.tree.AssetTreeListener;
import com.inet.helpdesk.plugins.inventory.server.internal.AssetManagerImpl;
import com.inet.helpdesk.plugins.inventory.server.internal.tree.AssetClientHandling;
import com.inet.helpdesk.plugins.inventory.server.internal.tree.InternalTreeNode;
import com.inet.helpdesk.plugins.inventory.server.internal.tree.NodeWithParent;
import com.inet.helpdesk.plugins.inventory.server.internal.tree.StructureClientHandling;
import com.inet.helpdesk.plugins.inventory.server.internal.tree.StructureInfo;
import com.inet.helpdesk.plugins.inventory.server.internal.tree.TreeClientHandling;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.thread.EventDispatcher;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public class AssetClientHandlingImpl
implements AssetClientHandler,
AssetListener {
    private Map<String, TreeClientHandling> treeClients = new ConcurrentHashMap<String, TreeClientHandling>();
    private Map<String, StructureClientHandling> structureClients = new ConcurrentHashMap<String, StructureClientHandling>();
    private Map<String, AssetClientHandling> assetClients = new ConcurrentHashMap<String, AssetClientHandling>();
    private Map<String, Consumer<TreeClientHandling>> preHoldStructureClients = new ConcurrentHashMap<String, Consumer<TreeClientHandling>>();
    private Map<String, Consumer<TreeClientHandling>> preHoldAssetClients = new ConcurrentHashMap<String, Consumer<TreeClientHandling>>();
    private EventDispatcher<Void> dispatcher = new EventDispatcher();
    private AssetManagerImpl manager;

    public AssetClientHandlingImpl(AssetManagerImpl manager) {
        this.manager = manager;
        DynamicExtensionManager.getInstance().register(AssetListener.class, (Object)this);
    }

    @Override
    public TreeNodeInfo getNodeInfo(String clientId, AssetNodeIdentifier key, boolean forTreeElseStructure) {
        if (forTreeElseStructure) {
            TreeClientHandling handling = this.treeClients.get(clientId);
            if (handling != null) {
                TreeNodeInfo nodeInfo = handling.getNodeInfo(key);
                if (nodeInfo == null) {
                    InventoryServerPlugin.LOGGER.warn((Object)("[NodeInfo] Node does not exists: " + String.valueOf(key)));
                }
                return nodeInfo;
            }
            InventoryServerPlugin.LOGGER.warn((Object)("No such client: " + clientId));
        } else {
            StructureClientHandling structureClientHandling = this.structureClients.get(clientId);
            if (structureClientHandling != null) {
                TreeNodeInfo nodeInfo = structureClientHandling.getNodeInfo(key);
                if (nodeInfo == null) {
                    InventoryServerPlugin.LOGGER.warn((Object)("[NodeInfo] Node does not exists: " + String.valueOf(key)));
                }
                return nodeInfo;
            }
            InventoryServerPlugin.LOGGER.warn((Object)("No such client: " + clientId));
        }
        return null;
    }

    @Override
    public void registerTreeClient(String clientid, ClientTreeSettings client, Map<AssetNodeIdentifier, Integer> openNodes, AssetTreeListener listener) {
        Consumer<TreeClientHandling> preHoldAssets;
        this.unregisterTreeClient(clientid);
        TreeClientHandling handling = new TreeClientHandling(client, listener, clientid, openNodes == null ? Collections.emptyMap() : openNodes, this.manager, this);
        this.treeClients.put(clientid, handling);
        Consumer<TreeClientHandling> preHold = this.preHoldStructureClients.get(clientid);
        if (preHold != null) {
            preHold.accept(handling);
        }
        if ((preHoldAssets = this.preHoldAssetClients.get(clientid)) != null) {
            preHoldAssets.accept(handling);
        }
    }

    @Override
    public void unregisterTreeClient(String clientId) {
        TreeClientHandling remove;
        StructureClientHandling removeStructure = this.structureClients.remove(clientId);
        if (removeStructure != null) {
            removeStructure.stop();
        }
        if ((remove = this.treeClients.remove(clientId)) != null) {
            remove.stop();
        }
    }

    @Override
    public Map<String, TreeClientHandling> getTreeClients() {
        return Collections.unmodifiableMap(this.treeClients);
    }

    @Override
    public void treeNodesChanged(String clientId, Set<AssetNodeIdentifier> nodesOpened, Set<AssetNodeIdentifier> nodesClosed) {
        TreeClientHandling handling = this.treeClients.get(clientId);
        if (handling != null) {
            handling.nodesOpenedOrClosed(nodesOpened, nodesClosed);
        }
    }

    @Override
    public void loadMoreTreeNodes(String clientId, AssetNodeIdentifier parentNode) {
        TreeClientHandling handling = this.treeClients.get(clientId);
        if (handling != null) {
            handling.loadMoreNodes(parentNode);
        }
    }

    @Override
    public void treeSettingsChanged(String clientId, ClientTreeSettings newSettings) {
        StructureClientHandling structureClientHandling;
        TreeClientHandling handling = this.treeClients.get(clientId);
        if (handling != null) {
            handling.settingsChanged(newSettings);
        }
        if ((structureClientHandling = this.structureClients.get(clientId)) != null) {
            structureClientHandling.settingsChanged();
        }
    }

    @Override
    public void registerStructureClient(String clientId, AssetNodeIdentifier parentNode, StructureViewSettings settings, Integer initialOpenedNodes, AssetStructureListener listener) {
        StructureClientHandling structureClientHandling = this.structureClients.get(clientId);
        Integer initialOpenedNodesX = structureClientHandling != null && !structureClientHandling.getStructureRoot().equals(parentNode) ? null : initialOpenedNodes;
        this.unregisterStructureClient(clientId);
        TreeClientHandling treeClientHandling = this.treeClients.get(clientId);
        if (treeClientHandling == null) {
            this.preHoldStructureClients.put(clientId, inst -> {
                this.preHoldStructureClients.remove(clientId);
                this.structureClients.put(clientId, new StructureClientHandling(parentNode, settings, clientId, initialOpenedNodesX, (TreeClientHandling)inst, listener, this));
            });
        } else {
            this.preHoldStructureClients.remove(clientId);
            this.structureClients.put(clientId, new StructureClientHandling(parentNode, settings, clientId, initialOpenedNodesX, treeClientHandling, listener, this));
        }
    }

    @Override
    public void unregisterStructureClient(String clientId) {
        this.preHoldStructureClients.remove(clientId);
        StructureClientHandling remove = this.structureClients.remove(clientId);
        if (remove != null) {
            remove.stop();
        }
    }

    @Override
    public void structureSettingsChanged(String clientId, StructureViewSettings newSettings) {
        StructureClientHandling structureClientHandling = this.structureClients.get(clientId);
        if (structureClientHandling != null) {
            structureClientHandling.settingsChanged(newSettings);
        }
    }

    @Override
    public void loadMoreStructureNodes(String clientId) {
        StructureClientHandling structureClientHandling = this.structureClients.get(clientId);
        if (structureClientHandling != null) {
            structureClientHandling.loadMoreNodes();
        }
    }

    @Override
    public void assetChanged(@Nullable AssetView oldState, @Nullable AssetView newState) {
        this.dispatcher.dispatchEvent(() -> {
            GUID id = oldState != null ? oldState.getId() : newState.getId();
            for (TreeClientHandling treeClientHandling : this.treeClients.values()) {
                treeClientHandling.assetChanged(id);
            }
            for (StructureClientHandling structureClientHandling : this.structureClients.values()) {
                structureClientHandling.assetChanged(id);
            }
            for (AssetClientHandling assetClientHandling : this.assetClients.values()) {
                assetClientHandling.assetChanged(id, newState);
            }
        });
    }

    @Override
    public void registerAssetClient(String clientId, GUID assetID, boolean syncWithTree, AssetClientListener listener) {
        this.unregisterAssetClient(clientId);
        TreeClientHandling treeClientHandling = this.treeClients.get(clientId);
        if (treeClientHandling == null && syncWithTree) {
            this.preHoldAssetClients.put(clientId, inst -> {
                this.preHoldAssetClients.remove(clientId);
                this.assetClients.put(clientId, new AssetClientHandling(assetID, listener, clientId, this.manager, (TreeClientHandling)inst));
            });
        } else {
            this.preHoldAssetClients.remove(clientId);
            this.assetClients.put(clientId, new AssetClientHandling(assetID, listener, clientId, this.manager, treeClientHandling));
        }
    }

    @Override
    public void unregisterAssetClient(String clientId) {
        this.preHoldAssetClients.remove(clientId);
        this.assetClients.remove(clientId);
    }

    public TreeNodeInfo getNodeInfo(AssetNodeIdentifier key, NodeWithParent node) {
        AssetNodeIdentifier parentId = node.getParent();
        if (key.isRoot()) {
            return new TreeNodeInfo(key, "", null, null, true, false, false, false, node.getNode().getNumOfMoreNodes(), parentId);
        }
        if (key.isDevice()) {
            AssetView device = AssetManager.getInstance().getAsset(key.getDeviceId());
            if (device != null) {
                Boolean hasChildNodes = node.getNode().getHasChildren();
                if (hasChildNodes == null) {
                    throw new IllegalStateException("HasChildren cannot be null for " + String.valueOf(key));
                }
                return new TreeNodeInfo(key, device.getName(), new AssetFieldValue(AssetFields.FIELD_TYPE.getKey(), String.valueOf(device.getValue(AssetFields.FIELD_TYPE))), AssetFields.FIELD_TYPE.getKey(), hasChildNodes, true, device.isArchived(), node.getNode().isSearchDummy(), node.getNode().getNumOfMoreNodes(), parentId);
            }
            return null;
        }
        AssetField field = AssetFields.getFieldFor(key.getLastFieldKey());
        if (field != null && field instanceof AssetFieldWithDefinition) {
            Object fieldValue = key.getLastFieldValue();
            String strValue = fieldValue;
            if (fieldValue != null) {
                Object value = ((AssetFieldWithDefinition)field).valueOf((String)fieldValue);
                fieldValue = ((AssetFieldWithDefinition)field).getDisplayValue(value);
            }
            AssetFieldValue iconField = null;
            URL icon = ((AssetFieldWithDefinition)field).getIcon(strValue, 16);
            if (icon != null) {
                iconField = new AssetFieldValue(field.getKey(), strValue);
            }
            if (StringFunctions.isEmpty((String)fieldValue)) {
                fieldValue = "<" + AssetManagerImpl.MSG.getMsg("device.field.noValue", new Object[]{field.getLabel()}) + ">";
            }
            return new TreeNodeInfo(key, (String)fieldValue, iconField, field.getKey(), true, false, false, false, node.getNode().getNumOfMoreNodes(), parentId);
        }
        return null;
    }

    @Override
    public TreeNode searchAssets(ClientTreeSettings settings, int numberOfNodes) {
        return this.searchAssets(settings, AssetNodeIdentifier.ROOT, 20, numberOfNodes);
    }

    @Override
    public TreeNode searchAssets(ClientTreeSettings settings, AssetNodeIdentifier rootNodeId, int depth, int numberOfNodes) {
        TreeClientHandling treeClientHandling = new TreeClientHandling(settings, this.manager, this);
        InternalTreeNode tree = new InternalTreeNode(rootNodeId);
        tree.openNode();
        treeClientHandling.main_addChildrenInExistingNode(tree, new StructureInfo(depth, StructureInfo.TYPE.Tree, numberOfNodes, settings, null), false, (Map<AssetNodeIdentifier, Integer>)new HashMap<AssetNodeIdentifier, Integer>(){

            @Override
            public boolean containsKey(Object key) {
                return true;
            }
        });
        return tree.toExternalNode(this, null);
    }
}

