/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts;

import com.inet.field.fieldtypes.FieldType;
import com.inet.field.fieldtypes.FieldTypeDate;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithConfigurableDefault;
import com.inet.helpdesk.plugins.inventory.server.internal.search.ValueAndDisplayValue;
import com.inet.search.command.SearchCondition;
import java.util.Comparator;
import javax.annotation.Nonnull;

public class AssetField_DateTime
extends AssetFieldWithConfigurableDefault<Long> {
    private boolean isDateWithTime;

    public AssetField_DateTime(String key, Long defaultValue, int sortPrio, boolean isDateWithTime) {
        super(key, defaultValue, sortPrio, isDateWithTime ? FieldSettingsType.TYPE_DATE_TIME : FieldSettingsType.TYPE_DATE, FieldTypeFactory.custom());
        this.isDateWithTime = isDateWithTime;
    }

    @Nonnull
    public FieldType<Long> createFieldType() {
        return new FieldTypeDate(this.getKey(), () -> this.getLabel(), this.isDateWithTime);
    }

    @Override
    public Long valueOf(String value) {
        return ((FieldTypeDate)this.getFieldType()).valueOf(value);
    }

    @Override
    public SearchCondition createCondition(String stringRepresentation) {
        Long left = this.valueOf(stringRepresentation);
        if (left == null) {
            return super.createCondition(stringRepresentation);
        }
        Long right = left + 86400000L - 1L;
        return new SearchCondition(this.getEntrySearchKey(), SearchCondition.SearchTermOperator.BETWEEN, (Object)new Object[]{left, right});
    }

    @Override
    @Nonnull
    public Comparator<ValueAndDisplayValue<Long>> getComparator() {
        Comparator comp = (a, b) -> Long.compare(a, b);
        Comparator nullsFirst = Comparator.nullsFirst(comp);
        return (a, b) -> nullsFirst.compare((Long)a.getValue(), (Long)b.getValue());
    }
}

