/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.api.model.field;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.field.SelectOption;
import com.inet.field.fieldtypes.FieldType;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.fieldsettings.api.model.GenericFieldSetting;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.MutableAssetData;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithFieldGroup;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithIcon;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.FieldEditInformation;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.image.UserAvatar;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.FieldValidationException;
import com.inet.usersandgroups.api.takeout.TakeoutDataRenderer;
import com.inet.usersandgroups.api.ui.fields.FieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.UserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.values.FieldValue;
import com.inet.usersandgroups.api.ui.fields.values.HyperlinkFieldValue;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AssetFieldUser
extends AssetFieldWithDefinition<GUID>
implements AssetFieldWithFieldGroup,
AssetFieldWithIcon<GUID> {
    public static final FieldSettingsType TYPE_USER = new FieldSettingsType("User", String.class, null){

        public void validateStringInput(String arg0) throws IllegalArgumentException {
        }

        public String getLabel() {
            return AssetManager.MSG.getMsg("device.field.owner.type", new Object[0]);
        }

        public FieldType<?> toFieldType(GenericFieldSetting setting, Supplier<String> displayname) {
            throw new UnsupportedOperationException();
        }
    };

    public AssetFieldUser(String key, int sortPrio) {
        super(key, null, sortPrio, TYPE_USER, FieldTypeFactory.auto().withShowInTextSearch(false));
    }

    @Override
    public void validateRealValue(GUID id) throws FieldValidationException {
        if (id != null && UserManager.getInstance().getUserAccount(id) == null) {
            throw new FieldValidationException(AssetManager.MSG.getMsg("manager.error.objectDoesNotExist", new Object[]{id}));
        }
    }

    @Override
    public GUID valueOf(String stringRepresentation) {
        if (stringRepresentation == null || stringRepresentation.isEmpty()) {
            return null;
        }
        return GUID.valueOf((String)stringRepresentation);
    }

    @Override
    public String getDisplayValue(GUID value) {
        UserAccount userAccount = UserManager.getRecoveryEnabledInstance().getUserAccount(value);
        if (userAccount != null) {
            return userAccount.getDisplayName();
        }
        return null;
    }

    @Override
    public URL getIcon(String value, int size) {
        if (value != null) {
            byte[] circleAvatar = UserAvatar.getCircleAvatar((GUID)this.valueOf(value), (int)(size * 2));
            try {
                return new URL("data:image/png;base64," + Base64.getEncoder().encodeToString(circleAvatar));
            }
            catch (MalformedURLException e) {
                InventoryServerPlugin.LOGGER.debug((Object)e);
            }
        }
        return super.getIcon(value, size);
    }

    @Override
    public FieldEditInformation<GUID> getEditInformation() {
        return new FieldEditInformation<GUID>((AssetFieldWithDefinition)this){

            @Override
            public boolean isEnabled() {
                return SystemPermissionChecker.checkAccess((Permission)InventoryServerPlugin.INVENTORY_ALL) && SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER);
            }

            @Override
            @Nullable
            public String serializeValue(@Nullable AssetView device) {
                UserAccount userAccount;
                GUID userId;
                GUID gUID = userId = device == null ? null : device.getValue(AssetFieldUser.this);
                if (userId != null && (userAccount = UserManager.getInstance().getUserAccount(userId)) != null) {
                    return new Json().toJson((Object)new SelectOption(userId.toString(), userAccount.getDisplayName(), userId.toString()));
                }
                return new Json().toJson((Object)new SelectOption("", ""));
            }

            @Override
            public void updateAssetData(@Nonnull MutableAssetData deviceData, @Nullable String value) {
                if (!StringFunctions.isEmpty((String)value)) {
                    Objects.requireNonNull(value);
                    SelectOption selectOption = (SelectOption)new Json().fromJson(value, SelectOption.class);
                    if (selectOption != null) {
                        deviceData.put(this.field, (GUID)this.field.valueOf(selectOption.getValue()));
                    }
                }
            }
        };
    }

    @Override
    @Nullable
    public LocalizedKey getFieldGroup() {
        return new LocalizedKey(this.getFieldKey(), this.getLabel());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public List<AssetFieldWithFieldGroup.AdditionalDetailField> getAdditionalFields(String serializedValue) {
        MutableAssetData data = new MutableAssetData();
        this.getEditInformation().updateAssetData(data, serializedValue);
        GUID guid = data.get(this);
        if (guid == null) {
            return null;
        }
        UserAccount userAccount = UserManager.getInstance().getUserAccount(guid);
        if (userAccount == null) {
            return null;
        }
        ArrayList<AssetFieldWithFieldGroup.AdditionalDetailField> fields = new ArrayList<AssetFieldWithFieldGroup.AdditionalDetailField>();
        DynamicExtensionManager dem = DynamicExtensionManager.getInstance();
        AtomicInteger priorityCounter = new AtomicInteger(0);
        @Nonnull List fieldDefinitions = dem.get(FieldDefinition.class);
        fieldDefinitions.stream().filter(d -> d instanceof UserFieldDefinition && "user.masterdata".equals(d.getGroupKey()) && d.getFieldKey() != null).sorted((a, b) -> Integer.compare(a.getPriority(), b.getPriority())).forEach(d -> {
            String href;
            UserFieldDefinition ufd = (UserFieldDefinition)d;
            if (!ufd.isAvailable(userAccount)) {
                return;
            }
            FieldValue fieldValue = ufd.getFieldValue(userAccount);
            String value = AssetFieldUser.getStringRendererForFieldValue(ufd.getDisplayType(), fieldValue);
            if (fieldValue instanceof HyperlinkFieldValue && !StringFunctions.isEmpty((String)(href = ((HyperlinkFieldValue)fieldValue).getHref()))) {
                fields.add(new AssetFieldWithFieldGroup.AdditionalDetailField(d.getFieldKey(), priorityCounter.incrementAndGet(), d.getLabel(), value, href));
                return;
            }
            fields.add(new AssetFieldWithFieldGroup.AdditionalDetailField(d.getFieldKey(), priorityCounter.incrementAndGet(), "fieldtype_multiline".equals(d.getDisplayType()), d.getLabel(), value));
        });
        return fields;
    }

    private static String getStringRendererForFieldValue(String type, FieldValue value) {
        TakeoutDataRenderer renderer = null;
        try {
            renderer = (TakeoutDataRenderer)ServerPluginManager.getInstance().getSingleInstanceByName(TakeoutDataRenderer.class, type, true);
        }
        catch (IllegalStateException e) {
            InventoryServerPlugin.LOGGER.error((Throwable)e);
            return "";
        }
        return renderer.render(value);
    }

    @Override
    public GUID getValueFromIndexedValue(@Nullable Object indexedValue) {
        if (indexedValue == null) {
            return null;
        }
        return GUID.valueOf((String)((String)indexedValue));
    }
}

