/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.api.model;

import com.inet.cache.MemorySize;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField;
import com.inet.http.servlet.ClientLocale;
import com.inet.usersandgroups.api.FieldValidationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MutableAssetData
implements MemorySize {
    private Map<AssetField<Object>, Object> map = new HashMap<AssetField<Object>, Object>();

    public static <VALUE> MutableAssetData ofSingle(AssetField<VALUE> field, VALUE value) {
        MutableAssetData d = new MutableAssetData();
        d.put(field, value);
        return d;
    }

    public <VALUE> void put(AssetField<VALUE> field, VALUE value) {
        if (field.getValueType().isAssignableFrom(String.class) && "".equals(value)) {
            value = null;
        }
        try {
            field.validate(value);
        }
        catch (FieldValidationException ex) {
            throw new FieldValidationException(field.getLabel(ClientLocale.getThreadLocale()) + ": " + ex.getMessage(), (Throwable)ex);
        }
        this.map.put(field, value);
    }

    public <VALUE> void putValidOrDefaultValue(AssetField<VALUE> field, VALUE value) {
        value = field.getValidOrDefaultValue(value, null);
        this.put(field, value);
    }

    public <VALUE> VALUE get(AssetField<VALUE> field) {
        return (VALUE)this.map.get(field);
    }

    public <VALUE> VALUE getOrDefault(AssetField<VALUE> field) {
        return (VALUE)this.map.getOrDefault(field, field.getDefaultValue());
    }

    public void remove(AssetField<?> field) {
        this.map.remove(field);
    }

    public boolean containsKey(AssetField<?> field) {
        return this.map.containsKey(field);
    }

    public boolean hasValue(AssetField<?> field) {
        return this.map.get(field) != null;
    }

    public Set<AssetField<Object>> getIncludedFields() {
        return new HashSet<AssetField<Object>>(this.map.keySet());
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public MutableAssetData copy() {
        MutableAssetData copy = new MutableAssetData();
        for (Map.Entry<AssetField<Object>, Object> entry : this.map.entrySet()) {
            AssetField<Object> field = entry.getKey();
            copy.map.put(field, field.copyValue(entry.getValue()));
        }
        return copy;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MutableAssetData other = (MutableAssetData)obj;
        return !(this.map == null ? other.map != null : !this.map.equals(other.map));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AssetData:[");
        sb.append(this.map.toString()).append("]");
        return sb.toString();
    }

    public void putAll(MutableAssetData deviceData) {
        this.map.putAll(deviceData.map);
    }

    public long getSizeInMemory() {
        return 16L + MemorySize.getSizeOfMap(this.map);
    }
}

