/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.client.ticketpageextension;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.WithAdditionalReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.plugins.inventory.client.handler.AbstractInventoryHandler;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.helpdesk.plugins.inventory.server.ticket.AffectedAssets;
import com.inet.helpdesk.plugins.inventory.server.ticket.ChangeAffectedAssetsExtension;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class UpdateAffectedAssets
extends AbstractInventoryHandler<UpdateAffectedAssetsRequest, Void> {
    public String getMethodName() {
        return "inventory.update.affected.assets";
    }

    @Override
    public Void handle(HttpServletRequest req, HttpServletResponse resp, UpdateAffectedAssetsRequest payload) throws IOException {
        Integer ticketId = payload.getTicketId();
        GUID removeId = payload.getRemoveId();
        GUID insertId = payload.getInsertId();
        if (ticketId == null) {
            return null;
        }
        if (!TicketManager.getTicketPermissionChecker().checkCurrentUserCanWriteTicket(ticketId.intValue())) {
            throw new ClientMessageException(InventoryServerPlugin.CLIENT_MSG.getMsg("inventory.integration.ticketlist.writepermission.failed", new Object[]{ticketId}));
        }
        TicketVO ticket = TicketManager.getReader().getTicket(ticketId.intValue());
        if (ticket == null) {
            throw new ClientMessageException(InventoryServerPlugin.CLIENT_MSG.getMsg("inventory.integration.ticketlist.writepermission.failed", new Object[]{ticketId}));
        }
        ArrayList<GUID> affectedAssets = (ArrayList<GUID>)ticket.getValue((TicketField)AssetFields.TICKET_FIELD_AFFECTED_ASSETS);
        if (affectedAssets == null) {
            affectedAssets = new ArrayList<GUID>();
        }
        if (removeId != null) {
            affectedAssets.remove(removeId);
        }
        if (insertId != null && !affectedAssets.contains(insertId)) {
            affectedAssets.add(insertId);
        }
        if (affectedAssets.isEmpty()) {
            affectedAssets = null;
        }
        AffectedAssets affectedAssetsToSave = null;
        if (affectedAssets != null) {
            affectedAssetsToSave = new AffectedAssets((Collection<? extends GUID>)affectedAssets);
        }
        MutableReaStepData reaStepData = new MutableReaStepData();
        ExtensionArguments extArgs = ExtensionArguments.ofSingleArg(ChangeAffectedAssetsExtension.EXTARG_AFFECTED_ASSETS, (Object)affectedAssetsToSave);
        try (WithAdditionalReaStepData addReaStepData = WithAdditionalReaStepData.create((ReaStepField)AssetFields.FIELD_INVENTORY_ASSETID, (Object)(removeId != null ? removeId : insertId));){
            TicketManager.getManipulator().applyAction(ticketId.intValue(), reaStepData, ReaStepTextVO.empty(), (ActionVO)ActionManager.getInstance().get(-39), extArgs);
        }
        return null;
    }

    @JsonData
    public static class UpdateAffectedAssetsRequest {
        private Integer ticketId;
        private GUID insertId;
        private GUID removeId;

        private UpdateAffectedAssetsRequest() {
        }

        public GUID getInsertId() {
            return this.insertId;
        }

        public GUID getRemoveId() {
            return this.removeId;
        }

        public Integer getTicketId() {
            return this.ticketId;
        }
    }
}

