/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.webapi.asset;

import com.inet.helpdesk.plugins.attachments.server.model.AttachmentRow;
import com.inet.helpdesk.plugins.inventory.client.InventoryAttachments;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.helpdesk.plugins.inventory.server.webapi.InventoryWebAPIExtension;
import com.inet.helpdesk.plugins.inventory.server.webapi.data.InventoryAssetAttachmentDescription;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.webapi.api.PathTokenizer;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;

@Tag(name="Inventory", description="Operations for managing inventory assets")
public class InventoryAssetAttachmentsHandler
extends RequestHandler.WithParentPathToken<Void, List<InventoryAssetAttachmentDescription>, GUID> {
    public InventoryAssetAttachmentsHandler() {
        super(new String[]{"attachments"});
    }

    public String getHelpPageKey() {
        return "webapi.inventory.asset.attachments";
    }

    @Operation(summary="Get or delete asset attachments", description="Retrieves the list of attachments for an asset. When using DELETE method, removes a specific attachment.", responses={@ApiResponse(responseCode="200", description="Attachments retrieved or deleted successfully", content={@Content(array=@ArraySchema(schema=@Schema(implementation=InventoryAssetAttachmentDescription.class)))}), @ApiResponse(responseCode="400", description="Invalid asset ID or asset not found"), @ApiResponse(responseCode="401", description="User not authorized"), @ApiResponse(responseCode="403", description="User does not have write permissions for deletion")})
    public List<InventoryAssetAttachmentDescription> handle(HttpServletRequest request, HttpServletResponse response, @Nullable Void inputObject, @Parameter(description="GUID of the asset to manage attachments for") @Nullable GUID assetId, List<String> pathTokens, boolean previewModeEnabled) throws IOException {
        if (assetId == null) {
            throw new ClientMessageException(InventoryWebAPIExtension.MSG.getMsg("asset.id.notGiven", new Object[0]));
        }
        AssetView asset = AssetManager.getInstance().getAsset(assetId);
        if (asset == null) {
            throw new ClientMessageException(InventoryWebAPIExtension.MSG.getMsg("asset.id.notFound", new Object[0]));
        }
        List tokens = PathTokenizer.originalTokensFor((String)request.getPathInfo(), pathTokens);
        if (tokens.size() >= 0 && "DELETE".equals(request.getMethod())) {
            if (!SystemPermissionChecker.checkAccess((Permission)InventoryServerPlugin.INVENTORY_READ_WRITE)) {
                throw new AccessDeniedException(InventoryServerPlugin.INVENTORY_READ_WRITE);
            }
            if (!previewModeEnabled) {
                InventoryAttachments.deleteAttachment(asset.getIntID(), (String)tokens.get(0));
            }
        }
        return InventoryAttachments.getAttachments(asset.getId(), e -> new InventoryAssetAttachmentDescription((AttachmentRow)e));
    }
}

