/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.internal;

import com.inet.cache.MemoryStoreMap;
import com.inet.helpdesk.plugins.inventory.server.api.AssetListener;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AbstractAsset;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetVO;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.HistoryStep;
import com.inet.helpdesk.plugins.inventory.server.api.model.MutableAssetData;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.search.SearchTagArchived;
import com.inet.helpdesk.plugins.inventory.server.eventlog.AssetEventLog;
import com.inet.helpdesk.plugins.inventory.server.internal.AssetDAO;
import com.inet.helpdesk.plugins.inventory.server.internal.AssetViewImpl;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.id.GUID;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.search.AbstractSearchDataCache;
import com.inet.search.SearchDataCacheChangeListener;
import com.inet.thread.ServerLock;
import com.inet.thread.ThreadUtils;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AssetDataCache
extends AbstractSearchDataCache<GUID> {
    private static final int HISTORY_STEP_MAX_LENGTH = 300;
    private MemoryStoreMap<GUID, AssetView> cache = new MemoryStoreMap(300, true);
    private MemoryStoreMap<GUID, List<HistoryStep>> historyCache = new MemoryStoreMap(300, true);
    private AssetDAO dao;
    private boolean isIndexing = false;

    public AssetDataCache(AssetDAO dao) {
        this.dao = dao;
    }

    public Map<String, Object> getCacheEntry(@Nonnull GUID cacheId) {
        return this.map(this.get(cacheId));
    }

    public Iterator<GUID> iterator() {
        this.isIndexing = true;
        this.cache.setTimeout(5, true);
        return new Iterator<GUID>(){
            private final Iterator<GUID> it;
            {
                this.it = AssetDataCache.this.dao.getAssetIdIterator();
            }

            @Override
            public boolean hasNext() {
                boolean hasNext = this.it.hasNext();
                if (!hasNext) {
                    AssetDataCache.this.isIndexing = false;
                    AssetDataCache.this.cache.setTimeout(300, true);
                }
                return hasNext;
            }

            @Override
            public GUID next() {
                return this.it.next();
            }

            protected void finalize() throws Throwable {
                super.finalize();
                if (AssetDataCache.this.isIndexing) {
                    AssetDataCache.this.isIndexing = false;
                    AssetDataCache.this.cache.setTimeout(300, true);
                }
            }
        };
    }

    @Nullable
    public AssetView get(GUID id) {
        AssetView deviceVO = (AssetView)this.cache.get((Object)id);
        if (deviceVO == null) {
            try (ThreadUtils.Semaphore s = ThreadUtils.getSemaphore((Object)("device" + String.valueOf(id)));
                 ServerLock lock = ThreadUtils.getLock((Object)s);){
                deviceVO = AssetViewImpl.create(this.dao.get(id));
                if (deviceVO != null) {
                    this.cache.put((Object)id, (Object)deviceVO);
                }
            }
        }
        return deviceVO;
    }

    public AssetView create(GUID id, int idInt, MutableAssetData data, List<AssetManager.AdditionalTask> extensionTasks) {
        SearchDataCacheChangeListener[] listeners;
        long time = System.currentTimeMillis();
        GUID user = this.getCurrentUser();
        AssetView oldParent = null;
        if (data.get(AssetFields.FIELD_PARENT) != null) {
            oldParent = this.get(data.get(AssetFields.FIELD_PARENT));
        }
        AssetVO newDevice = this.dao.create(idInt, id, data);
        AssetView newView = AssetViewImpl.create(newDevice);
        this.cache.put((Object)id, (Object)newView);
        HashSet<Runnable> eventActions = new HashSet<Runnable>();
        if (oldParent != null) {
            try (ThreadUtils.Semaphore s = ThreadUtils.getSemaphore((Object)("device" + String.valueOf(oldParent.getId())));
                 ServerLock lock = ThreadUtils.getLock((Object)s);){
                eventActions.add(this.handleNewChildDevice(time, user, newDevice, oldParent));
            }
        }
        HistoryStep step = new HistoryStep(newDevice.getIntID(), time, user, AssetManager.MSG.getMsg("manager.history.create", new Object[0]));
        this.dao.addHistoryStep(step);
        extensionTasks.forEach(t -> t.accept(newView, extraStep -> this.dao.addHistoryStep((HistoryStep)extraStep)));
        for (SearchDataCacheChangeListener searchDataCacheChangeListener : listeners = this.getListeners()) {
            searchDataCacheChangeListener.entryAdded((Object)id, this.map(newView));
        }
        this.sendDeviceEvent(null, newView);
        eventActions.forEach(Runnable::run);
        return newView;
    }

    private Map<String, Object> map(AssetView view) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        DynamicExtensionManager.getInstance().get(AssetField.class).forEach(f -> {
            Object value = view.getValue(f);
            if (f instanceof AssetFieldDefinition && !((AssetFieldDefinition)((Object)f)).isVisibleInType(view.getType())) {
                value = null;
            }
            map.put(f.getKey(), value);
            if (f.hasEntrySearchTag()) {
                map.put(f.getEntrySearchKey(), value);
            }
        });
        map.put("deviceid", view.getId().toString());
        map.put("children", view.getChildAssetIDs());
        map.put("archived", SearchTagArchived.valueAsInt(view.isArchived()));
        return map;
    }

    public void update(GUID id, MutableAssetData data, List<AssetManager.AdditionalTask> extensionTasks) {
        long time = System.currentTimeMillis();
        GUID user = this.getCurrentUser();
        AssetView oldValue = this.get(id);
        if (oldValue == null) {
            throw new IllegalArgumentException("No device exists with id " + String.valueOf(id));
        }
        ArrayList<AssetField<Object>> affectedFields = new ArrayList<AssetField<Object>>();
        ArrayList<AssetView> affectedChilds = new ArrayList<AssetView>();
        if (this.wasInheritedFieldChanged(data)) {
            this.getAllChildrenAsView(oldValue, affectedChilds);
        }
        boolean parentWasChanged = data.containsKey(AssetFields.FIELD_PARENT) && !Objects.equals(oldValue.getParentID(), data.get(AssetFields.FIELD_PARENT));
        ArrayList<ThreadUtils.Semaphore> locks = new ArrayList<ThreadUtils.Semaphore>();
        locks.add(ThreadUtils.getSemaphore((Object)("device" + String.valueOf(id))));
        if (parentWasChanged) {
            if (oldValue.getParentID() != null) {
                locks.add(ThreadUtils.getSemaphore((Object)("device" + String.valueOf(oldValue.getParentID()))));
            }
            if (data.get(AssetFields.FIELD_PARENT) != null) {
                locks.add(ThreadUtils.getSemaphore((Object)("device" + String.valueOf(data.get(AssetFields.FIELD_PARENT)))));
            }
        }
        for (AssetView affectedChild : affectedChilds) {
            locks.add(ThreadUtils.getSemaphore((Object)("device" + String.valueOf(affectedChild.getId()))));
        }
        try (ServerLock s = ThreadUtils.getMultipleLocks(locks);){
            AssetView oldParentBeforeChange = null;
            AssetView newParentBeforeChange = null;
            if (parentWasChanged) {
                if (oldValue.getParentID() != null) {
                    oldParentBeforeChange = this.get(oldValue.getParentID());
                }
                if (data.get(AssetFields.FIELD_PARENT) != null) {
                    newParentBeforeChange = this.get(data.get(AssetFields.FIELD_PARENT));
                }
            }
            AssetVO newDevice = this.dao.update(id, oldValue.getIntID(), data);
            AssetView newView = AssetViewImpl.create(newDevice);
            this.cache.put((Object)id, (Object)newView);
            HashSet<Runnable> eventActions = new HashSet<Runnable>();
            if (parentWasChanged) {
                if (oldParentBeforeChange != null) {
                    SearchDataCacheChangeListener[] listeners;
                    this.cache.remove((Object)oldParentBeforeChange.getId());
                    this.dao.addHistoryStep(new HistoryStep(oldParentBeforeChange.getIntID(), time, user, AssetManager.MSG.getMsg("manager.history.removeChild", new Object[]{newDevice.getName()})));
                    this.historyCache.remove((Object)oldParentBeforeChange.getId());
                    AssetView oldParentBeforeChangeX = oldParentBeforeChange;
                    AssetView oldParentAfterChange = this.get(oldParentBeforeChangeX.getId());
                    for (SearchDataCacheChangeListener searchDataCacheChangeListener : listeners = this.getListeners()) {
                        searchDataCacheChangeListener.entryChanged((Object)oldParentBeforeChange.getId(), this.map(oldParentBeforeChange), this.map(oldParentAfterChange));
                    }
                    eventActions.add(() -> this.sendDeviceEvent(oldParentBeforeChangeX, oldParentAfterChange));
                }
                if (newParentBeforeChange != null) {
                    eventActions.add(this.handleNewChildDevice(time, user, newDevice, newParentBeforeChange));
                }
            }
            for (AssetField<Object> field : data.getIncludedFields()) {
                if (Objects.equals(oldValue.getValue(field), data.get(field))) continue;
                affectedFields.add(field);
                String changeStepText = field.createFieldChangeStepText(oldValue.getValue(field), data.get(field));
                if (changeStepText == null) continue;
                HistoryStep step = new HistoryStep(newDevice.getIntID(), time, user, this.historyMaxLength(changeStepText));
                this.dao.addHistoryStep(step);
            }
            extensionTasks.forEach(t -> t.accept(newView, step -> this.dao.addHistoryStep((HistoryStep)step)));
            this.historyCache.remove((Object)id);
            if (this.wasInheritedFieldChanged(data)) {
                eventActions.addAll(this.notifyChildAssetsThatInheritedFieldsWereChanged(affectedChilds));
            }
            this.sendChangedEvendAndNotifyIndex(oldValue, newView);
            eventActions.forEach(Runnable::run);
        }
        AssetEventLog.AssetChanged.log(oldValue, affectedFields);
    }

    private GUID getCurrentUser() {
        GUID user = UserManager.getInstance().getCurrentUserAccountID();
        if (UserManager.PRIVILEGED_ACCOUNT_ID.equals((Object)user)) {
            user = null;
        }
        return user;
    }

    private Runnable handleNewChildDevice(long time, GUID user, AbstractAsset newDevice, AssetView oldNewParent) {
        SearchDataCacheChangeListener[] listeners;
        this.mustOwnMonitorOf(newDevice.getParentID());
        this.cache.remove((Object)newDevice.getParentID());
        AssetView newParentVO = this.get(newDevice.getParentID());
        this.dao.addHistoryStep(new HistoryStep(oldNewParent.getIntID(), time, user, AssetManager.MSG.getMsg("manager.history.addChild", new Object[]{newDevice.getName()})));
        this.historyCache.remove((Object)oldNewParent.getId());
        for (SearchDataCacheChangeListener searchDataCacheChangeListener : listeners = this.getListeners()) {
            searchDataCacheChangeListener.entryChanged((Object)oldNewParent.getId(), this.map(oldNewParent), this.map(newParentVO));
        }
        return () -> this.sendDeviceEvent(oldNewParent, newParentVO);
    }

    private String historyMaxLength(String text) {
        if (text.length() > 300) {
            return text.substring(0, 297) + "...";
        }
        return text;
    }

    private void getAllChildrenAsView(AssetView asset, List<AssetView> list) {
        List<AssetVO> assets = this.dao.getAssets(asset.getChildAssetIDs());
        assets.forEach(a -> {
            AssetView view = AssetViewImpl.create(a);
            list.add(view);
            this.getAllChildrenAsView(view, list);
        });
    }

    private boolean wasInheritedFieldChanged(MutableAssetData data) {
        boolean wasChange = false;
        for (AssetField<?> f : AssetView.INHERITED_FIELDS) {
            if (!data.containsKey(f)) continue;
            wasChange = true;
            break;
        }
        if (!wasChange) {
            wasChange = data.containsKey(AssetFields.FIELD_PARENT);
        }
        return wasChange;
    }

    private Collection<Runnable> notifyChildAssetsThatInheritedFieldsWereChanged(List<AssetView> affectedChildViews) {
        ArrayList<Runnable> events = new ArrayList<Runnable>();
        for (AssetView oldVO : affectedChildViews) {
            SearchDataCacheChangeListener[] listeners;
            this.cache.remove((Object)oldVO.getId());
            AssetView assetVO = this.get(oldVO.getId());
            if (assetVO == null || oldVO.equals(assetVO)) continue;
            for (SearchDataCacheChangeListener searchDataCacheChangeListener : listeners = this.getListeners()) {
                searchDataCacheChangeListener.entryChanged((Object)oldVO.getId(), this.map(oldVO), this.map(assetVO));
            }
            events.add(() -> this.sendDeviceEvent(oldVO, assetVO));
        }
        return events;
    }

    public void archive(GUID id) {
        try (ThreadUtils.Semaphore s = ThreadUtils.getSemaphore((Object)("device" + String.valueOf(id)));
             ServerLock lock = ThreadUtils.getLock((Object)s);){
            AssetView oldValue = this.get(id);
            if (oldValue == null) {
                throw new IllegalArgumentException("No device exists with id " + String.valueOf(id));
            }
            AssetVO newDevice = this.dao.archive(id);
            AssetView newView = AssetViewImpl.create(newDevice);
            this.cache.put((Object)id, (Object)newView);
            long time = System.currentTimeMillis();
            GUID user = UserManager.getInstance().getCurrentUserAccountID();
            if (UserManager.PRIVILEGED_ACCOUNT_ID.equals((Object)user)) {
                user = null;
            }
            HistoryStep step = new HistoryStep(newDevice.getIntID(), time, user, AssetManager.MSG.getMsg("manager.history.archive", new Object[0]));
            this.dao.addHistoryStep(step);
            this.historyCache.remove((Object)id);
            this.sendChangedEvendAndNotifyIndex(oldValue, newView);
        }
    }

    private void sendDeviceEvent(@Nullable AssetView oldValue, @Nullable AssetView newDevice) {
        for (AssetListener l : DynamicExtensionManager.getInstance().get(AssetListener.class)) {
            try {
                l.assetChanged(oldValue, newDevice);
            }
            catch (Throwable th) {
                InventoryServerPlugin.LOGGER.error(th);
            }
        }
    }

    public void delete(GUID id) {
        try (ThreadUtils.Semaphore s = ThreadUtils.getSemaphore((Object)("device" + String.valueOf(id)));
             ServerLock lock = ThreadUtils.getLock((Object)s);){
            SearchDataCacheChangeListener[] listeners;
            AssetView oldValue = this.get(id);
            if (oldValue == null) {
                return;
            }
            AssetView oldParent = null;
            if (oldValue.getParentID() != null) {
                oldParent = this.get(oldValue.getParentID());
            }
            this.dao.delete(id, oldValue.getIntID());
            this.cache.remove((Object)id);
            this.historyCache.remove((Object)id);
            if (oldParent != null) {
                try (ThreadUtils.Semaphore sOld = ThreadUtils.getSemaphore((Object)("device" + String.valueOf(oldValue.getParentID())));
                     ServerLock lockOld = ThreadUtils.getLock((Object)sOld);){
                    SearchDataCacheChangeListener[] listeners2;
                    this.cache.remove((Object)oldValue.getParentID());
                    AssetView newParent = this.get(oldParent.getId());
                    for (SearchDataCacheChangeListener searchDataCacheChangeListener : listeners2 = this.getListeners()) {
                        searchDataCacheChangeListener.entryChanged((Object)oldParent.getId(), this.map(oldParent), this.map(newParent));
                    }
                    this.sendDeviceEvent(oldParent, newParent);
                }
            }
            for (SearchDataCacheChangeListener searchDataCacheChangeListener : listeners = this.getListeners()) {
                searchDataCacheChangeListener.entryRemoved((Object)id, this.map(oldValue));
            }
            this.sendDeviceEvent(oldValue, null);
        }
    }

    public List<AssetView> getAssets(Collection<GUID> deviceIDs) {
        ArrayList<AssetView> result = new ArrayList<AssetView>(deviceIDs.size());
        ArrayList<GUID> toLoad = new ArrayList<GUID>();
        for (GUID id : deviceIDs) {
            AssetView deviceVO = (AssetView)this.cache.get((Object)id);
            if (deviceVO == null) {
                toLoad.add(id);
                continue;
            }
            result.add(deviceVO);
        }
        if (!toLoad.isEmpty()) {
            List<AssetVO> loaded = this.dao.getAssets(toLoad);
            loaded.forEach(d -> {
                AssetView view = AssetViewImpl.create(d);
                this.cache.put((Object)d.getId(), (Object)view);
                result.add(view);
            });
        }
        return result;
    }

    public List<HistoryStep> getHistory(GUID deviceId) {
        List<HistoryStep> list = (List<HistoryStep>)this.historyCache.get((Object)deviceId);
        if (list != null) {
            return list;
        }
        AssetView deviceVO = this.get(deviceId);
        if (deviceVO == null) {
            throw new IllegalArgumentException("Device does not exists: " + String.valueOf(deviceId));
        }
        try (ThreadUtils.Semaphore s = ThreadUtils.getSemaphore((Object)("device" + String.valueOf(deviceId)));){
            List<HistoryStep> list2;
            block14: {
                ServerLock lock = ThreadUtils.getLock((Object)s);
                try {
                    list = this.dao.getHistorySteps(deviceVO.getIntID());
                    this.historyCache.put((Object)deviceId, list);
                    list2 = list;
                    if (lock == null) break block14;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                lock.close();
            }
            return list2;
        }
    }

    public void deleteValuesOfDeletedFields(List<AssetFieldWithDefinition<?>> fieldsToDelete) {
        MutableAssetData data = new MutableAssetData();
        for (AssetFieldWithDefinition<?> deviceFieldWithDefinition : fieldsToDelete) {
            data.put(deviceFieldWithDefinition, null);
        }
        Iterator<GUID> iterator = this.iterator();
        while (iterator.hasNext()) {
            GUID guid = iterator.next();
            ThreadUtils.Semaphore s = ThreadUtils.getSemaphore((Object)("device" + String.valueOf(guid)));
            try {
                ServerLock lock = ThreadUtils.getLock((Object)s);
                try {
                    this.dao.deleteValueOfDeletedFields(guid, data);
                    this.cache.remove((Object)guid);
                }
                finally {
                    if (lock == null) continue;
                    lock.close();
                }
            }
            finally {
                if (s == null) continue;
                s.close();
            }
        }
    }

    public void clearCache() {
        this.cache.clear();
        this.historyCache.clear();
    }

    public void clearCache(GUID assetId) {
        this.mustOwnMonitorOf(assetId);
        this.cache.remove((Object)assetId);
        this.historyCache.remove((Object)assetId);
    }

    public void unarchive(GUID id) {
        try (ThreadUtils.Semaphore s = ThreadUtils.getSemaphore((Object)("device" + String.valueOf(id)));
             ServerLock lock = ThreadUtils.getLock((Object)s);){
            AssetView oldValue = this.get(id);
            if (oldValue == null) {
                throw new IllegalArgumentException("No device exists with id " + String.valueOf(id));
            }
            AssetVO newDevice = this.dao.unarchive(id);
            AssetView newView = AssetViewImpl.create(newDevice);
            this.cache.put((Object)id, (Object)newView);
            long time = System.currentTimeMillis();
            GUID user = UserManager.getInstance().getCurrentUserAccountID();
            if (UserManager.PRIVILEGED_ACCOUNT_ID.equals((Object)user)) {
                user = null;
            }
            HistoryStep step = new HistoryStep(newDevice.getIntID(), time, user, AssetManager.MSG.getMsg("manager.history.unarchive", new Object[0]));
            this.dao.addHistoryStep(step);
            this.historyCache.remove((Object)id);
            this.sendChangedEvendAndNotifyIndex(oldValue, newView);
        }
    }

    void sendChangedEvendAndNotifyIndex(@Nonnull AssetView oldView, @Nonnull AssetView newView) {
        SearchDataCacheChangeListener[] listeners;
        GUID id = oldView.getId();
        this.mustOwnMonitorOf(id);
        for (SearchDataCacheChangeListener searchDataCacheChangeListener : listeners = this.getListeners()) {
            searchDataCacheChangeListener.entryChanged((Object)id, this.map(oldView), this.map(newView));
        }
        this.sendDeviceEvent(oldView, newView);
    }

    private void mustOwnMonitorOf(GUID id) {
        try (ThreadUtils.Semaphore semaphore = ThreadUtils.getSemaphore((Object)("device" + String.valueOf(id)));){
            if (!ThreadUtils.hasLock((Object)semaphore)) {
                throw new IllegalMonitorStateException("Must own lock for the device to send events");
            }
        }
    }
}

