/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.api.model.tree.settings;

import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithDefinition;

public class StructureViewSettings {
    private int depth;
    private boolean flatList;
    private boolean list_sort_ascending = false;
    private AssetFieldWithDefinition<?> list_sort_field = null;
    private boolean listGroupings;

    public StructureViewSettings(int depth, boolean flatList, boolean listGroupings) {
        this.depth = depth;
        this.flatList = flatList;
        this.listGroupings = listGroupings;
    }

    public StructureViewSettings(int depth, boolean listGroupings, boolean list_sort_ascending, AssetFieldWithDefinition<?> list_sort_field) {
        this.depth = depth;
        this.listGroupings = listGroupings;
        this.list_sort_ascending = list_sort_ascending;
        this.list_sort_field = list_sort_field;
        this.flatList = true;
    }

    public StructureViewSettings(int depth, boolean flatList, boolean listGroupings, boolean list_sort_ascending, AssetFieldWithDefinition<?> list_sort_field) {
        this.depth = depth;
        this.flatList = flatList;
        this.listGroupings = listGroupings;
        this.list_sort_ascending = list_sort_ascending;
        this.list_sort_field = list_sort_field;
    }

    public boolean isFlatList() {
        return this.flatList;
    }

    public boolean isListGroupings() {
        return this.listGroupings;
    }

    public int getDepth() {
        return this.depth;
    }

    public String toString() {
        return "StructureViewSettings [depth=" + this.depth + ", flatList=" + this.flatList + ", list_sort_ascending=" + this.list_sort_ascending + ", list_sort_field=" + String.valueOf(this.list_sort_field) + "]";
    }

    public boolean isList_sort_ascending() {
        return this.list_sort_ascending;
    }

    public void setList_sort_ascending(boolean list_sort_ascending) {
        this.list_sort_ascending = list_sort_ascending;
    }

    public AssetFieldWithDefinition<?> getList_sort_field() {
        return this.list_sort_field;
    }

    public void setList_sort_field(AssetFieldWithDefinition<?> list_sort_field) {
        if (list_sort_field != null && list_sort_field.getEntrySearchTag() == null) {
            throw new IllegalArgumentException("Can only sort by a column which has a searchtag, but " + list_sort_field.getKey() + " has none.");
        }
        this.list_sort_field = list_sort_field;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.depth;
        result = 31 * result + (this.flatList ? 1231 : 1237);
        result = 31 * result + (this.listGroupings ? 1231 : 1237);
        result = 31 * result + (this.list_sort_ascending ? 1231 : 1237);
        result = 31 * result + (this.list_sort_field == null ? 0 : this.list_sort_field.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StructureViewSettings other = (StructureViewSettings)obj;
        if (this.depth != other.depth) {
            return false;
        }
        if (this.flatList != other.flatList) {
            return false;
        }
        if (this.listGroupings != other.listGroupings) {
            return false;
        }
        if (this.list_sort_ascending != other.list_sort_ascending) {
            return false;
        }
        return !(this.list_sort_field == null ? other.list_sort_field != null : !this.list_sort_field.equals(other.list_sort_field));
    }
}

