/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.internal.tree;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.id.GUID;
import com.inet.search.command.SearchID;
import com.inet.search.index.IndexSearchEngine;
import com.inet.thread.EventDispatcher;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;

public abstract class BaseClientHandling {
    private static final ForkJoinPool POOL = new ForkJoinPool(4);
    protected final EventDispatcher<?> eventDispatcher = new EventDispatcher(false, false, POOL);
    private static final AtomicInteger POOL_COUNT = new AtomicInteger();
    protected final HashSet<GUID> collectedChangedIds = new HashSet();
    protected boolean stopped;
    protected final IndexSearchEngine<GUID> engine = AssetManager.getInstance().getSearchEngine();

    protected abstract void checkForVisibleChangesImpl(@Nonnull Set<GUID> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForVisibleChanges(GUID id) {
        if (id != null) {
            HashSet<GUID> hashSet = this.collectedChangedIds;
            synchronized (hashSet) {
                this.collectedChangedIds.add(id);
            }
        }
        this.eventDispatcher.dispatchEvent(() -> {
            HashSet<GUID> currentChangedIds;
            HashSet<GUID> hashSet = this.collectedChangedIds;
            synchronized (hashSet) {
                if (id != null && this.collectedChangedIds.size() == 0) {
                    return;
                }
                currentChangedIds = new HashSet<GUID>(this.collectedChangedIds);
                this.collectedChangedIds.clear();
            }
            POOL_COUNT.incrementAndGet();
            try {
                this.checkForVisibleChangesImpl(currentChangedIds);
            }
            catch (Throwable th) {
                HDLogger.error((Object)th);
            }
            finally {
                POOL_COUNT.decrementAndGet();
            }
        });
    }

    public void stop() {
        this.stopped = true;
        this.engine.cancel(this.createSearchID());
    }

    protected abstract SearchID createSearchID();
}

