/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.internal;

import com.inet.helpdesk.plugins.inventory.client.InventoryAttachments;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AbstractAsset;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.HistoryStep;
import com.inet.helpdesk.plugins.inventory.server.api.model.MutableAssetData;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.tree.AssetClientHandler;
import com.inet.helpdesk.plugins.inventory.server.eventlog.AssetEventLog;
import com.inet.helpdesk.plugins.inventory.server.internal.AssetClientHandlingImpl;
import com.inet.helpdesk.plugins.inventory.server.internal.AssetDAO;
import com.inet.helpdesk.plugins.inventory.server.internal.AssetDataCache;
import com.inet.helpdesk.plugins.inventory.server.internal.AssetVOImpl;
import com.inet.helpdesk.plugins.inventory.server.internal.AssetViewImpl;
import com.inet.helpdesk.plugins.inventory.server.internal.InheritedOwnerFieldChangedListener;
import com.inet.helpdesk.plugins.inventory.server.internal.search.AssetSearchEngine;
import com.inet.helpdesk.plugins.inventory.server.internal.search.AssetVetoPower;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.FieldValidationException;
import com.inet.usersandgroups.api.user.UserEventListener;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AssetManagerImpl
implements AssetManager,
AssetManager.AssetMaintenance {
    private AssetSearchEngine searchEngine = new AssetSearchEngine();
    private AssetVetoPower vetoPower = new AssetVetoPower(this);
    private AssetDAO dao = new AssetDAO();
    private AssetDataCache dataCache = new AssetDataCache(this.dao);
    private AtomicInteger idGenerator = new AtomicInteger();
    private boolean initialized = false;
    private AssetClientHandlingImpl view = new AssetClientHandlingImpl(this);

    public AssetVetoPower getVetoPower() {
        return this.vetoPower;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeSearchEngine() throws IOException {
        AssetManagerImpl assetManagerImpl = this;
        synchronized (assetManagerImpl) {
            if (this.initialized) {
                return;
            }
            this.idGenerator.set(this.dao.getMaxAssetId());
            this.searchEngine.init(this.dataCache, this.vetoPower);
            UserManager.getInstance().registerListener((UserEventListener)new InheritedOwnerFieldChangedListener(this.dataCache));
            this.initialized = true;
        }
    }

    @Nonnull
    public IndexSearchEngine<GUID> getSearchEngine() {
        return this.searchEngine.getSearchEngine();
    }

    @Override
    public AssetView createAsset(MutableAssetData data, List<AssetManager.AdditionalTask> extensionTasks, boolean ignoreMandatoryCheck) {
        this.checkAccess(InventoryServerPlugin.INVENTORY_READ_WRITE);
        if (!SystemPermissionChecker.checkAccess((Permission)InventoryServerPlugin.INVENTORY_ALL)) {
            AssetView parent;
            GUID guid = data.get(AssetFields.FIELD_OWNER);
            if (guid == null && data.get(AssetFields.FIELD_PARENT) != null && (parent = this.getAsset(data.get(AssetFields.FIELD_PARENT))) != null) {
                guid = parent.getValue(AssetFields.FIELD_OWNER);
            }
            if (!Objects.equals(guid, UserManager.getInstance().getCurrentUserAccountID())) {
                throw new AccessDeniedException(InventoryServerPlugin.INVENTORY_ALL);
            }
        }
        this.validateDeviceData(data, (AssetView)null);
        data = this.applyDefaultValues(data);
        GUID id = GUID.generateNew();
        AssetView newView = AssetViewImpl.create(new AssetVOImpl(id, data, false, Collections.emptyList()));
        if (!ignoreMandatoryCheck) {
            this.checkRequiredFields(newView);
        }
        int deviceId = this.idGenerator.incrementAndGet();
        AssetView vo = this.dataCache.create(id, deviceId, data, extensionTasks);
        AssetEventLog.AssetCreated.log(vo);
        return vo;
    }

    private <T> void checkRequiredFields(AssetView data) {
        Integer type = data.getValue(AssetFields.FIELD_TYPE);
        if (type == null) {
            throw new IllegalArgumentException(MSG.getMsg("manager.error.missingValue", new Object[]{AssetFields.FIELD_TYPE.getLabel()}));
        }
        for (AssetField f : DynamicExtensionManager.getInstance().get(AssetField.class)) {
            AssetFieldWithDefinition def;
            if (data.getValue(f) != null || !(f instanceof AssetFieldWithDefinition) || !(def = (AssetFieldWithDefinition)f).isMandatory() || !def.isVisibleInType(type)) continue;
            throw new IllegalArgumentException(MSG.getMsg("manager.error.missingValue", new Object[]{f.getLabel()}));
        }
    }

    private MutableAssetData applyDefaultValues(MutableAssetData data) {
        data = data.copy();
        for (AssetField field : DynamicExtensionManager.getInstance().get(AssetField.class)) {
            if (data.containsKey(field) || field.getDefaultValue() == null || "".equals(field.getDefaultValue())) continue;
            data.put(field, field.getDefaultValue());
        }
        return data;
    }

    @Override
    public void updateAsset(GUID id, MutableAssetData dataToChange, List<AssetManager.AdditionalTask> extensionTasks, boolean ignoreMandatoryChecks) {
        GUID guid;
        this.checkAccess(InventoryServerPlugin.INVENTORY_READ_WRITE);
        AssetView device = this.getAsset(id);
        if (device == null) {
            throw new IllegalArgumentException(MSG.getMsg("manager.error.doesnotexist", new Object[]{id}));
        }
        this.checkDeviceToAccessBelongsToCurrentUserOrCanAccessAll(device);
        if (!SystemPermissionChecker.checkAccess((Permission)InventoryServerPlugin.INVENTORY_ALL) && dataToChange.containsKey(AssetFields.FIELD_OWNER) && !Objects.equals(guid = dataToChange.get(AssetFields.FIELD_OWNER), UserManager.getInstance().getCurrentUserAccountID())) {
            throw new AccessDeniedException(InventoryServerPlugin.INVENTORY_ALL);
        }
        this.validateDeviceData(dataToChange, device);
        if (!ignoreMandatoryChecks && dataToChange.getIncludedFields().stream().anyMatch(f -> !f.getKey().equals(AssetFields.FIELD_PARENT.getKey()))) {
            MutableAssetData data = ((AssetViewImpl)device).getAssetVO().asAssetDataRepresentation();
            data.putAll(dataToChange);
            AssetView newView = AssetViewImpl.create(new AssetVOImpl(device.getId(), data, device.isArchived(), Collections.emptyList()));
            this.checkRequiredFields(newView);
        }
        this.dataCache.update(id, dataToChange, extensionTasks);
    }

    private void validateDeviceData(MutableAssetData dataToChange, @Nullable AssetView deviceToUpdate) {
        for (AssetField<Object> f : dataToChange.getIncludedFields()) {
            try {
                f.validateRealValue(dataToChange.get(f));
            }
            catch (FieldValidationException ex) {
                throw new FieldValidationException(f.getLabel() + ": " + ex.getMessage(), (Throwable)ex);
            }
        }
        if (dataToChange.get(AssetFields.FIELD_PARENT) != null) {
            boolean childArchived;
            GUID parentId = dataToChange.get(AssetFields.FIELD_PARENT);
            AssetView parent = this.getAsset(parentId);
            if (parent == null) {
                throw new FieldValidationException(MSG.getMsg("manager.error.doesnotexist", new Object[]{parentId}));
            }
            boolean bl = childArchived = deviceToUpdate == null ? false : deviceToUpdate.isArchived();
            if (!childArchived && parent.isArchived()) {
                throw new FieldValidationException(MSG.getMsg("manager.error.parentcannotbearchived", new Object[0]));
            }
            if (deviceToUpdate != null && parentId.equals((Object)deviceToUpdate.getId())) {
                throw new FieldValidationException(MSG.getMsg("manager.error.parentcannotbeself", new Object[0]));
            }
            if (deviceToUpdate != null && this.isChildOrSubChildOf(parent, deviceToUpdate)) {
                throw new FieldValidationException(MSG.getMsg("manager.error.parentcannotbeChildOfSelf", new Object[0]));
            }
        }
    }

    private boolean isChildOrSubChildOf(AssetView asset, AssetView of) {
        GUID parentID = asset.getParentID();
        if (parentID == null) {
            return false;
        }
        if (parentID.equals((Object)of.getId())) {
            return true;
        }
        AssetView parent = this.getAsset(parentID);
        return this.isChildOrSubChildOf(parent, of);
    }

    private void checkDeviceToAccessBelongsToCurrentUserOrCanAccessAll(AssetView vo) {
        GUID guid;
        if (!SystemPermissionChecker.checkAccess((Permission)InventoryServerPlugin.INVENTORY_ALL) && !Objects.equals(guid = vo.getValue(AssetFields.FIELD_OWNER), UserManager.getInstance().getCurrentUserAccountID())) {
            throw new AccessDeniedException(InventoryServerPlugin.INVENTORY_ALL);
        }
    }

    private void checkAccess(@Nonnull Permission permission) {
        if (!SystemPermissionChecker.checkAccess((Permission)permission)) {
            throw new AccessDeniedException(permission);
        }
    }

    @Override
    public AssetView getAsset(GUID id) {
        AssetView asset = this.getAsset(id, true);
        return asset;
    }

    @Override
    public AssetView getAsset(GUID id, boolean includeArchived) {
        this.checkAccess(InventoryServerPlugin.INVENTORY_READ);
        AssetView deviceVO = this.dataCache.get(id);
        this.checkDeviceToAccessBelongsToCurrentUserOrCanAccessAll(deviceVO);
        if (deviceVO != null && !includeArchived && deviceVO.isArchived()) {
            return null;
        }
        return deviceVO;
    }

    @Override
    @Nonnull
    public List<AssetView> getAssets(Collection<GUID> deviceIDs) {
        return this.getAssets(deviceIDs, true);
    }

    @Override
    public List<AssetView> getAssets(Collection<GUID> deviceIDs, boolean includeArchived) {
        this.checkAccess(InventoryServerPlugin.INVENTORY_READ);
        List<AssetView> devices = this.dataCache.getAssets(deviceIDs);
        if (!includeArchived) {
            devices.removeIf(AbstractAsset::isArchived);
        }
        if (!SystemPermissionChecker.checkAccess((Permission)InventoryServerPlugin.INVENTORY_ALL)) {
            devices.removeIf(d -> !Objects.equals(UserManager.getInstance().getCurrentUserAccountID(), d.getValue(AssetFields.FIELD_OWNER)));
        }
        return devices;
    }

    @Override
    public List<HistoryStep> getAssetHistory(GUID deviceId) {
        AssetView device = this.getAsset(deviceId);
        if (device == null) {
            throw new IllegalArgumentException(MSG.getMsg("manager.error.doesnotexist", new Object[]{deviceId}));
        }
        this.checkDeviceToAccessBelongsToCurrentUserOrCanAccessAll(device);
        return this.dataCache.getHistory(deviceId);
    }

    @Override
    public void archiveAsset(GUID id) {
        this.checkAccess(InventoryServerPlugin.INVENTORY_READ_WRITE);
        AssetView device = this.getAsset(id);
        if (device == null) {
            throw new IllegalArgumentException(MSG.getMsg("manager.error.doesnotexist", new Object[]{id}));
        }
        if (device.isArchived()) {
            return;
        }
        this.checkDeviceToAccessBelongsToCurrentUserOrCanAccessAll(device);
        device.getChildAssetIDs().forEach(child -> this.archiveAsset((GUID)child));
        this.dataCache.archive(id);
        AssetEventLog.AssetArchived.log(device);
    }

    @Override
    public void unarchiveAsset(GUID id, boolean includeAllSubAssets) {
        AssetView parent;
        this.checkAccess(InventoryServerPlugin.INVENTORY_READ_WRITE);
        AssetView device = this.getAsset(id);
        if (device == null) {
            throw new IllegalArgumentException(MSG.getMsg("manager.error.doesnotexist", new Object[]{id}));
        }
        if (!device.isArchived()) {
            return;
        }
        this.checkDeviceToAccessBelongsToCurrentUserOrCanAccessAll(device);
        if (device.getParentID() != null && (parent = this.getAsset(device.getParentID())).isArchived()) {
            this.unarchiveAsset(parent.getId());
        }
        this.dataCache.unarchive(id);
        AssetEventLog.AssetUnarchived.log(device);
        if (includeAllSubAssets) {
            device.getChildAssetIDs().forEach(child -> this.unarchiveAsset((GUID)child, includeAllSubAssets));
        }
    }

    @Override
    public void physicallyDeleteDevice(GUID id) {
        AssetView device = this.getAsset(id);
        if (device == null) {
            return;
        }
        device.getChildAssetIDs().forEach(child -> this.physicallyDeleteDevice((GUID)child));
        if (ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
            InventoryAttachments.getAttachments(id).forEach(att -> InventoryAttachments.deleteAttachment(device.getIntID(), att.getFileName()));
        }
        this.dataCache.delete(id);
        AssetEventLog.AssetDeleted.log(device);
    }

    @Override
    public AssetManager.AssetMaintenance maintenance() {
        this.checkAccess(Permission.CONFIGURATION);
        return this;
    }

    @Override
    public void deleteValuesOfDeletedFields(List<AssetFieldWithDefinition<?>> fieldsToDelete) {
        if (fieldsToDelete == null || fieldsToDelete.isEmpty()) {
            throw new IllegalArgumentException("fields cannot be null or empty");
        }
        AssetFields.getPredefinedAssetFields().forEach(f -> {
            if (fieldsToDelete.contains(f)) {
                throw new IllegalArgumentException("Cannot delete predefined field: " + f.getKey());
            }
        });
        this.dataCache.deleteValuesOfDeletedFields(fieldsToDelete);
    }

    @Override
    public AssetClientHandler view() {
        return this.view;
    }

    @Override
    public void clearCacheAndReIndex() {
        this.dataCache.clearCache();
        if (!this.getSearchEngine().isReindexRunning()) {
            this.getSearchEngine().reIndexAsync();
        }
    }

    @Override
    public void clearCache() {
        this.dataCache.clearCache();
    }

    @Override
    public void validateDeviceData(MutableAssetData dataToChange, @Nullable GUID deviceToUpdate) {
        this.validateDeviceData(dataToChange, deviceToUpdate == null ? null : this.getAsset(deviceToUpdate));
    }

    public AssetDataCache getDataCache() {
        return this.dataCache;
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

