/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.config.generics;

import com.inet.annotations.JsonData;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigRowAction;
import com.inet.config.structure.model.ItemListConfigProperty;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.model.SelectConfigProperty;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.helpdesk.config.TicketValueIconConfigProperty;
import com.inet.helpdesk.config.Translator;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.TicketFieldDefinitionResourceId;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.sla.AssetSLA;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.sla.AssetSLAManager;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

@JsonData
public class SlaListConfigProperty
extends ItemListConfigProperty {
    public static final String PROPERTY_KEY = "DeviceSla";

    public SlaListConfigProperty(ConfigStructureSettings settings, Translator translator) {
        super(0, PROPERTY_KEY, "GENERIC_WITHICON", SlaListConfigProperty.getObjectListValue(settings), null, new ConfigRowAction[]{SlaListConfigProperty.getRowAction(translator, settings.getLocale().getLanguage())});
        this.setDuplicatePossible(true);
    }

    static Object getObjectListValue(ConfigStructureSettings settings) {
        ArrayList changedValueRaw = (ArrayList)settings.getChangedValue(PROPERTY_KEY, ArrayList.class);
        if (changedValueRaw != null) {
            changedValueRaw.sort(Comparator.comparing(o -> (String)o.get("name"), String.CASE_INSENSITIVE_ORDER));
            return changedValueRaw;
        }
        ArrayList<HashMap> result = new ArrayList<HashMap>();
        if (!settings.isFilter()) {
            List list = AssetSLAManager.getInstance().getAll(true);
            for (AssetSLA type : list) {
                HashMap<String, String> entry = SlaListConfigProperty.convertToHashmap(type);
                result.add(entry);
            }
            result.sort(Comparator.comparing(o -> (String)o.get("name"), String.CASE_INSENSITIVE_ORDER));
        }
        return result;
    }

    private static HashMap<String, String> convertToHashmap(AssetSLA action) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("id", "" + action.getId());
        result.put("name", action.getDisplayValue());
        result.put("agreement", action.getSLA());
        result.put("resource", SlaListConfigProperty.strEmpty(action.getResID()));
        result.put("imageTypeId", String.valueOf(17));
        TicketValueIconConfigProperty.prepareConfigValueMapForIcons(result);
        return result;
    }

    private static String strEmpty(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    private static ConfigRowAction getRowAction(Translator translator, String language) {
        ConfigAction action = new ConfigAction("sla.new", translator.translate(new String[]{"field.sla.add"}));
        ConfigCategory category = new ConfigCategory(0, "sla.new", translator.translate(new String[]{"field.sla.name"}), "assets.slas");
        ArrayList<ConfigPropertyGroup> propertyGroups = new ArrayList<ConfigPropertyGroup>();
        propertyGroups.add(new ConfigPropertyGroup(0, "sla.new.group", ""));
        HashMap properties = new HashMap();
        ArrayList<Object> propertyList = new ArrayList<Object>();
        properties.put("sla.new.group", propertyList);
        ArrayList conditions = new ArrayList();
        ConfigRowAction rowAction = new ConfigRowAction(action, null, category, propertyGroups, properties, conditions);
        propertyList.add(SlaListConfigProperty.propWith("SimpleText", translator.translate(new String[]{"field.sla.row.name"}), "name", ""));
        UserGroupManager userGroupManager = UserGroupManager.getInstance();
        List options = userGroupManager.getGroups(HDUsersAndGroups.RESOURCE).stream().map(g -> new LocalizedKey(String.valueOf(HDUsersAndGroups.getResourceId((GUID)g.getID())), TicketFieldDefinitionResourceId.getDisplayName((UserGroupInfo)g, (UserGroupManager)userGroupManager))).sorted((l, r) -> l.getDisplayName().compareTo(r.getDisplayName())).collect(Collectors.toList());
        propertyList.add(new SelectConfigProperty(0, "resource", "SimpleText", translator.translate(new String[]{"field.sla.row.resource"}), (Object)"", "", options));
        propertyList.add(new TicketValueIconConfigProperty(0, translator.translate(new String[]{"field.type.row.icon"}), 17));
        propertyList.add(SlaListConfigProperty.propWith("MultiLineText", translator.translate(new String[]{"field.sla.row.agreement"}), "agreement", ""));
        propertyList.add(SlaListConfigProperty.propWith("Hidden", "", "id", "-1"));
        return rowAction;
    }

    private static ConfigProperty propWith(String type, String label, String keyName, String value) {
        return new ConfigProperty(0, keyName, type, label, (Object)value, null, null);
    }
}

