/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.api;

import com.inet.classloader.I18nMessages;
import com.inet.field.FieldManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.HistoryStep;
import com.inet.helpdesk.plugins.inventory.server.api.model.MutableAssetData;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.tree.AssetClientHandler;
import com.inet.helpdesk.plugins.inventory.server.internal.AssetManagerImpl;
import com.inet.id.GUID;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface AssetManager
extends FieldManager<GUID> {
    public static final I18nMessages MSG = new I18nMessages("com.inet.helpdesk.plugins.inventory.server.api.i18n.LanguageResources", AssetManager.class);

    @Nonnull
    public static AssetManager getInstance() {
        return Holder.INSTANCE;
    }

    public void archiveAsset(GUID var1);

    public void unarchiveAsset(GUID var1, boolean var2);

    default public void unarchiveAsset(GUID id) {
        this.unarchiveAsset(id, false);
    }

    @Nonnull
    public List<AssetView> getAssets(Collection<GUID> var1);

    public List<AssetView> getAssets(Collection<GUID> var1, boolean var2);

    public AssetView getAsset(GUID var1);

    public AssetView getAsset(GUID var1, boolean var2);

    public void updateAsset(GUID var1, MutableAssetData var2, List<AdditionalTask> var3, boolean var4);

    default public void updateAsset(GUID id, MutableAssetData dataToChange, List<AdditionalTask> extensionTasks) {
        this.updateAsset(id, dataToChange, extensionTasks, false);
    }

    default public void updateAsset(GUID id, MutableAssetData dataToChange) {
        this.updateAsset(id, dataToChange, Collections.emptyList());
    }

    public AssetView createAsset(MutableAssetData var1, List<AdditionalTask> var2, boolean var3);

    default public AssetView createAsset(MutableAssetData data, List<AdditionalTask> extensionTasks) {
        return this.createAsset(data, extensionTasks, false);
    }

    default public AssetView createAsset(MutableAssetData data) {
        return this.createAsset(data, Collections.emptyList());
    }

    public List<HistoryStep> getAssetHistory(GUID var1);

    public AssetMaintenance maintenance();

    public AssetClientHandler view();

    public void validateDeviceData(MutableAssetData var1, @Nullable GUID var2);

    public static class Holder {
        private static AssetManager INSTANCE = new AssetManagerImpl();
    }

    public static interface AdditionalTask
    extends BiConsumer<AssetView, Consumer<HistoryStep>> {
    }

    public static interface AssetMaintenance {
        public void physicallyDeleteDevice(GUID var1);

        public void deleteValuesOfDeletedFields(List<AssetFieldWithDefinition<?>> var1);

        public void clearCacheAndReIndex();

        public void clearCache();
    }
}

