/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.webapi.fields;

import com.inet.helpdesk.plugins.inventory.server.webapi.data.InventoryAssetField;
import com.inet.helpdesk.plugins.inventory.server.webapi.util.InventoryWebAPIHelper;
import com.inet.plugin.webapi.api.handler.RequestHandlerBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Tag(name="Inventory", description="Operations for managing inventory assets")
public class InventoryFieldsHandler
extends RequestHandlerBase<Void, List<InventoryAssetField>> {
    public InventoryFieldsHandler() {
        super(new String[]{"fields"});
    }

    public String getHelpPageKey() {
        return "webapi.inventory.fields";
    }

    @Operation(summary="Get all asset fields", description="Retrieves a list of all available asset fields and their definitions", responses={@ApiResponse(responseCode="200", description="List of asset fields retrieved successfully", content={@Content(array=@ArraySchema(schema=@Schema(implementation=InventoryAssetField.class)))}), @ApiResponse(responseCode="401", description="User not authorized to access asset fields")})
    public List<InventoryAssetField> handle(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nullable Void inputObject, @Nonnull List<String> pathTokens, boolean previewModeEnabled) throws IOException {
        Stream assetFields = InventoryWebAPIHelper.getAssetFieldDefintions().stream();
        return assetFields.map(af -> InventoryAssetField.from(af)).collect(Collectors.toList());
    }
}

