/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.internal.tree;

import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.AssetNodeIdentifier;
import com.inet.helpdesk.plugins.inventory.server.api.tree.AssetClientListener;
import com.inet.helpdesk.plugins.inventory.server.internal.tree.TreeClientHandling;
import com.inet.id.GUID;
import javax.annotation.Nullable;

public class AssetClientHandling {
    private GUID assetID;
    private AssetClientListener listener;
    private String clientId;
    private TreeClientHandling treeClientHandling;

    public AssetClientHandling(GUID assetID, AssetClientListener listener, String clientId, AssetManager manager, TreeClientHandling treeClientHandling) {
        this.assetID = assetID;
        this.listener = listener;
        this.clientId = clientId;
        this.treeClientHandling = treeClientHandling;
        try {
            AssetView device = manager.getAsset(assetID);
            listener.assetChanged(clientId, assetID, device);
            if (device != null && this.treeClientHandling != null) {
                this.treeClientHandling.expandTreeToNode(new AssetNodeIdentifier(assetID));
            }
        }
        catch (Throwable error) {
            listener.sendError(clientId, error, assetID);
        }
    }

    public void assetChanged(GUID assetID, @Nullable AssetView newState) {
        if (assetID.equals((Object)this.assetID)) {
            try {
                this.listener.assetChanged(this.clientId, assetID, newState);
            }
            catch (Throwable error) {
                this.listener.sendError(this.clientId, error, assetID);
            }
        }
    }
}

