/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.client.event;

import com.inet.helpdesk.plugins.inventory.client.data.TreeNodesChangedRequest;
import com.inet.helpdesk.plugins.inventory.client.event.AbstractInventoryEvent;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.tree.AssetNodeIdentifier;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.http.websocket.WebsocketConnection;
import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;

public class TreeNodesChanged
extends AbstractInventoryEvent<TreeNodesChangedRequest> {
    @Override
    public void handleEvent(WebSocketEventHandler eventHandler, WebsocketConnection websocketConnection, TreeNodesChangedRequest payload) throws IOException {
        Set<AssetNodeIdentifier> openNodes = payload.getOpenNodes().stream().map(id -> AssetNodeIdentifier.valueOf(id)).collect(Collectors.toSet());
        Set<AssetNodeIdentifier> closedNodes = payload.getClosedNodes().stream().map(id -> AssetNodeIdentifier.valueOf(id)).collect(Collectors.toSet());
        AssetManager.getInstance().view().treeNodesChanged(websocketConnection.getPollingID(), openNodes, closedNodes);
    }

    public String getEventName() {
        return "inventory.tree.nodeschanged";
    }
}

