/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.ui.fields.user;

import com.inet.field.ConfigurableField;
import com.inet.http.ClientMessageException;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.ui.Type;
import com.inet.usersandgroups.api.ui.fields.FieldDefinition;
import com.inet.usersandgroups.api.ui.fields.UserUpdateData;
import com.inet.usersandgroups.api.ui.fields.user.UF_Editability;
import com.inet.usersandgroups.api.ui.fields.user.UF_Visibility;
import com.inet.usersandgroups.api.ui.fields.values.FieldValue;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class UserFieldDefinition<T>
extends FieldDefinition
implements ConfigurableField {
    @Nullable
    private final UserField<T> a;
    private UF_Editability b = UF_Editability.USERS_CAN_CHANGE;
    private UF_Visibility c = UF_Visibility.VISIBLE_FOR_ALL;

    public UserFieldDefinition(String groupKey, String fieldKey, String displayType, int prio) {
        super(groupKey, Type.user, fieldKey, displayType, prio);
        this.a = null;
    }

    public UserFieldDefinition(String groupKey, String displayType, int prio, UserField<T> relatedUserField) {
        super(groupKey, Type.user, relatedUserField.getKey(), displayType, prio);
        this.a = relatedUserField;
    }

    public abstract FieldValue getFieldValue(@Nullable UserAccount var1);

    public abstract T convertFromString(String var1);

    public void validate(Object value) throws ClientMessageException {
        UserField userField = UserManager.getRecoveryEnabledInstance().getField(this.getFieldKey());
        if (userField != null) {
            try {
                userField.validate(value);
            }
            catch (Throwable throwable) {
                throw new ClientMessageException(this.getLabel() + ": " + throwable.getMessage());
            }
        }
    }

    public void save(UserAccount userAccount, UserUpdateData userUpdateData, Object value) {
        userUpdateData.addUserData(this.getFieldKey(), value);
    }

    public boolean isAvailable(UserAccount userAccount) {
        return this.c.isVisible();
    }

    public boolean isBatchEditable() {
        return false;
    }

    @Nullable
    public T getDefaultValue() {
        if (this.a != null) {
            return (T)this.a.getDefaultValue();
        }
        return null;
    }

    public void setDefaultValue(@Nullable String value) {
        if (this.a != null) {
            this.a.setDefaultValue(this.convertFromString(value));
        }
    }

    @Nullable
    public UserField<T> getUserField() {
        return this.a;
    }

    @Override
    public void setSortPrio(int prio) {
        super.setSortPrio(prio);
    }

    protected boolean isEnabled() {
        return this.b.isEditable();
    }

    @Nonnull
    public UF_Editability getEditability() {
        return this.b;
    }

    public void setEditability(@Nonnull UF_Editability editability) {
        if (editability == null) {
            throw new IllegalArgumentException("null!");
        }
        this.b = editability;
    }

    @Nonnull
    public UF_Visibility getVisibility() {
        return this.c;
    }

    public void setVisibility(@Nonnull UF_Visibility visibility) {
        if (visibility == null) {
            throw new IllegalArgumentException("null!");
        }
        this.c = visibility;
    }

    @Override
    public String getLabel() {
        if (this.a != null) {
            return this.a.getLabel();
        }
        return "No label for: " + this.getFieldKey();
    }
}

