/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.ui.fields.user;

import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.ui.fields.PermissionDescription;
import com.inet.usersandgroups.api.ui.fields.PermissionPatcher;
import com.inet.usersandgroups.api.ui.fields.UserUpdateData;
import com.inet.usersandgroups.api.ui.fields.user.CoreUserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.PermissionDefinitionHelper;
import com.inet.usersandgroups.api.ui.fields.user.StringListUserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.values.PermissionFieldValue;
import com.inet.usersandgroups.api.user.UserAccount;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class PermissionUserFieldDefinition
extends StringListUserFieldDefinition
implements CoreUserFieldDefinition {
    public PermissionUserFieldDefinition(String groupKey, String fieldKey, int prio) {
        super(groupKey, fieldKey, "fieldtype_permission", prio);
    }

    @Override
    public PermissionFieldValue getFieldValue(UserAccount userAccount) {
        Object object;
        HashSet<Permission> hashSet = new HashSet();
        if (userAccount != null) {
            hashSet = userAccount.getPermissions();
        }
        ArrayList<PermissionDescription> arrayList = new ArrayList<PermissionDescription>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        PermissionDefinitionHelper.createPermissionDefinition(hashSet, this.getGroupKey(), arrayList, arrayList2);
        ArrayList<String> arrayList3 = new ArrayList<String>();
        if (userAccount != null) {
            object = UserGroupManager.getRecoveryEnabledInstance();
            Set<UserGroupInfo> set = ((UserGroupManager)object).getGroupsForUser(userAccount.getID());
            for (UserGroupInfo userGroupInfo : set) {
                Set<Permission> set2 = UsersAndGroups.GROUPID_ADMIN.equals(userGroupInfo.getID()) ? new HashSet<Permission>(Arrays.asList(Permission.values())) : Permission.filterOutPermissionsWithoutGrantedAncestorPermissions(userGroupInfo.getPermissions());
                for (Permission permission : set2) {
                    arrayList3.add(permission.getKey());
                }
            }
        }
        object = new PermissionFieldValue(arrayList2, arrayList.toArray(new PermissionDescription[arrayList.size()]));
        ((PermissionFieldValue)object).setInheritKeys(arrayList3.toArray(new String[arrayList3.size()]));
        return object;
    }

    @Override
    public void save(UserAccount userAccount, UserUpdateData userUpdateData, Object value) {
        Object object;
        HashSet hashSet = userAccount != null ? userAccount.getPermissions() : new HashSet();
        HashSet<Object> hashSet2 = new HashSet<Object>();
        ArrayList arrayList = (ArrayList)value;
        List<PermissionPatcher> list = ServerPluginManager.getInstance().get(PermissionPatcher.class);
        for (PermissionPatcher object2 : list) {
            object = object2.getGroupKey();
            if (object != null && !((String)object).equals(this.getGroupKey())) continue;
            object2.patchSaveFields(arrayList);
        }
        for (String string : arrayList) {
            object = Permission.valueOf(string);
            hashSet2.add(object);
        }
        for (Iterator<PermissionPatcher> iterator : Permission.values()) {
            if (hashSet.contains(iterator) && !hashSet2.contains(iterator)) {
                userUpdateData.addRemovedPermission((Permission)((Object)iterator));
            }
            if (hashSet.contains(iterator) || !hashSet2.contains(iterator)) continue;
            userUpdateData.addAddedPermission((Permission)((Object)iterator));
        }
    }

    @Override
    public String getLabel() {
        return null;
    }

    @Override
    public boolean isAvailable(UserAccount userAccount) {
        return SystemPermissionChecker.checkAccess(UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN);
    }
}

