/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.ui.fields.group;

import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.ui.fields.PermissionDescription;
import com.inet.usersandgroups.api.ui.fields.PermissionPatcher;
import com.inet.usersandgroups.api.ui.fields.UserGroupUpdateData;
import com.inet.usersandgroups.api.ui.fields.group.StringListGroupFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.PermissionDefinitionHelper;
import com.inet.usersandgroups.api.ui.fields.values.PermissionFieldValue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class PermissionGroupFieldDefinition
extends StringListGroupFieldDefinition {
    public PermissionGroupFieldDefinition(String groupKey, String fieldKey, int prio) {
        super(groupKey, fieldKey, "fieldtype_permission", prio);
    }

    @Override
    public PermissionFieldValue getFieldValue(UserGroupInfo groupInfo) {
        HashSet<Permission> hashSet = new HashSet();
        if (groupInfo != null) {
            hashSet = groupInfo.getPermissions();
        }
        ArrayList<PermissionDescription> arrayList = new ArrayList<PermissionDescription>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        PermissionDefinitionHelper.createPermissionDefinition(hashSet, this.getGroupKey(), arrayList, arrayList2);
        PermissionFieldValue permissionFieldValue = new PermissionFieldValue(arrayList2, arrayList.toArray(new PermissionDescription[arrayList.size()]));
        permissionFieldValue.setVisibleInPreview(!arrayList2.isEmpty());
        return permissionFieldValue;
    }

    @Override
    public void save(UserGroupInfo userGroup, UserGroupUpdateData userGroupUpdateData, Object value) {
        Object object;
        HashSet hashSet = userGroup != null ? userGroup.getPermissions() : new HashSet();
        HashSet<Object> hashSet2 = new HashSet<Object>();
        ArrayList arrayList = (ArrayList)value;
        List<PermissionPatcher> list = ServerPluginManager.getInstance().get(PermissionPatcher.class);
        for (PermissionPatcher object2 : list) {
            object = object2.getGroupKey();
            if (object != null && !((String)object).equals(this.getGroupKey())) continue;
            object2.patchSaveFields(arrayList);
        }
        for (String string : arrayList) {
            object = Permission.valueOf(string);
            hashSet2.add(object);
        }
        for (Iterator<PermissionPatcher> iterator : Permission.values()) {
            if (hashSet.contains(iterator) && !hashSet2.contains(iterator)) {
                userGroupUpdateData.addRemovedPermission((Permission)((Object)iterator));
            }
            if (hashSet.contains(iterator) || !hashSet2.contains(iterator)) continue;
            userGroupUpdateData.addAddedPermission((Permission)((Object)iterator));
        }
    }

    @Override
    public String getLabel() {
        return null;
    }

    @Override
    public boolean isAvailable(UserGroupInfo userGroup) {
        return SystemPermissionChecker.checkAccess(UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN);
    }
}

