/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.ui.fields.group;

import com.inet.field.SelectOption;
import com.inet.field.SelectOptionResult;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.groups.GroupType;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.groups.UserGroupTreeUtils;
import com.inet.usersandgroups.api.ui.fields.UserGroupUpdateData;
import com.inet.usersandgroups.api.ui.fields.group.SelectGroupFieldDefinition;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class ParentIdGroupFieldDefinition
extends SelectGroupFieldDefinition<String> {
    private GroupType a;
    private int b;

    public ParentIdGroupFieldDefinition(String groupKey, String fieldKey, int prio, GroupType groupType, int maxTreeLevel) {
        super(groupKey, fieldKey, prio);
        this.a = groupType;
        this.b = maxTreeLevel;
    }

    @Override
    public SelectOptionResult getOptions(UserGroupInfo groupInfo, String searchTerm, int currentSize, int chunkSize) {
        Set<UserGroupInfo> set = UserGroupManager.getRecoveryEnabledInstance().getAllGroups();
        int n2 = groupInfo == null ? 1 : UserGroupTreeUtils.checkTreeLevel(groupInfo.getID(), set);
        int n3 = 0;
        if (!StringFunctions.isEmpty(searchTerm)) {
            searchTerm = searchTerm.toLowerCase();
        }
        TreeMap treeMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        set.remove(groupInfo);
        set.forEach(userGroupInfo -> {
            if (userGroupInfo.getType() != this.a) {
                return;
            }
            a a2 = new a((UserGroupInfo)userGroupInfo);
            treeMap.put(a2.b, a2);
        });
        ArrayList<SelectOption> arrayList = new ArrayList<SelectOption>();
        if (n3 >= currentSize && n3 < currentSize + chunkSize) {
            arrayList.add(new SelectOption("", ""));
        }
        ++n3;
        if (n2 >= this.b) {
            return new SelectOptionResult(n3, arrayList);
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            int n4;
            String string;
            a a2 = (a)entry.getValue();
            if (!StringFunctions.isEmpty(searchTerm) && !(string = a2.a.toLowerCase()).contains(searchTerm) || (n4 = a2.c) > this.b - 2) continue;
            if (n3 >= currentSize && n3 < currentSize + chunkSize) {
                arrayList.add(new SelectOption(a2.d.toString(), a2.a));
            }
            ++n3;
        }
        return new SelectOptionResult(n3, arrayList);
    }

    @Override
    public SelectOption getValue(UserGroupInfo groupInfo) {
        UserGroupInfo userGroupInfo;
        GUID gUID;
        String string = "";
        String string2 = "";
        if (groupInfo != null && (gUID = groupInfo.getParentID()) != null && (userGroupInfo = UserGroupManager.getRecoveryEnabledInstance().getGroup(gUID)) != null) {
            string = gUID.toString();
            string2 = userGroupInfo.getDisplayName();
        }
        return new SelectOption(string, string2);
    }

    @Override
    public void save(UserGroupInfo userGroup, UserGroupUpdateData userGroupUpdateData, Object value) {
        if (!StringFunctions.isEmpty((String)value)) {
            GUID gUID = new GUID((String)value);
            userGroupUpdateData.setParentID(gUID);
            userGroupUpdateData.setParentIdChanged(true);
        } else if (value != null) {
            userGroupUpdateData.setParentID(null);
            userGroupUpdateData.setParentIdChanged(true);
        }
    }

    @Override
    public String convertFromString(String value) {
        if (!StringFunctions.isEmpty(value)) {
            SelectOption selectOption = new Json().fromJson(value, SelectOption.class);
            return selectOption.getValue();
        }
        return null;
    }

    @Override
    public void validate(Object value) throws ClientMessageException {
        String string = (String)value;
        if (!StringFunctions.isEmpty(string)) {
            try {
                new GUID(string);
            }
            catch (Throwable throwable) {
                throw new ClientMessageException(throwable.getMessage());
            }
        }
    }

    @Override
    public boolean isAvailable(UserGroupInfo userGroup) {
        return true;
    }

    private static class a {
        private String a = "";
        private String b = "";
        private int c;
        private GUID d;

        public a(UserGroupInfo userGroupInfo) {
            this.a(userGroupInfo);
            this.d = userGroupInfo.getID();
        }

        private void a(UserGroupInfo userGroupInfo) {
            UserGroupInfo userGroupInfo2;
            if (this.a.length() > 0) {
                this.a = " \\ " + this.a;
            }
            this.a = userGroupInfo.getDisplayName() + this.a;
            if (this.b.length() > 0) {
                this.b = "\\" + this.b;
            }
            this.b = userGroupInfo.getDisplayName() + "\\" + userGroupInfo.getID().toString() + this.b;
            GUID gUID = userGroupInfo.getParentID();
            if (userGroupInfo.getID().equals(gUID)) {
                return;
            }
            if (gUID != null && (userGroupInfo2 = UserGroupManager.getRecoveryEnabledInstance().getGroup(gUID)) != null) {
                ++this.c;
                this.a(userGroupInfo2);
            }
        }
    }
}

