/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.takeout;

import com.inet.annotations.InternalApi;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.takeout.TakeoutDataRenderer;
import com.inet.usersandgroups.api.ui.fields.values.FieldValue;
import java.text.NumberFormat;
import java.util.Locale;

@InternalApi
public class DoubleTakeoutDataRenderer
implements TakeoutDataRenderer {
    @Override
    public String getExtensionName() {
        return "fieldtype_double";
    }

    @Override
    public String render(FieldValue fieldValue) {
        try {
            if (StringFunctions.isEmpty(fieldValue.getValue())) {
                return null;
            }
            double d2 = Double.parseDouble(fieldValue.getValue());
            Locale locale = Locale.getDefault(Locale.Category.FORMAT);
            NumberFormat numberFormat = NumberFormat.getInstance(locale);
            numberFormat.setMaximumFractionDigits(20);
            return numberFormat.format(d2);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

