/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.groups.persistence;

import com.inet.annotations.JsonData;
import com.inet.id.GUID;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceListener;
import com.inet.usersandgroups.api.groups.MembershipType;
import com.inet.usersandgroups.api.groups.UserGroupEventListener;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.persistence.UserGroupPersistence;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class UserGroupNodeSynchronizer
implements PersistenceListener<UserGroupNodeEvent>,
UserGroupEventListener {
    private UserGroupPersistence a;
    private Map<GUID, UserGroupInfo> b;

    public UserGroupNodeSynchronizer(UserGroupPersistence persistence, Map<GUID, UserGroupInfo> groupInfoMap) {
        this.a = persistence;
        this.b = groupInfoMap;
    }

    @Override
    public void eventReceived(@Nonnull UserGroupNodeEvent event) {
        UserGroupInfo userGroupInfo = this.a.load(event.id);
        if (userGroupInfo != null) {
            this.b.put(event.id, userGroupInfo);
        } else {
            this.b.remove(event.id);
        }
    }

    @Override
    public void groupCreated(@Nonnull UserGroupInfo groupInfo) {
        this.a(groupInfo);
    }

    @Override
    public void groupRenamed(@Nonnull String previousGroupName, @Nonnull UserGroupInfo groupInfo) {
        this.a(groupInfo);
    }

    @Override
    public void groupParentChanged(@Nonnull UserGroupInfo groupInfo) {
        this.a(groupInfo);
    }

    @Override
    public void groupDataUpdated(@Nonnull UserGroupInfo groupInfo) {
        this.a(groupInfo);
    }

    @Override
    public void groupMembersUpdated(@Nonnull UserGroupInfo groupInfo, @Nonnull Map<GUID, Set<MembershipType>> addedMemberships, @Nonnull Map<GUID, Set<MembershipType>> removedMemberships) {
        this.a(groupInfo);
    }

    @Override
    public void groupDeleted(@Nonnull UserGroupInfo groupInfo) {
        this.a(groupInfo);
    }

    @Override
    public void groupDeactivated(@Nonnull UserGroupInfo groupInfo) {
        this.a(groupInfo);
    }

    private void a(UserGroupInfo userGroupInfo) {
        GUID gUID = userGroupInfo.getID();
        if (gUID == null) {
            return;
        }
        UserGroupNodeEvent userGroupNodeEvent = new UserGroupNodeEvent();
        userGroupNodeEvent.id = gUID;
        Persistence.getInstance().sendEvent(userGroupNodeEvent);
    }

    @JsonData
    static class UserGroupNodeEvent {
        private GUID id;

        UserGroupNodeEvent() {
        }
    }
}

