/*
 * Decompiled with CFR 0.152.
 */
package com.inet.shared.utils;

import com.inet.annotations.InternalApi;
import com.inet.cache.PersistenceKey;
import com.inet.cache.image.SerializableImage;
import com.inet.logging.LogManager;
import com.inet.shared.utils.ColorUtilities;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.Graphics;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class BlendComposite
implements Composite {
    public static boolean ISDEBUG = false;
    public boolean throwWarning = false;
    private final float a;
    private BufferedImage b;
    @Nonnull
    private final BlendingMode c;
    private BufferedImage d;
    private Supplier<BufferedImage> e;

    public BlendComposite(@Nonnull BlendingMode mode) {
        this(mode, 1.0f);
    }

    public BlendComposite(@Nonnull BlendingMode mode, float alpha) throws IllegalArgumentException {
        this(mode, alpha, null);
    }

    public BlendComposite(@Nonnull BlendingMode mode, float alpha, BufferedImage smask) throws IllegalArgumentException {
        this.c = mode;
        if (alpha < 0.0f || alpha > 1.0f) {
            throw new IllegalArgumentException("alpha must be comprised between 0.0f and 1.0f");
        }
        this.a = alpha;
        this.b = smask;
    }

    public BufferedImage getMask() {
        return this.b;
    }

    public void setBackdrop(BufferedImage backdrop) {
        this.e = null;
        if (this.d != null) {
            this.d.flush();
        }
        this.d = backdrop;
    }

    public void setBackdropProvider(Supplier<BufferedImage> backdropProvider) {
        if (this.d != null) {
            this.d.flush();
        }
        this.e = backdropProvider;
    }

    public BufferedImage getBackdrop() {
        if (this.e != null) {
            this.d = this.e.get();
            this.e = null;
        }
        return this.d;
    }

    public static BlendComposite getInstance(@Nonnull BlendingMode mode) {
        return new BlendComposite(mode);
    }

    public static BlendComposite getInstance(@Nonnull BlendingMode mode, float alpha) {
        return new BlendComposite(mode, alpha);
    }

    private static boolean a(ColorModel colorModel) {
        if (colorModel instanceof DirectColorModel && colorModel.getTransferType() == 3) {
            DirectColorModel directColorModel = (DirectColorModel)colorModel;
            boolean bl = directColorModel.getRedMask() == 0xFF0000 && directColorModel.getGreenMask() == 65280 && directColorModel.getBlueMask() == 255 && (directColorModel.getNumComponents() != 4 || directColorModel.getAlphaMask() == -16777216);
            return bl;
        }
        return false;
    }

    public BlendComposite derive(@Nonnull BlendingMode mode) {
        if (this.getMode() == mode) {
            return this;
        }
        return new BlendComposite(mode, this.getAlpha());
    }

    public BlendComposite derive(int maskWidth, int maskHeight) {
        BufferedImage bufferedImage = this.getMask();
        if (bufferedImage == null || bufferedImage.getWidth() == maskWidth && bufferedImage.getHeight() == maskHeight) {
            return this;
        }
        return new BlendComposite(this.getMode(), this.a, new SerializableImage(bufferedImage.getScaledInstance(maskWidth, maskHeight, 4), null));
    }

    public BlendComposite derive(float alpha) {
        if (this.a == alpha) {
            return this;
        }
        if (alpha < 0.0f || alpha > 1.0f) {
            throw new IllegalArgumentException("alpha must be comprised between 0.0f and 1.0f");
        }
        return new BlendComposite(this.getMode(), alpha, this.getMask());
    }

    public float getAlpha() {
        return this.a;
    }

    @Nonnull
    public BlendingMode getMode() {
        return this.c;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.a) * 31 + this.c.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BlendComposite)) {
            return false;
        }
        BlendComposite blendComposite = (BlendComposite)obj;
        BufferedImage bufferedImage = this.getMask();
        if (this.c.hashCode() == blendComposite.c.hashCode() && this.a == blendComposite.a) {
            if (bufferedImage == null && blendComposite.b == null) {
                return true;
            }
            if (bufferedImage == null || blendComposite.b == null) {
                return false;
            }
            return bufferedImage.equals(blendComposite.b);
        }
        return false;
    }

    public void setMaskImage(BufferedImage image) {
        this.b = image;
    }

    @Override
    public CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
        if (!BlendComposite.a(srcColorModel)) {
            if (!this.throwWarning) {
                LogManager.getApplicationLogger().warn("Incompatible color models src = " + String.valueOf(srcColorModel));
                this.throwWarning = true;
            }
            return AlphaComposite.getInstance(3, this.a).createContext(srcColorModel, dstColorModel, hints);
        }
        if (!BlendComposite.a(dstColorModel)) {
            if (!this.throwWarning) {
                LogManager.getApplicationLogger().warn("Incompatible color models dst = " + String.valueOf(dstColorModel));
                this.throwWarning = true;
            }
            return AlphaComposite.getInstance(3, this.a).createContext(srcColorModel, dstColorModel, hints);
        }
        return new b(this);
    }

    public String toString() {
        return "BlendComposite{alpha=" + this.a + ", mode=" + String.valueOf((Object)this.c) + ", mask=" + this.a(this.getMask()) + ", backdrop=" + this.a(this.d) + "}";
    }

    @Nonnull
    private String a(@Nullable BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            return "<none>";
        }
        StringBuilder stringBuilder = new StringBuilder("width:");
        stringBuilder.append(bufferedImage.getWidth()).append("px, height:").append(bufferedImage.getHeight()).append("px");
        if (bufferedImage instanceof SerializableImage) {
            PersistenceKey persistenceKey = ((SerializableImage)bufferedImage).getPersistenceKey();
            stringBuilder.append(", key:").append(persistenceKey);
        }
        return stringBuilder.toString();
    }

    @InternalApi
    public static final class BlendingMode
    extends Enum<BlendingMode> {
        public static final /* enum */ BlendingMode AVERAGE = new BlendingMode(1);
        public static final /* enum */ BlendingMode MULTIPLY = new BlendingMode(2);
        public static final /* enum */ BlendingMode SCREEN = new BlendingMode(3);
        public static final /* enum */ BlendingMode DARKEN = new BlendingMode(4);
        public static final /* enum */ BlendingMode LIGHTEN = new BlendingMode(5);
        public static final /* enum */ BlendingMode OVERLAY = new BlendingMode(6);
        public static final /* enum */ BlendingMode HARD_LIGHT = new BlendingMode(7);
        public static final /* enum */ BlendingMode SOFT_LIGHT = new BlendingMode(8);
        public static final /* enum */ BlendingMode DIFFERENCE = new BlendingMode(9);
        public static final /* enum */ BlendingMode NEGATION = new BlendingMode(10);
        public static final /* enum */ BlendingMode EXCLUSION = new BlendingMode(11);
        public static final /* enum */ BlendingMode COLOR_DODGE = new BlendingMode(12);
        public static final /* enum */ BlendingMode INVERSE_COLOR_DODGE = new BlendingMode(13);
        public static final /* enum */ BlendingMode SOFT_DODGE = new BlendingMode(14);
        public static final /* enum */ BlendingMode COLOR_BURN = new BlendingMode(15);
        public static final /* enum */ BlendingMode INVERSE_COLOR_BURN = new BlendingMode(16);
        public static final /* enum */ BlendingMode SOFT_BURN = new BlendingMode(17);
        public static final /* enum */ BlendingMode REFLECT = new BlendingMode(18);
        public static final /* enum */ BlendingMode GLOW = new BlendingMode(19);
        public static final /* enum */ BlendingMode FREEZE = new BlendingMode(20);
        public static final /* enum */ BlendingMode HEAT = new BlendingMode(21);
        public static final /* enum */ BlendingMode ADD = new BlendingMode(22);
        public static final /* enum */ BlendingMode SUBTRACT = new BlendingMode(23);
        public static final /* enum */ BlendingMode STAMP = new BlendingMode(24);
        public static final /* enum */ BlendingMode RED = new BlendingMode(25);
        public static final /* enum */ BlendingMode GREEN = new BlendingMode(26);
        public static final /* enum */ BlendingMode BLUE = new BlendingMode(27);
        public static final /* enum */ BlendingMode HUE = new BlendingMode(28);
        public static final /* enum */ BlendingMode SATURATION = new BlendingMode(29);
        public static final /* enum */ BlendingMode COLOR = new BlendingMode(30);
        public static final /* enum */ BlendingMode LUMINOSITY = new BlendingMode(31);
        public static final /* enum */ BlendingMode NORMAL = new BlendingMode(32);
        public static final /* enum */ BlendingMode ADDALPHA = new BlendingMode(33);
        public static final /* enum */ BlendingMode WITHOUTALPHA = new BlendingMode(34);
        private final byte a;
        private static final /* synthetic */ BlendingMode[] b;

        public static BlendingMode[] values() {
            return (BlendingMode[])b.clone();
        }

        public static BlendingMode valueOf(String name) {
            return Enum.valueOf(BlendingMode.class, name);
        }

        private BlendingMode(int id) {
            this.a = (byte)id;
        }

        public byte getId() {
            return this.a;
        }

        public static BlendingMode getBlendingMode(byte id) {
            for (BlendingMode blendingMode : BlendingMode.values()) {
                if (blendingMode.getId() != id) continue;
                return blendingMode;
            }
            return NORMAL;
        }

        public String toString() {
            return "BlendingMode{mode=" + this.name() + "}";
        }

        private static /* synthetic */ BlendingMode[] a() {
            return new BlendingMode[]{AVERAGE, MULTIPLY, SCREEN, DARKEN, LIGHTEN, OVERLAY, HARD_LIGHT, SOFT_LIGHT, DIFFERENCE, NEGATION, EXCLUSION, COLOR_DODGE, INVERSE_COLOR_DODGE, SOFT_DODGE, COLOR_BURN, INVERSE_COLOR_BURN, SOFT_BURN, REFLECT, GLOW, FREEZE, HEAT, ADD, SUBTRACT, STAMP, RED, GREEN, BLUE, HUE, SATURATION, COLOR, LUMINOSITY, NORMAL, ADDALPHA, WITHOUTALPHA};
        }

        static {
            b = BlendingMode.a();
        }
    }

    private class b
    implements CompositeContext {
        private final a b;
        private final BlendComposite c;

        private b(BlendComposite blendComposite2) {
            this.c = blendComposite2;
            this.b = this.a(blendComposite2.getMode());
        }

        @Override
        public void dispose() {
        }

        @Override
        public void compose(Raster src, Raster dstIn, WritableRaster dstOut) {
            Object object;
            Object object2;
            int n2;
            int n3;
            int n4 = Math.min(src.getWidth(), dstIn.getWidth());
            int n5 = Math.min(src.getHeight(), dstIn.getHeight());
            float f2 = this.c.getAlpha();
            BufferedImage bufferedImage = this.c.getMask();
            BufferedImage bufferedImage2 = this.c.getBackdrop();
            WritableRaster writableRaster = null;
            WritableRaster writableRaster2 = null;
            if (bufferedImage != null) {
                n3 = Math.abs(dstIn.getSampleModelTranslateX());
                n2 = Math.abs(dstIn.getSampleModelTranslateY());
                if (bufferedImage.getWidth() >= n3 + n4 && bufferedImage.getHeight() >= n2 + n5) {
                    writableRaster = bufferedImage.getSubimage(n3, n2, n4, n5).getRaster();
                } else {
                    LogManager.getApplicationLogger().warn("Mask Image outside the range. Mask size is " + bufferedImage.getWidth() + "x" + bufferedImage.getHeight() + "\tMaxposition is " + (n3 + n4) + "(" + n4 + "):" + (n2 + n5) + "(" + n5 + ")\nSrc Bounds => " + String.valueOf(src.getBounds()) + "\tDst Bounds => " + String.valueOf(dstIn.getBounds()) + "\n" + Arrays.toString(Thread.currentThread().getStackTrace()));
                    object2 = new BufferedImage(n4, n5, 2);
                    ((BufferedImage)object2).createGraphics().drawImage(bufferedImage, n3, n2, bufferedImage.getWidth() - n3, bufferedImage.getHeight() - n2, null);
                    writableRaster = ((BufferedImage)object2).getRaster();
                }
            }
            if (bufferedImage2 != null) {
                n3 = Math.abs(dstIn.getSampleModelTranslateX());
                n2 = Math.abs(dstIn.getSampleModelTranslateY());
                if (bufferedImage2.getWidth() >= n3 + n4 && bufferedImage2.getHeight() >= n2 + n5) {
                    writableRaster2 = bufferedImage2.getSubimage(n3, n2, n4, n5).getRaster();
                } else if (bufferedImage2.getWidth() > n3 || bufferedImage2.getHeight() > n2) {
                    if (ISDEBUG) {
                        LogManager.getApplicationLogger().warn("Backdrop Image outside the range. Mask size is " + bufferedImage2.getWidth() + "x" + bufferedImage2.getHeight() + "\tMaxposition is " + (n3 + n4) + "(" + n4 + "):" + (n2 + n5) + "(" + n5 + ")\nSrc Bounds => " + String.valueOf(src.getBounds()) + "\tDst Bounds => " + String.valueOf(dstIn.getBounds()) + "\n" + Arrays.toString(Thread.currentThread().getStackTrace()));
                    }
                } else {
                    if (ISDEBUG) {
                        LogManager.getApplicationLogger().warn("Backdrop Image outside the range. Mask size is " + bufferedImage2.getWidth() + "x" + bufferedImage2.getHeight() + "\tMaxposition is " + (n3 + n4) + "(" + n4 + "):" + (n2 + n5) + "(" + n5 + ")\nSrc Bounds => " + String.valueOf(src.getBounds()) + "\tDst Bounds => " + String.valueOf(dstIn.getBounds()) + "\n" + Arrays.toString(Thread.currentThread().getStackTrace()));
                    }
                    object2 = new BufferedImage(n4 + n3, n5 + n2, 2);
                    object = ((BufferedImage)object2).createGraphics();
                    ((Graphics)object).drawImage(bufferedImage2, 0, 0, null);
                    ((Graphics)object).dispose();
                    writableRaster2 = ((BufferedImage)object2).getSubimage(n3, n2, n4, n5).getRaster();
                }
            }
            int[] nArray = new int[4];
            int[] nArray2 = new int[4];
            object2 = new int[4];
            object = new int[]{0, 0, 0, 255};
            int[] nArray3 = new int[n4];
            int[] nArray4 = new int[n4];
            int[] nArray5 = new int[n4];
            float f3 = 1.0f;
            float f4 = 1.0f;
            boolean bl = src.getNumBands() > 3;
            boolean bl2 = dstIn.getNumBands() > 3;
            for (int i2 = 0; i2 < n5; ++i2) {
                src.getDataElements(0, i2, n4, 1, nArray3);
                dstIn.getDataElements(0, i2, n4, 1, nArray4);
                if (writableRaster2 != null) {
                    writableRaster2.getDataElements(0, i2, n4, 1, nArray5);
                }
                for (int i3 = 0; i3 < n4; ++i3) {
                    float f5;
                    int n6 = nArray3[i3];
                    nArray2[0] = n6 >> 16 & 0xFF;
                    nArray2[1] = n6 >> 8 & 0xFF;
                    nArray2[2] = n6 & 0xFF;
                    nArray2[3] = bl ? n6 >> 24 & 0xFF : 255;
                    n6 = writableRaster2 != null && nArray2[3] != 0 ? nArray5[i3] : nArray4[i3];
                    object2[0] = n6 >> 16 & 0xFF;
                    object2[1] = n6 >> 8 & 0xFF;
                    object2[2] = n6 & 0xFF;
                    object2[3] = bl2 ? n6 >> 24 & 0xFF : 255;
                    if (this.c.getMode() == BlendingMode.NORMAL) {
                        nArray = nArray2;
                    } else {
                        this.b.a(nArray2, (int[])object2, nArray);
                    }
                    if (writableRaster != null) {
                        writableRaster.getPixel(i3, i2, (int[])object);
                        if (nArray2[3] != 0) {
                            nArray2[3] = (int)object[3];
                        }
                    }
                    if ((f5 = f2 * (float)nArray2[3] * (float)object2[3]) == 65535.0f) {
                        nArray4[i3] = (object[3] & 0xFF) << 24 | (nArray[0] & 0xFF) << 16 | (nArray[1] & 0xFF) << 8 | nArray[2] & 0xFF;
                        continue;
                    }
                    f3 = (float)nArray2[3] / 255.0f * f2;
                    f4 = (float)object2[3] / 255.0f;
                    nArray4[i3] = f3 != 1.0f ? (this.a(f3, f4) & 0xFF) << 24 | (this.a(f3, f4, (int)object2[0], nArray[0]) & 0xFF) << 16 | (this.a(f3, f4, (int)object2[1], nArray[1]) & 0xFF) << 8 | this.a(f3, f4, (int)object2[2], nArray[2]) & 0xFF : (Math.round(255.0f * f3) & 0xFF) << 24 | (nArray[0] & 0xFF) << 16 | (nArray[1] & 0xFF) << 8 | nArray[2] & 0xFF;
                }
                dstOut.setDataElements(0, i2, n4, 1, nArray4);
            }
        }

        private int a(float f2, float f3, int n2, int n3) {
            return Math.round(1.0f / (f2 + (1.0f - f2) * f3) * (f2 * (float)n3 + (1.0f - f2) * f3 * (float)n2));
        }

        private int a(float f2, float f3) {
            return Math.round(255.0f * (f2 + (1.0f - f2) * f3));
        }

        private a a(BlendingMode blendingMode) {
            switch (blendingMode) {
                case NORMAL: {
                    return new a(){

                        @Override
                        public void a(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = nArray[0];
                            nArray3[1] = nArray[1];
                            nArray3[2] = nArray[2];
                            nArray3[3] = nArray[3];
                        }
                    };
                }
                case HARD_LIGHT: {
                    return new a(){

                        @Override
                        public void a(int[] nArray, int[] nArray2, int[] nArray3) {
                            if (!b.this.a(nArray, nArray2, nArray3)) {
                                nArray3[0] = nArray[0] < 128 ? nArray2[0] * nArray[0] >> 7 : 255 - ((255 - nArray[0]) * (255 - nArray2[0]) >> 7);
                                nArray3[1] = nArray[1] < 128 ? nArray2[1] * nArray[1] >> 7 : 255 - ((255 - nArray[1]) * (255 - nArray2[1]) >> 7);
                                nArray3[2] = nArray[2] < 128 ? nArray2[2] * nArray[2] >> 7 : 255 - ((255 - nArray[2]) * (255 - nArray2[2]) >> 7);
                                nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                            }
                        }
                    };
                }
                case MULTIPLY: {
                    return new a(){

                        @Override
                        public void a(int[] nArray, int[] nArray2, int[] nArray3) {
                            if (!b.this.a(nArray, nArray2, nArray3)) {
                                nArray3[0] = nArray[0] * nArray2[0] >> 8;
                                nArray3[1] = nArray[1] * nArray2[1] >> 8;
                                nArray3[2] = nArray[2] * nArray2[2] >> 8;
                                nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                            }
                        }
                    };
                }
                case SOFT_LIGHT: {
                    return new a(){

                        @Override
                        public void a(int[] nArray, int[] nArray2, int[] nArray3) {
                            if (!b.this.a(nArray, nArray2, nArray3)) {
                                int n2 = nArray[0] * nArray2[0] / 255;
                                int n3 = nArray[1] * nArray2[1] / 255;
                                int n4 = nArray[2] * nArray2[2] / 255;
                                nArray3[0] = n2 + nArray2[0] * (255 - (255 - nArray2[0]) * (255 - nArray[0]) / 255 - n2) / 255;
                                nArray3[1] = n3 + nArray2[1] * (255 - (255 - nArray2[1]) * (255 - nArray[1]) / 255 - n3) / 255;
                                nArray3[2] = n4 + nArray2[2] * (255 - (255 - nArray2[2]) * (255 - nArray[2]) / 255 - n4) / 255;
                            }
                        }
                    };
                }
                case SCREEN: {
                    return new a(){

                        @Override
                        public void a(int[] nArray, int[] nArray2, int[] nArray3) {
                            if (!b.this.a(nArray, nArray2, nArray3)) {
                                if (nArray[0] == 255 && nArray[1] == 255 && nArray[2] == 255 || nArray2[0] == 255 && nArray2[1] == 255 && nArray2[2] == 255) {
                                    Arrays.fill(nArray3, 255);
                                } else if (nArray[0] == 0 && nArray[1] == 0 && nArray[2] == 0) {
                                    for (int i2 = 0; i2 < nArray3.length; ++i2) {
                                        nArray3[i2] = nArray2[i2];
                                    }
                                } else {
                                    nArray3[0] = 255 - ((255 - nArray[0]) * (255 - nArray2[0]) >> 8);
                                    nArray3[1] = 255 - ((255 - nArray[1]) * (255 - nArray2[1]) >> 8);
                                    nArray3[2] = 255 - ((255 - nArray[2]) * (255 - nArray2[2]) >> 8);
                                    nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                                }
                            }
                        }
                    };
                }
                case DIFFERENCE: {
                    return new a(){

                        @Override
                        public void a(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = Math.abs(nArray2[0] - nArray[0]);
                            nArray3[1] = Math.abs(nArray2[1] - nArray[1]);
                            nArray3[2] = Math.abs(nArray2[2] - nArray[2]);
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case OVERLAY: {
                    return new a(){

                        @Override
                        public void a(int[] nArray, int[] nArray2, int[] nArray3) {
                            if (!b.this.a(nArray, nArray2, nArray3)) {
                                nArray3[0] = nArray2[0] < 128 ? nArray2[0] * nArray[0] >> 7 : 255 - ((255 - nArray2[0]) * (255 - nArray[0]) >> 7);
                                nArray3[1] = nArray2[1] < 128 ? nArray2[1] * nArray[1] >> 7 : 255 - ((255 - nArray2[1]) * (255 - nArray[1]) >> 7);
                                nArray3[2] = nArray2[2] < 128 ? nArray2[2] * nArray[2] >> 7 : 255 - ((255 - nArray2[2]) * (255 - nArray[2]) >> 7);
                                nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                            }
                        }
                    };
                }
                case EXCLUSION: {
                    return new a(){

                        @Override
                        public void a(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = nArray2[0] + nArray[0] - (nArray2[0] * nArray[0] >> 7);
                            nArray3[1] = nArray2[1] + nArray[1] - (nArray2[1] * nArray[1] >> 7);
                            nArray3[2] = nArray2[2] + nArray[2] - (nArray2[2] * nArray[2] >> 7);
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case DARKEN: {
                    return new a(){

                        @Override
                        public void a(int[] nArray, int[] nArray2, int[] nArray3) {
                            if (!b.this.a(nArray, nArray2, nArray3)) {
                                nArray3[0] = Math.min(nArray[0], nArray2[0]);
                                nArray3[1] = Math.min(nArray[1], nArray2[1]);
                                nArray3[2] = Math.min(nArray[2], nArray2[2]);
                                nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                            }
                        }
                    };
                }
                case HUE: {
                    return new a(){

                        @Override
                        public void a(int[] nArray, int[] nArray2, int[] nArray3) {
                            if (!b.this.a(nArray, nArray2, nArray3)) {
                                float[] fArray = new float[3];
                                ColorUtilities.a(nArray[0], nArray[1], nArray[2], fArray);
                                float[] fArray2 = new float[3];
                                ColorUtilities.a(nArray2[0], nArray2[1], nArray2[2], fArray2);
                                ColorUtilities.a(fArray[0], fArray2[1], fArray2[2], nArray3);
                                nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                            }
                        }
                    };
                }
                case LIGHTEN: {
                    return new a(){

                        @Override
                        public void a(int[] nArray, int[] nArray2, int[] nArray3) {
                            if (!b.this.a(nArray, nArray2, nArray3)) {
                                nArray3[0] = Math.max(nArray[0], nArray2[0]);
                                nArray3[1] = Math.max(nArray[1], nArray2[1]);
                                nArray3[2] = Math.max(nArray[2], nArray2[2]);
                                nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                            }
                        }
                    };
                }
                case SATURATION: {
                    return new a(){

                        @Override
                        public void a(int[] nArray, int[] nArray2, int[] nArray3) {
                            if (!b.this.a(nArray, nArray2, nArray3)) {
                                float[] fArray = new float[3];
                                ColorUtilities.a(nArray[0], nArray[1], nArray[2], fArray);
                                float[] fArray2 = new float[3];
                                ColorUtilities.a(nArray2[0], nArray2[1], nArray2[2], fArray2);
                                ColorUtilities.a(fArray2[0], fArray[1], fArray2[2], nArray3);
                                nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                            }
                        }
                    };
                }
                case COLOR_DODGE: {
                    return new a(){

                        @Override
                        public void a(int[] nArray, int[] nArray2, int[] nArray3) {
                            if (!b.this.a(nArray, nArray2, nArray3)) {
                                if (nArray2[0] == 0 && nArray2[1] == 0 && nArray2[2] == 0) {
                                    for (int i2 = 0; i2 < nArray3.length; ++i2) {
                                        nArray3[i2] = nArray2[i2];
                                    }
                                } else {
                                    nArray3[0] = nArray[0] == 255 ? 255 : Math.min((nArray2[0] << 8) / (255 - nArray[0]), 255);
                                    nArray3[1] = nArray[1] == 255 ? 255 : Math.min((nArray2[1] << 8) / (255 - nArray[1]), 255);
                                    nArray3[2] = nArray[2] == 255 ? 255 : Math.min((nArray2[2] << 8) / (255 - nArray[2]), 255);
                                    nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                                }
                            }
                        }
                    };
                }
                case COLOR: {
                    return new a(){

                        @Override
                        public void a(int[] nArray, int[] nArray2, int[] nArray3) {
                            if (!b.this.a(nArray, nArray2, nArray3)) {
                                float[] fArray = new float[3];
                                ColorUtilities.a(nArray[0], nArray[1], nArray[2], fArray);
                                float[] fArray2 = new float[3];
                                ColorUtilities.a(nArray2[0], nArray2[1], nArray2[2], fArray2);
                                ColorUtilities.a(fArray[0], fArray[1], fArray2[2], nArray3);
                                nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                            }
                        }
                    };
                }
                case COLOR_BURN: {
                    return new a(){

                        @Override
                        public void a(int[] nArray, int[] nArray2, int[] nArray3) {
                            if (!b.this.a(nArray, nArray2, nArray3)) {
                                if (nArray2[0] == 255 && nArray2[1] == 255 && nArray2[2] == 255) {
                                    for (int i2 = 0; i2 < nArray3.length; ++i2) {
                                        nArray3[i2] = nArray2[i2];
                                    }
                                } else {
                                    nArray3[0] = nArray[0] == 0 ? 0 : Math.max(0, 255 - (255 - nArray2[0] << 8) / nArray[0]);
                                    nArray3[1] = nArray[1] == 0 ? 0 : Math.max(0, 255 - (255 - nArray2[1] << 8) / nArray[1]);
                                    nArray3[2] = nArray[2] == 0 ? 0 : Math.max(0, 255 - (255 - nArray2[2] << 8) / nArray[2]);
                                    nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                                }
                            }
                        }
                    };
                }
                case LUMINOSITY: {
                    return new a(){

                        @Override
                        public void a(int[] nArray, int[] nArray2, int[] nArray3) {
                            if (!b.this.a(nArray, nArray2, nArray3)) {
                                float[] fArray = new float[3];
                                float[] fArray2 = new float[3];
                                ColorUtilities.a(nArray[0], nArray[1], nArray[2], fArray);
                                ColorUtilities.a(nArray2[0], nArray2[1], nArray2[2], fArray2);
                                ColorUtilities.a(fArray2[0], fArray2[1], fArray[2], nArray3);
                                nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                            }
                        }
                    };
                }
                case ADDALPHA: {
                    return new a(){

                        @Override
                        public void a(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = Math.min(255, nArray2[0]);
                            nArray3[1] = Math.min(255, nArray2[1]);
                            nArray3[2] = Math.min(255, nArray2[2]);
                            nArray3[3] = Math.min(255, nArray[3]);
                        }
                    };
                }
                case WITHOUTALPHA: {
                    return new a(){

                        @Override
                        public void a(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = Math.min(255, nArray[0]);
                            nArray3[1] = Math.min(255, nArray[1]);
                            nArray3[2] = Math.min(255, nArray[2]);
                            nArray3[3] = Math.min(255, nArray[3]);
                        }
                    };
                }
                case ADD: {
                    return new a(){

                        @Override
                        public void a(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = Math.min(255, nArray[0] + nArray2[0]);
                            nArray3[1] = Math.min(255, nArray[1] + nArray2[1]);
                            nArray3[2] = Math.min(255, nArray[2] + nArray2[2]);
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3]);
                        }
                    };
                }
                case AVERAGE: {
                    return new a(){

                        @Override
                        public void a(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = nArray[0] + nArray2[0] >> 1;
                            nArray3[1] = nArray[1] + nArray2[1] >> 1;
                            nArray3[2] = nArray[2] + nArray2[2] >> 1;
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case BLUE: {
                    return new a(){

                        @Override
                        public void a(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = nArray2[0];
                            nArray3[1] = nArray[1];
                            nArray3[2] = nArray2[2];
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case FREEZE: {
                    return new a(){

                        @Override
                        public void a(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = nArray[0] == 0 ? 0 : Math.max(0, 255 - (255 - nArray2[0]) * (255 - nArray2[0]) / nArray[0]);
                            nArray3[1] = nArray[1] == 0 ? 0 : Math.max(0, 255 - (255 - nArray2[1]) * (255 - nArray2[1]) / nArray[1]);
                            nArray3[2] = nArray[2] == 0 ? 0 : Math.max(0, 255 - (255 - nArray2[2]) * (255 - nArray2[2]) / nArray[2]);
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case GLOW: {
                    return new a(){

                        @Override
                        public void a(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = nArray2[0] == 255 ? 255 : Math.min(255, nArray[0] * nArray[0] / (255 - nArray2[0]));
                            nArray3[1] = nArray2[1] == 255 ? 255 : Math.min(255, nArray[1] * nArray[1] / (255 - nArray2[1]));
                            nArray3[2] = nArray2[2] == 255 ? 255 : Math.min(255, nArray[2] * nArray[2] / (255 - nArray2[2]));
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case GREEN: {
                    return new a(){

                        @Override
                        public void a(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = nArray2[0];
                            nArray3[1] = nArray2[1];
                            nArray3[2] = nArray[2];
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case HEAT: {
                    return new a(){

                        @Override
                        public void a(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = nArray2[0] == 0 ? 0 : Math.max(0, 255 - (255 - nArray[0]) * (255 - nArray[0]) / nArray2[0]);
                            nArray3[1] = nArray2[1] == 0 ? 0 : Math.max(0, 255 - (255 - nArray[1]) * (255 - nArray[1]) / nArray2[1]);
                            nArray3[2] = nArray2[2] == 0 ? 0 : Math.max(0, 255 - (255 - nArray[2]) * (255 - nArray[2]) / nArray2[2]);
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case INVERSE_COLOR_BURN: {
                    return new a(){

                        @Override
                        public void a(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = nArray2[0] == 0 ? 0 : Math.max(0, 255 - (255 - nArray[0] << 8) / nArray2[0]);
                            nArray3[1] = nArray2[1] == 0 ? 0 : Math.max(0, 255 - (255 - nArray[1] << 8) / nArray2[1]);
                            nArray3[2] = nArray2[2] == 0 ? 0 : Math.max(0, 255 - (255 - nArray[2] << 8) / nArray2[2]);
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case INVERSE_COLOR_DODGE: {
                    return new a(){

                        @Override
                        public void a(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = nArray2[0] == 255 ? 255 : Math.min((nArray[0] << 8) / (255 - nArray2[0]), 255);
                            nArray3[1] = nArray2[1] == 255 ? 255 : Math.min((nArray[1] << 8) / (255 - nArray2[1]), 255);
                            nArray3[2] = nArray2[2] == 255 ? 255 : Math.min((nArray[2] << 8) / (255 - nArray2[2]), 255);
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case NEGATION: {
                    return new a(){

                        @Override
                        public void a(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = 255 - Math.abs(255 - nArray2[0] - nArray[0]);
                            nArray3[1] = 255 - Math.abs(255 - nArray2[1] - nArray[1]);
                            nArray3[2] = 255 - Math.abs(255 - nArray2[2] - nArray[2]);
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case RED: {
                    return new a(){

                        @Override
                        public void a(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = nArray[0];
                            nArray3[1] = nArray2[1];
                            nArray3[2] = nArray2[2];
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case REFLECT: {
                    return new a(){

                        @Override
                        public void a(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = nArray[0] == 255 ? 255 : Math.min(255, nArray2[0] * nArray2[0] / (255 - nArray[0]));
                            nArray3[1] = nArray[1] == 255 ? 255 : Math.min(255, nArray2[1] * nArray2[1] / (255 - nArray[1]));
                            nArray3[2] = nArray[2] == 255 ? 255 : Math.min(255, nArray2[2] * nArray2[2] / (255 - nArray[2]));
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case SOFT_BURN: {
                    return new a(){

                        @Override
                        public void a(int[] nArray, int[] nArray2, int[] nArray3) {
                            int n2 = nArray2[0] + nArray[0] < 256 ? (nArray2[0] == 255 ? 255 : Math.min(255, (nArray[0] << 7) / (255 - nArray2[0]))) : (nArray3[0] = Math.max(0, 255 - (255 - nArray2[0] << 7) / nArray[0]));
                            int n3 = nArray2[1] + nArray[1] < 256 ? (nArray2[1] == 255 ? 255 : Math.min(255, (nArray[1] << 7) / (255 - nArray2[1]))) : (nArray3[1] = Math.max(0, 255 - (255 - nArray2[1] << 7) / nArray[1]));
                            nArray3[2] = nArray2[2] + nArray[2] < 256 ? (nArray2[2] == 255 ? 255 : Math.min(255, (nArray[2] << 7) / (255 - nArray2[2]))) : Math.max(0, 255 - (255 - nArray2[2] << 7) / nArray[2]);
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case SOFT_DODGE: {
                    return new a(){

                        @Override
                        public void a(int[] nArray, int[] nArray2, int[] nArray3) {
                            int n2 = nArray2[0] + nArray[0] < 256 ? (nArray[0] == 255 ? 255 : Math.min(255, (nArray2[0] << 7) / (255 - nArray[0]))) : (nArray3[0] = Math.max(0, 255 - (255 - nArray[0] << 7) / nArray2[0]));
                            int n3 = nArray2[1] + nArray[1] < 256 ? (nArray[1] == 255 ? 255 : Math.min(255, (nArray2[1] << 7) / (255 - nArray[1]))) : (nArray3[1] = Math.max(0, 255 - (255 - nArray[1] << 7) / nArray2[1]));
                            nArray3[2] = nArray2[2] + nArray[2] < 256 ? (nArray[2] == 255 ? 255 : Math.min(255, (nArray2[2] << 7) / (255 - nArray[2]))) : Math.max(0, 255 - (255 - nArray[2] << 7) / nArray2[2]);
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case STAMP: {
                    return new a(){

                        @Override
                        public void a(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = Math.max(0, Math.min(255, nArray2[0] + 2 * nArray[0] - 256));
                            nArray3[1] = Math.max(0, Math.min(255, nArray2[1] + 2 * nArray[1] - 256));
                            nArray3[2] = Math.max(0, Math.min(255, nArray2[2] + 2 * nArray[2] - 256));
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case SUBTRACT: {
                    return new a(){

                        @Override
                        public void a(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = Math.max(0, nArray[0] + nArray2[0] - 256);
                            nArray3[1] = Math.max(0, nArray[1] + nArray2[1] - 256);
                            nArray3[2] = Math.max(0, nArray[2] + nArray2[2] - 256);
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
            }
            throw new IllegalArgumentException("Blender not implemented for " + blendingMode.name());
        }

        private boolean a(int[] nArray, int[] nArray2, int[] nArray3) {
            if (nArray2[3] == 0) {
                nArray3[0] = nArray[0];
                nArray3[1] = nArray[1];
                nArray3[2] = nArray[2];
                nArray3[3] = nArray[3];
            } else if (nArray[3] == 0) {
                nArray3[0] = nArray2[0];
                nArray3[1] = nArray2[1];
                nArray3[2] = nArray2[2];
                nArray3[3] = nArray2[3];
            } else {
                return false;
            }
            return true;
        }
    }

    private static interface a {
        public void a(int[] var1, int[] var2, int[] var3);
    }
}

