/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.image;

import com.inet.classloader.I18nMessages;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.http.ClientMessageException;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.ApplicationDescription;
import com.inet.plugin.RemoteGuiInformation;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.image.ProductLogoProvider;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.HashMap;
import javax.annotation.SuppressFBWarnings;
import javax.imageio.ImageIO;

public class ProductLogoGenerator {
    private static final ConfigValue<String> a = new ConfigValue(ConfigKey.IMPRINT_LOGO_URL);
    private static final ConfigValue<Boolean> b = new ConfigValue(ConfigKey.IMPRINT_LOGO_WITH_TEXT);
    private static HashMap<Integer, byte[]> c = new HashMap();
    private static HashMap<Integer, byte[]> d = new HashMap();
    private static HashMap<Integer, byte[]> e = new HashMap();
    private static String f = null;
    private static String g = null;
    private static Boolean h = null;
    public static final I18nMessages MSG = new I18nMessages("com.inet.plugin.i18n.PluginCategories", ProductLogoGenerator.class);

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Caller must check it")
    public static byte[] getLogo(String providedLogoURL, String title, int targetHeight, boolean icononly, boolean inverseTextColor, boolean vendorLogo, boolean fallbackToGenerated, boolean cacheLogo, boolean includePadding) {
        URL uRL = null;
        if (!vendorLogo) {
            String string = providedLogoURL;
            if (string == null) {
                string = a.get();
                if (!icononly && cacheLogo && !b.get().booleanValue()) {
                    icononly = true;
                }
            }
            if (!StringFunctions.isEmpty(string)) {
                Object object;
                URL uRL2 = IOFunctions.getURLFromString(string);
                if ("http".equals(uRL2.getProtocol()) || "https".equals(uRL2.getProtocol()) || "file".equals(uRL2.getProtocol()) || "data".equals(uRL2.getProtocol()) && uRL2.getFile().toString().startsWith("image")) {
                    uRL = uRL2;
                }
                try {
                    if ("data:dummy".equals(uRL2.toString())) {
                        object = Persistence.getRecoveryEnabledInstance().resolve("config_logo_file").getString();
                        uRL = new URL((String)object);
                    } else {
                        object = Paths.get(string, new String[0]);
                        if (!object.isAbsolute()) {
                            PersistenceEntry persistenceEntry = Persistence.getInstance().resolve(string);
                            if (persistenceEntry.exists()) {
                                uRL = persistenceEntry.toURL();
                            }
                        } else if (object.toFile().exists()) {
                            uRL = object.toUri().toURL();
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (uRL == null) {
                    try {
                        object = Paths.get(string, new String[0]);
                        if (object.toFile().isFile()) {
                            uRL = IOFunctions.getFileURL(string);
                        }
                    }
                    catch (IOException iOException) {
                        LogManager.getApplicationLogger().debug(iOException);
                    }
                }
            }
            if (uRL == null && !fallbackToGenerated) {
                return null;
            }
        }
        return ProductLogoGenerator.generateProductLogo(uRL, title, targetHeight, icononly, inverseTextColor, vendorLogo, cacheLogo, includePadding);
    }

    public static byte[] generateProductLogo(URL logoURL, String title, int targetHeight, boolean icononly, boolean inverseTextColor, boolean vendorLogo, boolean cacheLogo, boolean includePadding) {
        try {
            byte[] byArray;
            boolean bl;
            ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
            ApplicationDescription applicationDescription = ApplicationDescription.get();
            RemoteGuiInformation remoteGuiInformation = applicationDescription.getRemoteGuiInformation();
            boolean bl2 = bl = logoURL != null;
            if (logoURL == null) {
                logoURL = remoteGuiInformation.getLogoURL();
            }
            if (title == null) {
                title = remoteGuiInformation.getTitle();
            }
            if (StringFunctions.isEmpty(title)) {
                title = applicationDescription.getApplicationName();
            }
            HashMap<Integer, byte[]> hashMap = c;
            if (cacheLogo) {
                if (f == null || !f.equals(title)) {
                    c.clear();
                    f = title;
                }
                if (!(logoURL == null || g != null && g.equals(logoURL.toString()))) {
                    c.clear();
                    e.clear();
                    g = logoURL.toString();
                }
                if (h == null || h != icononly) {
                    c.clear();
                    e.clear();
                    h = icononly;
                }
            }
            if (vendorLogo) {
                title = applicationDescription.getApplicationName();
                hashMap = d;
            }
            int n2 = (int)Math.floor((float)targetHeight * (!includePadding && icononly ? 1.0f : 0.75f));
            BufferedImage bufferedImage = null;
            ProductLogoProvider productLogoProvider = serverPluginManager.getOptionalInstance(ProductLogoProvider.class);
            if (productLogoProvider != null && !bl) {
                bufferedImage = productLogoProvider.provideLogo(title, n2, icononly, inverseTextColor);
            }
            if (logoURL != null && icononly || bufferedImage != null) {
                byte[] byArray2;
                byte[] byArray3 = byArray2 = cacheLogo ? e.get(targetHeight) : null;
                if (byArray2 == null) {
                    int n3;
                    Image image;
                    if (bufferedImage != null) {
                        image = bufferedImage;
                        n3 = bufferedImage.getWidth();
                    } else {
                        BufferedImage bufferedImage2 = ImageIO.read(logoURL);
                        if (bufferedImage2 == null) {
                            throw new ClientMessageException(MSG.getMsg("productlogogenerator.unsupportedFile", new Object[0]));
                        }
                        n3 = (int)Math.round((double)bufferedImage2.getWidth() / (double)bufferedImage2.getHeight() * (double)n2);
                        image = bufferedImage2.getScaledInstance(n3, n2, 4);
                    }
                    int n4 = (targetHeight - n2) / 2;
                    int n5 = n3 + n4 * 2;
                    BufferedImage bufferedImage3 = ProductLogoGenerator.a(n5, targetHeight);
                    Graphics2D graphics2D = (Graphics2D)bufferedImage3.getGraphics();
                    ProductLogoGenerator.a(graphics2D);
                    graphics2D.drawImage(image, n4, n4, n3, n2, null);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)bufferedImage3, "PNG", byteArrayOutputStream);
                    byArray2 = byteArrayOutputStream.toByteArray();
                    if (cacheLogo) {
                        e.put(targetHeight, byArray2);
                    }
                }
                return byArray2;
            }
            Integer n6 = targetHeight * (inverseTextColor ? -1 : 1);
            byte[] byArray4 = byArray = cacheLogo ? hashMap.get(n6) : null;
            if (byArray == null && logoURL != null) {
                Object object;
                BufferedImage bufferedImage4 = ProductLogoGenerator.a(targetHeight * 7, targetHeight);
                Graphics2D graphics2D = (Graphics2D)bufferedImage4.getGraphics();
                ProductLogoGenerator.a(graphics2D);
                Font font = graphics2D.getFont();
                font = font.deriveFont(3);
                TextLayout textLayout = new TextLayout(title, font, graphics2D.getFontRenderContext());
                Rectangle2D rectangle2D = textLayout.getBounds();
                double d2 = bufferedImage4.getWidth(null);
                double d3 = bufferedImage4.getHeight(null);
                float f2 = Math.min(bufferedImage4.getHeight(), n2);
                while (d2 >= (double)(bufferedImage4.getWidth(null) - targetHeight) * 0.95 || d3 >= (double)bufferedImage4.getHeight(null) * 0.8) {
                    font = font.deriveFont(f2 -= 1.0f);
                    textLayout = new TextLayout(title, font, graphics2D.getFontRenderContext());
                    object = textLayout.getBounds();
                    Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, -textLayout.getAscent() - textLayout.getLeading() * 2.0f, textLayout.getAdvance(), textLayout.getAscent() + textLayout.getDescent() + 2.0f * textLayout.getLeading());
                    rectangle2D = ((Rectangle2D)float_).createUnion((Rectangle2D)object);
                    d2 = rectangle2D.getWidth();
                    d3 = rectangle2D.getHeight();
                }
                object = ImageIO.read(logoURL);
                if (object == null) {
                    throw new ClientMessageException(MSG.getMsg("productlogogenerator.unsupportedFile", new Object[0]));
                }
                int n7 = (int)Math.round((double)((BufferedImage)object).getWidth() / (double)((BufferedImage)object).getHeight() * (double)n2);
                Image image = ((Image)object).getScaledInstance(n7, n2, 4);
                int n8 = (targetHeight - n2) / 2;
                int n9 = (int)Math.ceil(d2 / 0.95 + (double)n7 + (double)(n8 * 2));
                bufferedImage4 = ProductLogoGenerator.a(n9, targetHeight);
                graphics2D = (Graphics2D)bufferedImage4.getGraphics();
                ProductLogoGenerator.a(graphics2D);
                graphics2D.drawImage(image, n8, n8, n7, n2, null);
                graphics2D.setFont(font);
                int n10 = (int)((double)(bufferedImage4.getHeight(null) / 2) + d3 / 2.0 - (double)textLayout.getDescent() - (double)(textLayout.getLeading() * 2.0f));
                graphics2D.setColor(inverseTextColor ? Color.BLACK : Color.WHITE);
                graphics2D.drawString(title, n7 + n8 * 2, n10);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage4, "PNG", byteArrayOutputStream);
                byArray = byteArrayOutputStream.toByteArray();
                if (cacheLogo) {
                    hashMap.put(n6, byArray);
                }
            }
            return byArray;
        }
        catch (ClientMessageException clientMessageException) {
            LogManager.getApplicationLogger().debug(clientMessageException);
            throw clientMessageException;
        }
        catch (Throwable throwable) {
            LogManager.getApplicationLogger().warn(throwable);
            throw new ClientMessageException(StringFunctions.getUserFriendlyErrorMessage(throwable));
        }
    }

    private static BufferedImage a(int n2, int n3) {
        return new BufferedImage(n2, n3, 2);
    }

    private static void a(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    }
}

