/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.fs;

import com.inet.annotations.InternalApi;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.fs.ArchiveFile;
import com.inet.plugin.fs.ResourceFile;
import com.inet.plugin.fs.UrlArchiveFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.zip.ZipException;
import javax.annotation.Nonnull;

@InternalApi
public class PersistenceResourceFile
implements ResourceFile {
    private final PersistenceEntry a;

    public PersistenceResourceFile(PersistenceEntry entry) {
        this.a = entry;
    }

    public PersistenceEntry getEntry() {
        return this.a;
    }

    @Override
    public PersistenceResourceFile createChild(@Nonnull String child) {
        return new PersistenceResourceFile(this.a.resolve(child));
    }

    @Override
    public String getName() {
        return this.a.getName();
    }

    @Override
    public boolean isDirectory() {
        return this.a.getChildren().size() > 0;
    }

    @Override
    public boolean exists() {
        return this.a.exists();
    }

    @Override
    public String getAbsolutePath() {
        return this.a.getPath();
    }

    @Override
    public ResourceFile[] listFiles() {
        List<PersistenceEntry> list = this.a.getChildren();
        ResourceFile[] resourceFileArray = new ResourceFile[list.size()];
        for (int i2 = 0; i2 < resourceFileArray.length; ++i2) {
            resourceFileArray[i2] = new PersistenceResourceFile(list.get(i2));
        }
        return resourceFileArray;
    }

    @Override
    public ArchiveFile createArchiveFile() throws ZipException, IOException {
        return new UrlArchiveFile(this.getURL());
    }

    @Override
    public String getPath() {
        return this.a.getPath();
    }

    @Override
    public long lastModified() {
        return this.a.lastModified();
    }

    public String toString() {
        return this.a.toString();
    }

    @Override
    @Nonnull
    public URL getURL() throws MalformedURLException {
        return this.a.toURL();
    }

    @Override
    @Nonnull
    public InputStream getInputStream() throws FileNotFoundException {
        InputStream inputStream = this.a.getInputStream();
        if (inputStream == null) {
            throw new FileNotFoundException(this.getPath());
        }
        return inputStream;
    }

    @Override
    public long length() {
        return this.a.size();
    }
}

