/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin;

import com.inet.annotations.InternalApi;
import com.inet.config.LicenseInfo;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.plugin.RemoteGuiInformation;
import com.inet.plugin.ServerPluginManager;
import com.inet.shared.utils.Version;
import java.net.URL;
import java.sql.Date;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public interface ApplicationDescription {
    @Nonnull
    public static ApplicationDescription get() {
        ApplicationDescription applicationDescription = Singleton.a;
        if (applicationDescription == null) {
            Singleton.a = applicationDescription = ServerPluginManager.getInstance().getSingleInstance(ApplicationDescription.class);
        }
        return applicationDescription;
    }

    @Nonnull
    public Version getVersion();

    @Nonnull
    public String getApplicationName();

    @Nonnull
    default public LicenseInfo validate(Map<String, String> licenseProperties) {
        String string = licenseProperties.get("displayname");
        String string2 = licenseProperties.get("expires");
        if (string2 != null) {
            string2 = DateFormat.getDateInstance().format(Date.valueOf(string2));
            if (string != null) {
                string = MessageFormat.format(string, string2);
            }
        }
        String string3 = licenseProperties.get("licensee");
        Supplier supplier = (Supplier)((Object)licenseProperties.get("error"));
        String string4 = string;
        return new LicenseInfo(() -> string4, string3, supplier, licenseProperties);
    }

    @Nullable
    default public LicenseInfo getActiveLicenseInfo(@Nonnull List<LicenseInfo> licenses) {
        for (LicenseInfo licenseInfo : licenses) {
            if (!licenseInfo.isValid()) continue;
            return licenseInfo;
        }
        return null;
    }

    public void appendTrialLicenseParameters(@Nonnull StringBuilder var1, @Nonnull ConfigStructureSettings var2);

    default public String getTrialLicenseBrowserURL() {
        return null;
    }

    @Nonnull
    public String getDefaultSupportAddress();

    public int getDefaultPort();

    default public boolean supportsMultipleConfigurations() {
        return false;
    }

    @Nonnull
    public RemoteGuiInformation getRemoteGuiInformation();

    default public int getDefaultNumberOfJobs() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Nullable
    default public URL getHelpPrintReport() {
        return null;
    }

    @Nullable
    public URL getLogoURL(int var1);

    default public String getStoreProductId() {
        return ServerPluginManager.getInstance().getCorePluginId();
    }

    public static abstract class Singleton {
        private static ApplicationDescription a;
    }
}

