/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.file;

import com.inet.cache.shutdown.ShutdownFinalizer;
import com.inet.cache.shutdown.ShutdownManager;
import com.inet.classloader.BaseLocator;
import com.inet.config.ConfigKey;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.lib.util.IOFunctions;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.persistence.file.FilePersistence;
import com.inet.plugin.ServerPluginManager;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

public class FilePersistenceFactory {
    private static long a;
    protected static String defaultAppName;
    private String b;
    private Path c;
    private String d;

    public static FilePersistenceFactory createFilePersistenceFactory(String recoveryConfiguration) throws IOException {
        Configuration configuration;
        String string;
        String string2;
        String string3;
        String string4 = string3 = defaultAppName == null ? ServerPluginManager.getInstance().getCorePluginId() : defaultAppName;
        if (string3 == null) {
            throw new IllegalStateException("Core plugin is not set" + ServerPluginManager.getDiagnostic());
        }
        if (recoveryConfiguration != null) {
            int n2 = recoveryConfiguration.indexOf(47);
            if (n2 < 0) {
                throw new IllegalArgumentException("The configuration name must be in the format scope/name, e.g. User/myConfig: " + recoveryConfiguration);
            }
            string2 = recoveryConfiguration.substring(0, n2);
            string = recoveryConfiguration.substring(n2 + 1);
            configuration = ConfigurationManager.getInstance().get(recoveryConfiguration);
        } else {
            configuration = ConfigurationManager.getInstance().getCurrent();
            string2 = ConfigurationManager.getScopeName(configuration.getScope());
            string = configuration.getName();
        }
        String string5 = configuration != null ? configuration.get(ConfigKey.APP_DATA_PATH.getKey(), null) : null;
        return new FilePersistenceFactory(string3, string2, string, string5, LogManager.getConfigLogger());
    }

    public FilePersistenceFactory(String corePluginID, String scopename, String configname, String appDataPath, @Nonnull Logger logger) throws IOException {
        String string;
        boolean bl;
        this.b = corePluginID;
        this.d = appDataPath;
        if (Objects.equals(scopename, ConfigurationManager.getScopeName(4)) && Objects.equals(configname, "<temp copy>")) {
            bl = true;
            if (a == 0L) {
                a = System.currentTimeMillis();
            }
            string = scopename + "_" + a;
        } else {
            bl = false;
            string = scopename + "_" + FilePersistenceFactory.normalizeName(configname, false);
        }
        this.b = this.b + "_" + string;
        this.a(logger);
        if (bl) {
            ShutdownManager.add(new ShutdownFinalizer(){

                @Override
                public void onShutdown() {
                    try {
                        IOFunctions.deleteDir(FilePersistenceFactory.this.c);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace(System.err);
                    }
                }

                @Override
                public int order() {
                    return 1000;
                }
            });
        }
    }

    @Nonnull
    public FilePersistence createInstance() {
        return new FilePersistence(this.c.toFile());
    }

    @Nonnull
    public Path getPersistenceFolder() {
        return this.c;
    }

    void a(Logger logger) throws IOException {
        Path path = this.getDefaultBasePath(true);
        if (!FilePersistenceFactory.b(path = path.resolve(this.b))) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        if (!FilePersistenceFactory.b(path)) {
            throw new IllegalStateException("app folder '" + String.valueOf(path) + "' could not be created");
        }
        this.c = path;
        logger.status("Initializing persistence in folder " + String.valueOf(this.c));
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="No user input is used")
    public Path getDefaultBasePath(boolean applyConfigSetting) {
        Path path;
        block15: {
            Object object;
            path = null;
            if (applyConfigSetting && (object = this.d) != null && !((String)object).trim().isEmpty()) {
                try {
                    path = Paths.get(((String)object).trim(), new String[0]);
                    if (!this.a(path)) {
                        path = null;
                    }
                }
                catch (Exception exception) {
                    LogManager.getConfigLogger().error(exception);
                }
            }
            if (path == null) {
                path = this.a(System.getenv("ProgramData"), "i-net software");
            }
            if (path == null) {
                path = this.a(System.getenv("APPDATA"), "i-net software");
            }
            if (path == null) {
                path = this.a(System.getProperty("user.home"), ".i-net software");
            }
            if (path == null) {
                try {
                    object = BaseLocator.getBaseDirectory().getURL();
                    File file = IOFunctions.getFile((URL)object);
                    if ("webapps".equalsIgnoreCase(file.getParentFile().getName())) {
                        path = this.a(file.getParent(), ".persistence");
                    }
                    if (path == null) {
                        path = this.a(file.toString(), ".persistence");
                    }
                }
                catch (Exception exception) {
                    if (!LogManager.getConfigLogger().isWarning()) break block15;
                    LogManager.getConfigLogger().warn(exception);
                }
            }
        }
        if (path == null) {
            path = this.a(System.getProperty("user.dir"), ".persistence");
        }
        if (path == null) {
            path = this.a(System.getProperty("java.io.tmpdir"), "i-net-software");
        }
        if (path == null) {
            throw new IllegalStateException("no usable directory found");
        }
        return path;
    }

    @SuppressFBWarnings(value={"COMMAND_INJECTION", "PATH_TRAVERSAL_IN"}, justification="No client parameter are used")
    private Path a(String string, String string2) {
        Path path;
        block8: {
            path = null;
            try {
                if (string == null || string.isEmpty()) break block8;
                path = Paths.get(string, new String[0]);
                if (!FilePersistenceFactory.b(path)) {
                    path = null;
                    break block8;
                }
                if (!Files.isDirectory(path = path.resolve(string2), new LinkOption[0])) {
                    Files.createDirectory(path, new FileAttribute[0]);
                    if (string.equals(System.getenv("ProgramData")) && Files.isDirectory(path, new LinkOption[0])) {
                        try {
                            Runtime.getRuntime().exec("C:\\Windows\\System32\\icacls.exe \"" + String.valueOf(path) + "\" /grant *S-1-5-32-545:(OI)(CI)(W,M)");
                        }
                        catch (IOException iOException) {
                            LogManager.getConfigLogger().error(iOException);
                        }
                    }
                }
                if (!this.a(path)) {
                    path = null;
                }
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return path;
    }

    private boolean a(Path path) {
        if (FilePersistenceFactory.b(path)) {
            Path path2 = path.resolve(this.b);
            if (!Files.exists(path2, new LinkOption[0])) {
                return true;
            }
            return FilePersistenceFactory.b(path2);
        }
        return false;
    }

    private static boolean b(Path path) {
        return Files.isDirectory(path, new LinkOption[0]) && Files.isWritable(path);
    }

    public static String normalizeName(String name, boolean stripSpecialChars) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < name.length(); ++i2) {
            char c2 = name.charAt(i2);
            if (c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || c2 == ' ' || c2 == '-' || c2 == '_' || c2 == '.') {
                stringBuilder.append(c2);
                continue;
            }
            if (stripSpecialChars) continue;
            stringBuilder.append('#');
            int n2 = Character.getNumericValue(c2);
            stringBuilder.append(n2 >= 0 ? n2 : (int)c2);
        }
        return stringBuilder.toString();
    }
}

