/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.crypto;

import com.inet.annotations.InternalApi;
import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.lib.io.FastByteArrayOutputStream;
import com.inet.lib.util.Encryption;
import com.inet.logging.LogManager;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

@InternalApi
public class EncryptionData {
    public static final byte[] PREFIX = "%inetEnc-".getBytes(StandardCharsets.UTF_8);
    public static final int CURRENT_VERSION = 1;
    public static final int CUSTOM_DATA_SIZE_LIMIT = 100000;
    private String a;
    private boolean b = false;
    private int c = 1;
    private byte[] d;
    private int e = -1;

    private EncryptionData(String algorithm) {
        this.a = algorithm;
        this.b = algorithm != null;
        this.e = this.getFileHeader().length;
    }

    public static EncryptionData create(String algorithm, byte[] customData) {
        EncryptionData encryptionData = new EncryptionData(algorithm);
        encryptionData.setCustomData(customData);
        return encryptionData;
    }

    public static EncryptionData get(InputStream in) throws IOException {
        EncryptionData encryptionData = new EncryptionData(null);
        encryptionData.a(in);
        return encryptionData;
    }

    public static EncryptionData get(byte[] in) {
        EncryptionData encryptionData = new EncryptionData(null);
        try {
            encryptionData.a(new FastByteArrayInputStream(in));
        }
        catch (IOException iOException) {
            LogManager.getApplicationLogger().error(iOException);
        }
        return encryptionData;
    }

    public byte[] getFileHeader() {
        FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream();
        try {
            this.writeHeader(fastByteArrayOutputStream);
        }
        catch (IOException iOException) {
            LogManager.getApplicationLogger().error(iOException);
        }
        return fastByteArrayOutputStream.toByteArray();
    }

    public void writeHeader(OutputStream out) throws IOException {
        if (!this.b) {
            return;
        }
        DataOutputStream dataOutputStream = new DataOutputStream(out);
        dataOutputStream.write(PREFIX);
        dataOutputStream.writeInt(this.c);
        String string = Encryption.encrypt(this.a);
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        dataOutputStream.writeInt(byArray.length);
        dataOutputStream.write(byArray);
        if (this.d != null) {
            dataOutputStream.writeInt(this.d.length);
            dataOutputStream.write(this.d);
        } else {
            dataOutputStream.writeInt(0);
        }
    }

    private void a(InputStream inputStream) throws IOException {
        int n2 = 0;
        inputStream.mark(100000);
        this.b = false;
        byte[] byArray = new byte[PREFIX.length];
        inputStream.read(byArray);
        if (!Arrays.equals(PREFIX, byArray)) {
            inputStream.reset();
            return;
        }
        n2 += byArray.length;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        this.c = dataInputStream.readInt();
        n2 += 4;
        int n3 = dataInputStream.readInt();
        n2 += 4;
        if (n3 > 100000) {
            inputStream.reset();
            return;
        }
        byte[] byArray2 = new byte[n3];
        int n4 = dataInputStream.read(byArray2);
        if (n4 < n3) {
            inputStream.reset();
            return;
        }
        n2 += n4;
        this.a = Encryption.decrypt(new String(byArray2));
        n3 = dataInputStream.readInt();
        n2 += 4;
        if (n3 > 100000) {
            inputStream.reset();
            return;
        }
        this.d = new byte[n3];
        n4 = dataInputStream.read(this.d);
        n2 += n4;
        if (n4 < n3) {
            inputStream.reset();
            return;
        }
        this.e = n2;
        this.b = true;
    }

    public boolean isEncrypted() {
        return this.b;
    }

    public String getAlgorithm() {
        return this.a;
    }

    public int getVersion() {
        return this.c;
    }

    public byte[] getCustomData() {
        return this.d;
    }

    public void setCustomData(byte[] customData) {
        this.d = customData;
        this.e = -1;
    }

    public int getHeaderSize() {
        if (this.e < 0) {
            this.e = this.getFileHeader().length;
        }
        return this.e;
    }
}

