/*
 * Decompiled with CFR 0.152.
 */
package com.inet.permissions;

import com.inet.annotations.InternalApi;
import com.inet.authentication.LoginProcessor;
import com.inet.authentication.base.LoginManager;
import com.inet.http.PluginDispatcherServlet;
import com.inet.http.PluginServlet;
import com.inet.http.servlet.SessionStore;
import com.inet.lib.util.EncodingFunctions;
import com.inet.permissions.AnonymousLoginProcessor;
import com.inet.shared.servlet.ServletUtils;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class AnonymousServlet
extends HttpServlet
implements PluginServlet {
    public static final String PUBLIC = "/public";
    private static final int PUBLIC_LENGTH = "/public".length();

    @Override
    @Nonnull
    public String getPathSpec() {
        return PUBLIC;
    }

    @Override
    @SuppressFBWarnings(value={"UNVALIDATED_REDIRECT"}, justification="Validation occur in ServletUtils.createRedirectURL")
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String string;
        if (!LoginManager.isGuestAccount()) {
            Object object = request.getRequestURL().toString();
            String string2 = request.getPathInfo();
            if (string2 != null) {
                string2 = EncodingFunctions.encodeUrlPath(string2);
                int n2 = ((String)object).length() - string2.length();
                object = ((String)object).substring(0, n2 - PUBLIC_LENGTH) + string2;
            } else {
                object = ((String)object).substring(0, ((String)object).length() - PUBLIC_LENGTH);
            }
            object = ServletUtils.createRedirectURL(request, (String)object);
            response.sendRedirect((String)object);
            return;
        }
        LoginProcessor loginProcessor = LoginProcessor.getCurrent();
        if (loginProcessor != null) {
            loginProcessor = loginProcessor.unwrap(AnonymousLoginProcessor.class);
        }
        if (!(loginProcessor instanceof AnonymousLoginProcessor || (string = request.getRequestURI()).contains("/logout/") || string.contains("/logout-"))) {
            loginProcessor = new AnonymousLoginProcessor();
            LoginManager.setCurrentLoginProcessor(request, loginProcessor);
            LoginManager.initUserAccount(request.getSession());
        }
        if ((string = request.getPathInfo()) == null) {
            string = "/";
        }
        request = new HttpServletRequestWrapper((HttpServletRequest)request){

            public String getContextPath() {
                return super.getContextPath() + AnonymousServlet.PUBLIC;
            }
        };
        SessionStore.setHttpServletRequest(request);
        switch (string) {
            case "/favicon.ico": {
                PluginDispatcherServlet.sendFavicon(request, response, false);
                return;
            }
            case "/favicon.icns": {
                PluginDispatcherServlet.sendFavicon(request, response, true);
                return;
            }
        }
        this.forward(string, (HttpServletRequest)request, response);
    }

    protected void forward(String path, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PluginDispatcherServlet.forward(path, request, response);
    }
}

