/*
 * Decompiled with CFR 0.152.
 */
package com.inet.notification;

import com.inet.classloader.I18nMessages;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.notification.Notification;
import com.inet.notification.NotificationDispatcher;
import com.inet.notification.NotificationGenerator;
import com.inet.notification.NotificationGeneratorCache;
import com.inet.notification.NotificationGroup;
import com.inet.notification.NotificationSettings;
import com.inet.notification.NotificationTimer;
import com.inet.notification.TimedGenerator;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.command.ApiSearchCommandBuilder;
import com.inet.search.command.SearchCommand;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;

public class NotificationManager {
    private static NotificationManager a;
    private ConcurrentHashMap<GUID, NotificationGenerator> b = new ConcurrentHashMap();
    private NotificationTimer c = new NotificationTimer();
    private NotificationGeneratorCache d = new NotificationGeneratorCache();
    public static final I18nMessages I18N;

    private NotificationManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NotificationManager getInstance() {
        if (a != null) return a;
        Class<NotificationManager> clazz = NotificationManager.class;
        synchronized (NotificationManager.class) {
            if (a != null) return a;
            a = new NotificationManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return a;
        }
    }

    public void sendNotification(GUID userId, Notification notification) {
        this.a(userId, notification, false);
    }

    private void a(GUID gUID, Notification notification, boolean bl) {
        List<NotificationDispatcher> list = ServerPluginManager.getInstance().get(NotificationDispatcher.class);
        if (list.isEmpty()) {
            return;
        }
        UserAccount userAccount = UserManager.getInstance().getUserAccount(gUID);
        if (userAccount == null || !userAccount.isActive()) {
            return;
        }
        String string = userAccount.getValue(UsersAndGroups.FIELD_NOTIFICATIONSETTINGS);
        NotificationSettings notificationSettings = new NotificationSettings(null, true);
        if (!StringFunctions.isEmpty(string)) {
            try {
                notificationSettings = new Json().fromJson(string, NotificationSettings.class);
            }
            catch (JsonException jsonException) {
                // empty catch block
            }
        }
        Map<String, Map<String, Boolean>> map = notificationSettings.getActiveStatesMap();
        for (NotificationDispatcher notificationDispatcher : list) {
            Object object;
            Boolean bl2 = null;
            if (notification.getGroupingKey() != null && map != null && (object = map.get(notification.getGroupingKey())) != null) {
                bl2 = object.get(notificationDispatcher.getExtensionName());
            }
            if (bl2 == null) {
                if (notificationDispatcher.isForWebNotifications()) {
                    if (notification.getGroupingKey() != null) {
                        object = null;
                        try {
                            object = ServerPluginManager.getInstance().getSingleInstanceByName(NotificationGroup.class, notification.getGroupingKey(), false);
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                        bl2 = object != null ? Boolean.valueOf(object.isDefaultActiveForWebnotifications()) : Boolean.TRUE;
                    } else {
                        bl2 = Boolean.TRUE;
                    }
                } else {
                    bl2 = Boolean.FALSE;
                }
            }
            if (!bl2.booleanValue()) continue;
            try {
                notificationDispatcher.dispatchNotification(gUID, notification, bl);
            }
            catch (Throwable throwable) {
                LogManager.getApplicationLogger().error(throwable);
            }
        }
    }

    public Set<GUID> getActiveGeneratorIds() {
        return new HashSet<GUID>(this.b.keySet());
    }

    public NotificationGenerator getGenerator(GUID generatorId) {
        return this.b.get(generatorId);
    }

    public NotificationGeneratorCache getNotificationGeneratorCache() {
        return this.d;
    }

    public void registerGenerator(@Nonnull NotificationGenerator generator) {
        NotificationGenerator notificationGenerator = this.b.get(generator.getId());
        if (notificationGenerator != null) {
            if (Objects.equals(notificationGenerator.getPeriodKey(), generator.getPeriodKey())) {
                return;
            }
            this.unregisterGenerator(generator.getId());
        }
        if (generator instanceof TimedGenerator) {
            this.c.a((NotificationGenerator)((Object)((TimedGenerator)((Object)generator))));
            return;
        }
        this.a(generator);
    }

    public void unregisterGenerator(@Nonnull GUID generatorId) {
        this.c.unregisterTimedGenerator(generatorId);
        this.a(generatorId);
    }

    public void clearGeneratorState(@Nonnull GUID generatorId) {
        this.d.clearGeneratorCache(generatorId);
    }

    void a(@Nonnull NotificationGenerator notificationGenerator) {
        this.b.put(notificationGenerator.getId(), notificationGenerator);
        ForkJoinPool.commonPool().execute(() -> {
            if (!this.b.containsKey(notificationGenerator.getId())) {
                return;
            }
            Set<GUID> set = notificationGenerator.filterUserIdsByGroupingKey();
            Set<GUID> set2 = notificationGenerator.getTargetUserIds(set);
            HashSet<GUID> hashSet = new HashSet<GUID>();
            if (set2 != null) {
                for (GUID gUID : set2) {
                    if (this.d.isEvaluated(notificationGenerator, gUID, NotificationGeneratorCache.DispatcherType.external)) continue;
                    hashSet.add(gUID);
                    try (UserAccountScope userAccountScope = UserAccountScope.create(gUID);){
                        Notification notification = notificationGenerator.createNotification();
                        notification.setFromGenerator(true);
                        notification.setId(notificationGenerator.getId());
                        notification.setGroupingKey(notificationGenerator.getGroupingKey());
                        this.a(gUID, notification, true);
                    }
                }
            }
            if (!hashSet.isEmpty()) {
                this.d.setGeneratorEvaluated(notificationGenerator.getId(), hashSet, NotificationGeneratorCache.DispatcherType.external);
            }
        });
    }

    void a(@Nonnull GUID gUID) {
        NotificationGenerator notificationGenerator = this.b.remove(gUID);
        if (notificationGenerator == null) {
            return;
        }
        this.clearGeneratorState(gUID);
        List<NotificationDispatcher> list = ServerPluginManager.getInstance().get(NotificationDispatcher.class);
        if (!list.isEmpty()) {
            for (NotificationDispatcher notificationDispatcher : list) {
                notificationDispatcher.generatorDeactivated(notificationGenerator);
            }
        }
    }

    public void sendNotificationToAllAdministrators(@Nonnull Notification notification) {
        Object object;
        boolean bl;
        UserGroupManager userGroupManager = UserGroupManager.getInstance();
        UserGroupInfo userGroupInfo = userGroupManager.getGroup(UsersAndGroups.GROUP_ALLUSERS);
        boolean bl2 = bl = SystemPermissionChecker.SYSTEMPERMISSION_ENABLED.get() == false || userGroupInfo.getPermissions().contains(Permission.CONFIGURATION);
        if (bl) {
            return;
        }
        HashSet<GUID> hashSet = new HashSet<GUID>();
        Set<GUID> set = userGroupManager.getSearchEngine().simpleSearch(this.a(true));
        for (GUID object22 : set) {
            object = userGroupManager.getGroup(object22);
            if (object == null || !((UserGroupInfo)object).isActive()) continue;
            hashSet.addAll(((UserGroupInfo)object).getMemberIDs());
        }
        UserManager userManager = UserManager.getInstance();
        SearchCommand searchCommand = this.a(false);
        object = userManager.getSearchEngine().simpleSearch(searchCommand);
        hashSet.addAll((Collection<GUID>)object);
        for (GUID gUID : hashSet) {
            this.sendNotification(gUID, notification);
        }
    }

    private SearchCommand a(boolean bl) {
        ApiSearchCommandBuilder apiSearchCommandBuilder = new ApiSearchCommandBuilder().equals("permissions", Permission.CONFIGURATION.getKey()).or();
        if (bl) {
            apiSearchCommandBuilder.equals("grouptype", UsersAndGroups.GROUPTYPE_ADMIN.getName());
        } else {
            apiSearchCommandBuilder.equals("useraccounttype", UserAccountType.Administrator.name());
        }
        return apiSearchCommandBuilder.build();
    }

    static {
        I18N = new I18nMessages("com.inet.notification.i18n.Notification", NotificationManager.class);
    }
}

